/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.reactivestreams.Publisher;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveCrudService<E, K> {
    public ReactiveRepository<E, K> getRepository();

    default public ReactiveQuery<E> createQuery() {
        return this.getRepository().createQuery();
    }

    default public ReactiveUpdate<E> createUpdate() {
        return this.getRepository().createUpdate();
    }

    default public ReactiveDelete createDelete() {
        return this.getRepository().createDelete();
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Mono<E> findById(K id) {
        return this.getRepository().findById(id);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Flux<E> findById(Collection<K> publisher) {
        return this.getRepository().findById(publisher);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Mono<E> findById(Mono<K> publisher) {
        return this.getRepository().findById(publisher);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Flux<E> findById(Flux<K> publisher) {
        return this.getRepository().findById(publisher);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<SaveResult> save(Publisher<E> entityPublisher) {
        return this.getRepository().save(entityPublisher);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<SaveResult> save(E data) {
        return this.getRepository().save(data);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<SaveResult> save(Collection<E> collection) {
        return this.getRepository().save(collection);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> updateById(K id, Mono<E> entityPublisher) {
        return this.getRepository().updateById(id, entityPublisher);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> updateById(K id, E data) {
        return this.getRepository().updateById(id, Mono.just(data));
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> insertBatch(Publisher<? extends Collection<E>> entityPublisher) {
        return this.getRepository().insertBatch(entityPublisher);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> insert(Publisher<E> entityPublisher) {
        return this.getRepository().insert(entityPublisher);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> insert(E data) {
        return this.getRepository().insert((Publisher)Mono.just(data));
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> deleteById(Publisher<K> idPublisher) {
        return this.getRepository().deleteById(idPublisher);
    }

    @Transactional(transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> deleteById(K id) {
        return this.getRepository().deleteById((Publisher)Mono.just(id));
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Flux<E> query(Mono<? extends QueryParamEntity> queryParamMono) {
        return queryParamMono.flatMapMany(this::query);
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Flux<E> query(QueryParamEntity param) {
        return ((ReactiveQuery)this.getRepository().createQuery().setParam((QueryParam)param)).fetch();
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Mono<PagerResult<E>> queryPager(QueryParamEntity queryParamMono) {
        return this.queryPager(queryParamMono, Function.identity());
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public <T> Mono<PagerResult<T>> queryPager(QueryParamEntity query, Function<E, T> mapper) {
        if (query.getTotal() != null) {
            return ((ReactiveQuery)this.getRepository().createQuery().setParam(query.rePaging(query.getTotal().intValue()))).fetch().map(mapper).collectList().map(list -> PagerResult.of((int)query.getTotal(), (List)list, (QueryParam)query));
        }
        if (query.isParallelPager()) {
            return Mono.zip((Mono)((ReactiveQuery)this.createQuery().setParam((QueryParam)query.clone())).count(), (Mono)((ReactiveQuery)this.createQuery().setParam((QueryParam)query.clone())).fetch().map(mapper).collectList(), (total, data) -> PagerResult.of((int)total, (List)data, (QueryParam)query));
        }
        return ((ReactiveQuery)this.getRepository().createQuery().setParam((QueryParam)query.clone())).count().flatMap(total -> {
            if (total == 0) {
                return Mono.just((Object)PagerResult.of((int)0, new ArrayList(), (QueryParam)query));
            }
            QueryParamEntity rePagingQuery = (QueryParamEntity)query.clone().rePaging(total.intValue());
            return this.query(rePagingQuery).map(mapper).collectList().map(list -> PagerResult.of((int)total, (List)list, (QueryParam)rePagingQuery));
        });
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public <T> Mono<PagerResult<T>> queryPager(Mono<? extends QueryParamEntity> queryParamMono, Function<E, T> mapper) {
        return queryParamMono.cast(QueryParamEntity.class).flatMap(param -> this.queryPager((QueryParamEntity)param, mapper));
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Mono<PagerResult<E>> queryPager(Mono<? extends QueryParamEntity> queryParamMono) {
        return this.queryPager(queryParamMono, Function.identity());
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> count(QueryParamEntity queryParam) {
        return ((ReactiveQuery)this.getRepository().createQuery().setParam((QueryParam)queryParam)).count();
    }

    @Transactional(readOnly=true, transactionManager="connectionFactoryTransactionManager")
    default public Mono<Integer> count(Mono<? extends QueryParamEntity> queryParamMono) {
        return queryParamMono.flatMap(this::count);
    }
}

