/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.crud.events;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hswebframework.ezorm.rdb.events.EventContext;
import org.hswebframework.ezorm.rdb.events.EventListener;
import org.hswebframework.ezorm.rdb.events.EventType;
import org.springframework.core.Ordered;

public class CompositeEventListener
implements EventListener {
    private List<EventListener> eventListeners = new CopyOnWriteArrayList<EventListener>();

    public void onEvent(EventType type, EventContext context) {
        for (EventListener eventListener : this.eventListeners) {
            eventListener.onEvent(type, context);
        }
    }

    public void addListener(EventListener eventListener) {
        this.eventListeners.add(eventListener);
        this.eventListeners.sort(Comparator.comparingLong(e -> e instanceof Ordered ? (long)((Ordered)e).getOrder() : Integer.MAX_VALUE));
    }

    public List<EventListener> getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(List<EventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }
}

