/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.csv;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.csv.CharsetOption;
import org.hswebframework.reactor.excel.csv.CsvCell;
import org.hswebframework.reactor.excel.spi.ExcelReader;
import reactor.core.publisher.Flux;

public class CsvReader
implements ExcelReader {
    private static final Charset DEFAULT_GB_CHARSET;

    @Override
    public String[] getSupportFormat() {
        return new String[]{"csv"};
    }

    private InputStream transformInputStream(InputStream stream) {
        if (stream instanceof BufferedInputStream) {
            return stream;
        }
        return new BufferedInputStream(stream);
    }

    public Flux<CsvCell> read(InputStream inputStream, ExcelOption ... options) {
        return Flux.create(sink -> {
            InputStream buffered = this.transformInputStream(inputStream);
            try (CSVParser parser = CSVFormat.EXCEL.parse((Reader)new InputStreamReader(buffered, this.detectCharset(buffered, options)));){
                int rowIndex = 0;
                for (CSVRecord record : parser) {
                    if (sink.isCancelled()) break;
                    int last = record.size() - 1;
                    for (int i = 0; i < last; ++i) {
                        sink.next((Object)new CsvCell(rowIndex, i, this.getText(record.get(i)), false));
                    }
                    sink.next((Object)new CsvCell(rowIndex, last, this.getText(record.get(last)), true));
                    ++rowIndex;
                }
                sink.complete();
            }
            catch (Throwable err) {
                sink.error(err);
            }
        });
    }

    private String getText(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        char first = text.charAt(0);
        switch (first) {
            case '\ufeff': 
            case '\ufffe': {
                return text.substring(1);
            }
        }
        return text;
    }

    protected Charset detectCharset(InputStream inputStream, ExcelOption ... options) {
        try {
            Charset charset;
            for (ExcelOption option : options) {
                if (!option.isWrapFor(CharsetOption.class)) continue;
                return option.unwrap(CharsetOption.class).getCharset();
            }
            CharsetDetector detector = new CharsetDetector();
            detector.setText(inputStream);
            CharsetMatch match = detector.detect();
            if (match != null && !StandardCharsets.UTF_8.equals(charset = Charset.forName(match.getName()))) {
                return DEFAULT_GB_CHARSET;
            }
        }
        catch (Throwable detector) {
            // empty catch block
        }
        return StandardCharsets.UTF_8;
    }

    @Override
    public boolean isSupportMultiSheet() {
        return false;
    }

    static {
        String[] charsets;
        Charset temp = null;
        for (String charset : charsets = new String[]{"GB18030", "GBK", "GB2312"}) {
            try {
                if (Charset.isSupported(charset)) {
                    temp = Charset.forName(charset);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (temp != null) break;
        }
        DEFAULT_GB_CHARSET = temp;
    }
}

