/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.converter;

import java.util.Optional;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.CellDataType;
import org.hswebframework.reactor.excel.ExcelHeader;
import org.hswebframework.reactor.excel.OptionSupport;
import org.hswebframework.reactor.excel.Options;
import org.hswebframework.reactor.excel.WritableCell;

public class SimpleWritableCell
implements WritableCell,
OptionSupport {
    private final CellDataType type;
    public Object value;
    private final long rowIndex;
    private final int columnIndex;
    private final boolean endOfRow;
    private final int sheetIndex;
    private final Options options = Options.of();

    @Override
    public Options options() {
        return this.options;
    }

    public SimpleWritableCell(ExcelHeader header, Object value, long rowIndex, int columnIndex, boolean endOfRow, int sheetIndex) {
        this(header.getType(), value, rowIndex, columnIndex, endOfRow, sheetIndex);
    }

    public SimpleWritableCell(CellDataType dataType, Object value, long rowIndex, int columnIndex, boolean endOfRow, int sheetIndex) {
        this.type = dataType;
        this.value = value;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.endOfRow = endOfRow;
        this.sheetIndex = sheetIndex;
    }

    public SimpleWritableCell(Cell cell, int sheetIndex) {
        this(cell.getType(), cell.value().orElse(null), cell.getRowIndex(), cell.getColumnIndex(), cell.isEndOfRow(), sheetIndex);
        if (cell instanceof WritableCell) {
            this.options().merge(((WritableCell)cell).options());
        }
    }

    @Override
    public Optional<Object> value() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public CellDataType getType() {
        return this.type;
    }

    @Override
    public long getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public boolean isEndOfRow() {
        return this.endOfRow;
    }

    @Override
    public int getSheetIndex() {
        return this.sheetIndex;
    }
}

