/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.Options;

class DefaultOptions
implements Options {
    private final List<ExcelOption> options = new ArrayList<ExcelOption>();

    DefaultOptions() {
    }

    DefaultOptions(List<ExcelOption> options) {
        this.options.addAll((Collection<ExcelOption>)Objects.requireNonNull(options, "options can not be null"));
    }

    @Override
    public List<ExcelOption> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    @Override
    public <T extends ExcelOption> List<T> getOptions(Class<T> type) {
        ArrayList opts = new ArrayList();
        this.handleOptions(type, opts::add);
        return opts;
    }

    @Override
    public <T extends ExcelOption> void handleOptions(Class<T> type, Consumer<T> consumer) {
        for (ExcelOption option : this.options) {
            if (!option.isWrapFor(type)) continue;
            consumer.accept(option.unwrap(type));
        }
    }

    @Override
    public Options option(ExcelOption option) {
        this.options.add(option);
        return this;
    }

    @Override
    public Options merge(Options options) {
        return this.merge(options.getOptions());
    }

    @Override
    public Options merge(List<ExcelOption> options) {
        this.options.addAll(options);
        return this;
    }
}

