/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.hswebframework.utils.StringUtils;

public class PinyinUtils {
    public static String toPingYin(String str) {
        char[] t1 = str.toCharArray();
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_V);
        StringBuilder t4 = new StringBuilder();
        try {
            for (char c : t1) {
                if (StringUtils.containsChineseChar(Character.toString(c))) {
                    String[] t2 = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)t3);
                    t4.append(t2[0]);
                    continue;
                }
                t4.append(c);
            }
            return t4.toString();
        }
        catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            return t4.toString();
        }
    }

    public static String toPinYinHeadChar(String str) {
        StringBuilder convert = new StringBuilder();
        for (int j = 0; j < str.length(); ++j) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            if (pinyinArray != null) {
                convert.append(pinyinArray[0].charAt(0));
                continue;
            }
            convert.append(word);
        }
        return convert.toString();
    }
}

