/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.jetty;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.internal.util.JdkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyArtifactResolver {
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> repositories;
    private ArtifactFactory artifactFactory;
    private Map<String, List<Dependency>> jettyDependencies = new HashMap<String, List<Dependency>>();
    private JdkUtils jdkUtils = new JdkUtils();

    public JettyArtifactResolver(ArtifactResolver artifactResolver, ArtifactRepository localRepository, List<ArtifactRepository> repositories, ArtifactFactory artifactFactory) {
        this.artifactResolver = artifactResolver;
        this.localRepository = localRepository;
        this.repositories = repositories;
        this.artifactFactory = artifactFactory;
        ArrayList<Dependency> jetty4xDependencies = new ArrayList<Dependency>();
        jetty4xDependencies.add(new Dependency("ant", "ant", "1.6.4"));
        jetty4xDependencies.add(new Dependency("jetty", "org.mortbay.jetty", "4.2.27"));
        jetty4xDependencies.add(new Dependency("javax.servlet", "servlet-api", "2.4"));
        jetty4xDependencies.add(new Dependency("javax.servlet", "jsp-api", "2.0"));
        jetty4xDependencies.add(new Dependency("tomcat", "jasper-compiler", "4.1.30"));
        jetty4xDependencies.add(new Dependency("tomcat", "jasper-runtime", "4.1.30"));
        ArrayList<Dependency> jetty5xDependencies = new ArrayList<Dependency>();
        jetty5xDependencies.add(new Dependency("jetty", "org.mortbay.jetty", "5.1.12"));
        jetty5xDependencies.add(new Dependency("javax.servlet", "servlet-api", "2.4"));
        jetty5xDependencies.add(new Dependency("javax.servlet", "jsp-api", "2.0"));
        jetty5xDependencies.add(new Dependency("ant", "ant", "1.6.4"));
        jetty5xDependencies.add(new Dependency("xerces", "xercesImpl", "2.6.2"));
        jetty5xDependencies.add(new Dependency("xerces", "xmlParserAPIs", "2.6.2"));
        jetty5xDependencies.add(new Dependency("tomcat", "jasper-compiler", "5.5.12"));
        jetty5xDependencies.add(new Dependency("tomcat", "jasper-runtime", "5.5.12"));
        jetty5xDependencies.add(new Dependency("commons-el", "commons-el", "1.0"));
        jetty5xDependencies.add(new Dependency("commons-logging", "commons-logging", "1.0.4"));
        ArrayList<Dependency> jetty6xDependencies = new ArrayList<Dependency>();
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "jsp-api-2.0", "6.1.26"));
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "servlet-api-2.5", "6.1.14"));
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "jetty", "6.1.26"));
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "jetty-util", "6.1.26"));
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "jetty-naming", "6.1.26"));
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "jetty-plus", "6.1.26"));
        jetty6xDependencies.add(new Dependency("ant", "ant", "1.6.5"));
        jetty6xDependencies.add(new Dependency("commons-el", "commons-el", "1.0"));
        jetty6xDependencies.add(new Dependency("tomcat", "jasper-compiler", "5.5.15"));
        jetty6xDependencies.add(new Dependency("tomcat", "jasper-runtime", "5.5.15"));
        jetty6xDependencies.add(new Dependency("tomcat", "jasper-compiler-jdt", "5.5.15"));
        jetty6xDependencies.add(new Dependency("javax.mail", "mail", "1.4"));
        jetty6xDependencies.add(new Dependency("javax.activation", "activation", "1.1"));
        jetty6xDependencies.add(new Dependency("geronimo-spec", "geronimo-spec-jta", "1.0.1B-rc4"));
        jetty6xDependencies.add(new Dependency("xerces", "xercesImpl", "2.6.2"));
        jetty6xDependencies.add(new Dependency("xerces", "xmlParserAPIs", "2.6.2"));
        jetty6xDependencies.add(new Dependency("commons-logging", "commons-logging", "1.0.4"));
        jetty6xDependencies.add(new Dependency("log4j", "log4j", "1.2.14"));
        ArrayList<Dependency> jetty7xDependencies = new ArrayList<Dependency>();
        jetty7xDependencies.add(new Dependency("javax.servlet", "servlet-api", "2.5"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jdt.core.compiler", "ecj", "3.5.1"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-continuation", "7.6.4.v20120524"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-http", "7.6.4.v20120524"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-io", "7.6.4.v20120524"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-jsp", "7.6.4.v20120524"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-util", "7.6.4.v20120524"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-security", "7.6.4.v20120524"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-server", "7.6.4.v20120524"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-servlet", "7.6.4.v20120524"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-webapp", "7.6.4.v20120524"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-xml", "7.6.4.v20120524"));
        jetty7xDependencies.add(new Dependency("org.mortbay.jetty", "jsp-api-2.1-glassfish", "2.1.v20100127"));
        jetty7xDependencies.add(new Dependency("org.mortbay.jetty", "jsp-2.1-glassfish", "2.1.v20100127"));
        ArrayList<Dependency> jetty8xDependencies = new ArrayList<Dependency>();
        jetty8xDependencies.add(new Dependency("org.mortbay.jetty", "servlet-api", "3.0.20100224"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-continuation", "8.1.4.v20120524"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-http", "8.1.4.v20120524"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-io", "8.1.4.v20120524"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-util", "8.1.4.v20120524"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-security", "8.1.4.v20120524"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-server", "8.1.4.v20120524"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-servlet", "8.1.4.v20120524"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-webapp", "8.1.4.v20120524"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-xml", "8.1.4.v20120524"));
        jetty8xDependencies.add(new Dependency("javax.el", "el-api", "2.2"));
        jetty8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jsp-api", "7.0.29"));
        jetty8xDependencies.add(new Dependency("org.glassfish.web", "jsp-impl", "2.2.1"));
        this.jettyDependencies.put("jetty4x", jetty4xDependencies);
        this.jettyDependencies.put("jetty5x", jetty5xDependencies);
        this.jettyDependencies.put("jetty6x", jetty6xDependencies);
        this.jettyDependencies.put("jetty7x", jetty7xDependencies);
        this.jettyDependencies.put("jetty8x", jetty8xDependencies);
    }

    public ClassLoader resolveDependencies(String jettyContainerId, ClassLoader parent) throws MojoExecutionException {
        URLClassLoader classloader;
        try {
            List<Dependency> dependencies = this.jettyDependencies.get(jettyContainerId);
            ArrayList<URL> urls = new ArrayList<URL>(dependencies.size() + 1);
            for (Dependency dependency : dependencies) {
                Artifact artifact = this.artifactFactory.createArtifact(dependency.groupId, dependency.artifactId, dependency.version, "compile", "jar");
                this.artifactResolver.resolve(artifact, this.repositories, this.localRepository);
                urls.add(artifact.getFile().toURI().toURL());
            }
            if (!this.jdkUtils.isOSX()) {
                urls.add(this.jdkUtils.getToolsJar().toURI().toURL());
            }
            URL[] urlArray = urls.toArray(new URL[urls.size()]);
            classloader = parent == null ? new URLClassLoader(urlArray) : new URLClassLoader(urlArray, parent);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve dependency", e);
        }
        return classloader;
    }

    private class Dependency {
        public String groupId;
        public String artifactId;
        public String version;

        public Dependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }
    }
}

