/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.maven2.AbstractContainerStartMojo;
import org.codehaus.cargo.maven2.configuration.Container;
import org.codehaus.cargo.maven2.configuration.ZipUrlInstaller;

public class ContainerRunMojo
extends AbstractContainerStartMojo {
    private String containerId;
    private String containerUrl;

    public void doExecute() throws MojoExecutionException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    if (ContainerRunMojo.this.localContainer != null && (State.STARTED == ContainerRunMojo.this.localContainer.getState() || State.STARTING == ContainerRunMojo.this.localContainer.getState())) {
                        ContainerRunMojo.this.localContainer.stop();
                    }
                }
                catch (Exception e) {
                    ContainerRunMojo.this.getLog().warn((CharSequence)"Failed stopping the container", (Throwable)e);
                }
            }
        });
        super.doExecute();
        this.getLog().info((CharSequence)"Press Ctrl-C to stop the container...");
        ContainerUtils.waitTillContainerIsStopped((org.codehaus.cargo.container.Container)this.localContainer);
    }

    protected org.codehaus.cargo.container.Container createNewContainer() throws MojoExecutionException {
        if (this.containerId != null && this.containerUrl == null) {
            throw new MojoExecutionException("If you specify a containerId, you also need to specify a containerUrl.");
        }
        Container containerElement = this.getContainerElement();
        if (this.containerId != null) {
            if (containerElement == null) {
                containerElement = new Container();
                this.setContainerElement(containerElement);
            }
            containerElement.setContainerId(this.containerId);
            containerElement.setType(ContainerType.INSTALLED);
            containerElement.setHome(null);
        }
        if (this.containerUrl != null) {
            if (containerElement == null) {
                throw new MojoExecutionException("If containerUrl is specified alone, an associated <container> element must also be defined in the configuration. Alternatively, you can also define a containerId.");
            }
            containerElement.setType(ContainerType.INSTALLED);
            containerElement.setHome(null);
            ZipUrlInstaller zipUrlInstaller = containerElement.getZipUrlInstaller();
            if (zipUrlInstaller == null) {
                zipUrlInstaller = new ZipUrlInstaller();
                containerElement.setZipUrlInstaller(zipUrlInstaller);
            }
            try {
                URL url = new URL(this.containerUrl);
                zipUrlInstaller.setUrl(url);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid containerUrl", (Exception)e);
            }
            zipUrlInstaller.setExtractDir(null);
        }
        return super.createNewContainer();
    }
}

