/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_imgproc;

import java.util.Arrays;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.presets.opencv_imgproc;

@Name(value={"std::vector<cv::Vec4f>"})
@Properties(inherit={opencv_imgproc.class})
public class Vec4fVector
extends Pointer {
    public Vec4fVector(Pointer p) {
        super(p);
    }

    public Vec4fVector(FloatPointer value) {
        this(1L);
        this.put(0L, value);
    }

    public Vec4fVector(FloatPointer ... array) {
        this(array.length);
        this.put(array);
    }

    public Vec4fVector() {
        this.allocate();
    }

    public Vec4fVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator="})
    @ByRef
    public native Vec4fVector put(@ByRef Vec4fVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @Cast(value={"cv::Vec4f*"})
    @ByRef
    public native FloatPointer get(@Cast(value={"size_t"}) long var1);

    public native Vec4fVector put(@Cast(value={"size_t"}) long var1, FloatPointer var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @Cast(value={"cv::Vec4f*"}) @ByRef FloatPointer var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public FloatPointer[] get() {
        FloatPointer[] array = new FloatPointer[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public FloatPointer pop_back() {
        long size = this.size();
        FloatPointer value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public Vec4fVector push_back(FloatPointer value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public Vec4fVector put(FloatPointer value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public Vec4fVector put(FloatPointer ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator=="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator*"})
        @Cast(value={"cv::Vec4f*"})
        @ByRef
        @Const
        public native FloatPointer get();
    }
}

