/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.indexer.UByteIndexer;

public class UByteBufferIndexer
extends UByteIndexer {
    protected ByteBuffer buffer;

    public UByteBufferIndexer(ByteBuffer buffer, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public int get(int i) {
        return this.buffer.get(i) & 0xFF;
    }

    @Override
    public UByteIndexer get(int i, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.buffer.get(i * this.strides[0] + n) & 0xFF;
        }
        return this;
    }

    @Override
    public int get(int i, int j) {
        return this.buffer.get(i * this.strides[0] + j) & 0xFF;
    }

    @Override
    public UByteIndexer get(int i, int j, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.buffer.get(i * this.strides[0] + j * this.strides[1] + n) & 0xFF;
        }
        return this;
    }

    @Override
    public int get(int i, int j, int k) {
        return this.buffer.get(i * this.strides[0] + j * this.strides[1] + k) & 0xFF;
    }

    @Override
    public int get(int ... indices) {
        return this.buffer.get(this.index(indices)) & 0xFF;
    }

    @Override
    public UByteIndexer get(int[] indices, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.buffer.get(this.index(indices) + n) & 0xFF;
        }
        return this;
    }

    @Override
    public UByteIndexer put(int i, int b) {
        this.buffer.put(i, (byte)b);
        return this;
    }

    @Override
    public UByteIndexer put(int i, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + n, (byte)b[offset + n]);
        }
        return this;
    }

    @Override
    public UByteIndexer put(int i, int j, int b) {
        this.buffer.put(i * this.strides[0] + j, (byte)b);
        return this;
    }

    @Override
    public UByteIndexer put(int i, int j, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + j * this.strides[1] + n, (byte)b[offset + n]);
        }
        return this;
    }

    @Override
    public UByteIndexer put(int i, int j, int k, int b) {
        this.buffer.put(i * this.strides[0] + j * this.strides[1] + k, (byte)b);
        return this;
    }

    @Override
    public UByteIndexer put(int[] indices, int b) {
        this.buffer.put(this.index(indices), (byte)b);
        return this;
    }

    @Override
    public UByteIndexer put(int[] indices, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(this.index(indices) + n, (byte)b[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

