/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.web;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ProviderWithDependencies;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.apache.shiro.guice.web.SimpleFilterChainResolver;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class FilterChainResolverProvider
implements ProviderWithDependencies<FilterChainResolver> {
    @Inject
    Injector injector;
    private final Map<String, Key<? extends Filter>[]> chains;
    private final Set<Dependency<?>> dependencies;
    private PatternMatcher patternMatcher = new AntPathMatcher();

    public FilterChainResolverProvider(Map<String, Key<? extends Filter>[]> chains) {
        this.chains = chains;
        ImmutableSet.Builder dependenciesBuilder = ImmutableSet.builder();
        for (String chain : chains.keySet()) {
            for (Key<? extends Filter> filterKey : chains.get(chain)) {
                dependenciesBuilder.add((Object)Dependency.get(filterKey));
            }
        }
        this.dependencies = dependenciesBuilder.build();
    }

    @Inject(optional=true)
    public void setPatternMatcher(PatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }

    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public FilterChainResolver get() {
        return new SimpleFilterChainResolver(this.chains, this.injector, this.patternMatcher);
    }
}

