/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.datasource.config.impl;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlJdbcConfiguration;
import org.apache.shardingsphere.data.pipeline.spi.datasource.JdbcQueryPropertiesExtension;
import org.apache.shardingsphere.data.pipeline.spi.datasource.JdbcQueryPropertiesExtensionFactory;
import org.apache.shardingsphere.infra.database.metadata.url.JdbcUrlAppender;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;

public final class StandardPipelineDataSourceConfiguration
implements PipelineDataSourceConfiguration {
    public static final String TYPE = "JDBC";
    private static final String DATA_SOURCE_CLASS_NAME = "dataSourceClassName";
    private final String parameter;
    private final DataSourceProperties dataSourceProperties;
    private final YamlJdbcConfiguration jdbcConfig;
    private final DatabaseType databaseType;

    public StandardPipelineDataSourceConfiguration(String parameter) {
        this(parameter, (Map)YamlEngine.unmarshal((String)parameter, Map.class));
    }

    public StandardPipelineDataSourceConfiguration(Map<String, Object> yamlDataSourceConfig) {
        this(YamlEngine.marshal(yamlDataSourceConfig), yamlDataSourceConfig);
    }

    private StandardPipelineDataSourceConfiguration(String parameter, Map<String, Object> yamlConfig) {
        this.parameter = parameter;
        if (!yamlConfig.containsKey(DATA_SOURCE_CLASS_NAME)) {
            yamlConfig.put(DATA_SOURCE_CLASS_NAME, "com.zaxxer.hikari.HikariDataSource");
        }
        for (String each : Arrays.asList("minPoolSize", "minimumIdle")) {
            yamlConfig.put(each, "1");
        }
        this.dataSourceProperties = new YamlDataSourceConfigurationSwapper().swapToDataSourceProperties(yamlConfig);
        yamlConfig.remove(DATA_SOURCE_CLASS_NAME);
        if (yamlConfig.containsKey("jdbcUrl")) {
            yamlConfig.put("url", yamlConfig.get("jdbcUrl"));
            yamlConfig.remove("jdbcUrl");
        }
        this.jdbcConfig = (YamlJdbcConfiguration)YamlEngine.unmarshal((String)YamlEngine.marshal(yamlConfig), YamlJdbcConfiguration.class, (boolean)true);
        this.databaseType = DatabaseTypeEngine.getDatabaseType((String)this.jdbcConfig.getUrl());
        this.appendJdbcQueryProperties(this.databaseType.getType());
    }

    public StandardPipelineDataSourceConfiguration(String jdbcUrl, String username, String password) {
        this(StandardPipelineDataSourceConfiguration.wrapParameter(jdbcUrl, username, password));
    }

    private static Map<String, Object> wrapParameter(String jdbcUrl, String username, String password) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(3, 1.0f);
        result.put("url", jdbcUrl);
        result.put("username", username);
        result.put("password", password);
        return result;
    }

    private void appendJdbcQueryProperties(String databaseType) {
        Optional<JdbcQueryPropertiesExtension> extension = JdbcQueryPropertiesExtensionFactory.getInstance(databaseType);
        if (!extension.isPresent()) {
            return;
        }
        Properties queryProps = extension.get().extendQueryProperties();
        if (queryProps.isEmpty()) {
            return;
        }
        this.jdbcConfig.setUrl(new JdbcUrlAppender().appendQueryProperties(this.jdbcConfig.getUrl(), queryProps));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Object getDataSourceConfiguration() {
        return this.dataSourceProperties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardPipelineDataSourceConfiguration)) {
            return false;
        }
        StandardPipelineDataSourceConfiguration other = (StandardPipelineDataSourceConfiguration)o;
        String this$parameter = this.getParameter();
        String other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getParameter() {
        return this.parameter;
    }

    @Generated
    public YamlJdbcConfiguration getJdbcConfig() {
        return this.jdbcConfig;
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

