/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin.runner;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.Zips;
import org.apache.openejb.util.Pipe;
import org.apache.tomee.util.QuickServerXmlParser;

public class ExecRunner {
    private static final String SH_BAT_AUTO = "[.sh|.bat]";

    public static void main(String[] rawArgs) throws Exception {
        int lastSlash;
        String cmd;
        File[] scripts;
        String[] args = rawArgs == null || rawArgs.length == 0 ? new String[]{"run"} : rawArgs;
        Properties config = new Properties();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = contextClassLoader.getResourceAsStream("configuration.properties");
        if (is == null) {
            throw new IllegalArgumentException("Config not found");
        }
        config.load(new InputStreamReader(is, "UTF-8"));
        is.close();
        String distrib = config.getProperty("distribution");
        String workingDir = config.getProperty("workingDir");
        InputStream distribIs = contextClassLoader.getResourceAsStream(distrib);
        File distribOutput = new File(workingDir);
        File timestampFile = new File(distribOutput, "timestamp.txt");
        boolean forceDelete = Boolean.getBoolean("tomee.runner.force-delete");
        if (forceDelete || !timestampFile.exists() || Long.parseLong(IO.slurp((File)timestampFile).replace(System.getProperty("line.separator"), "")) < Long.parseLong(config.getProperty("timestamp"))) {
            if (forceDelete || timestampFile.exists()) {
                System.out.println("Deleting " + distribOutput.getAbsolutePath());
                Files.delete((File)distribOutput);
            }
            System.out.println("Extracting tomee to " + distribOutput.getAbsolutePath());
            Zips.unzip((InputStream)distribIs, (File)distribOutput, (boolean)false);
            IO.writeString((File)timestampFile, (String)config.getProperty("timestamp", Long.toString(System.currentTimeMillis())));
        }
        if ((scripts = new File(distribOutput, "bin").listFiles()) != null) {
            for (File f : scripts) {
                if (!f.getName().endsWith(".sh") || f.canExecute() || f.setExecutable(true, true)) continue;
                System.err.println("Failed make file executable: " + f);
            }
        }
        if ((cmd = config.getProperty("command")).endsWith(SH_BAT_AUTO) && (lastSlash = cmd.lastIndexOf(47)) > 0) {
            String dir = cmd.substring(0, lastSlash);
            boolean isWin = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
            String script = cmd.substring(lastSlash + 1, cmd.length() - SH_BAT_AUTO.length()).replace('/', isWin ? (char)'\\' : '/') + (isWin ? ".bat" : ".sh");
            File scriptFile = new File(distribOutput, dir + File.separator + script);
            if (!scriptFile.exists()) {
                throw new IllegalArgumentException("Can't find  " + cmd);
            }
            cmd = scriptFile.getAbsolutePath();
            if (cmd.endsWith(".sh") && !scriptFile.setExecutable(true)) {
                System.err.println("Failed make script file executable: " + scriptFile);
            }
        }
        String additionalArgs = System.getProperty("additionalSystemProperties");
        ArrayList<String> params = new ArrayList<String>();
        if ("java".equals(cmd)) {
            File[] extracted = distribOutput.listFiles();
            if (extracted != null) {
                File newRoot = null;
                for (File e : extracted) {
                    if (!e.isDirectory()) continue;
                    if (newRoot == null) {
                        newRoot = e;
                        continue;
                    }
                    newRoot = null;
                    break;
                }
                if (newRoot != null) {
                    distribOutput = newRoot;
                }
            }
            QuickServerXmlParser parser = QuickServerXmlParser.parse((File)new File(distribOutput, "conf/server.xml"));
            System.setProperty("openejb.home", distribOutput.getAbsolutePath());
            System.setProperty("server.shutdown.port", parser.stop());
            System.setProperty("server.shutdown.command", config.getProperty("shutdownCommand"));
            RemoteServer server = new RemoteServer();
            server.setPortStartup(Integer.parseInt(parser.http()));
            if (config.containsKey("additionalClasspath")) {
                server.setAdditionalClasspath(config.getProperty("additionalClasspath"));
            }
            LinkedList<String> jvmArgs = new LinkedList<String>();
            if (additionalArgs != null) {
                Collections.addAll(jvmArgs, additionalArgs.split(" "));
            }
            for (String k : config.stringPropertyNames()) {
                if (!k.startsWith("jvmArg.")) continue;
                jvmArgs.add(config.getProperty(k));
            }
            if ("run".equals(args[0])) {
                args[0] = "start";
            }
            try {
                server.start(jvmArgs, args[0], true);
                server.getServer().waitFor();
            }
            catch (Exception e) {
                server.destroy();
            }
        } else {
            if (cmd.endsWith(".bat") && !cmd.startsWith("cmd.exe")) {
                params.add("cmd.exe");
                params.add("/c");
            }
            params.add(cmd);
            params.addAll(Arrays.asList(args));
            ProcessBuilder builder = new ProcessBuilder(params.toArray(new String[params.size()])).directory(distribOutput);
            String existingOpts = System.getenv("CATALINA_OPTS");
            String catalinaOpts = config.getProperty("catalinaOpts");
            if (catalinaOpts != null || existingOpts != null || additionalArgs != null) {
                builder.environment().put("CATALINA_OPTS", ExecRunner.identityOrEmpty(catalinaOpts) + " " + ExecRunner.identityOrEmpty(existingOpts) + " " + ExecRunner.identityOrEmpty(additionalArgs));
            }
            boolean redirectOut = false;
            try {
                ProcessBuilder.class.getDeclaredMethod("inheritIO", new Class[0]).invoke((Object)builder, new Object[0]);
            }
            catch (Throwable th) {
                redirectOut = true;
            }
            Process process = builder.start();
            if (redirectOut) {
                Pipe.pipe((Process)process);
            }
            process.waitFor();
        }
        System.out.flush();
        System.err.flush();
        System.out.println("Exited Successfully!");
    }

    private static String identityOrEmpty(String value) {
        return value != null ? value : "";
    }

    private ExecRunner() {
    }
}

