/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin.cli;

import java.util.Collection;
import java.util.LinkedList;

public final class Args {
    public static Collection<String> parse(String raw) {
        LinkedList<String> result = new LinkedList<String>();
        raw = raw.trim().replace("\r", "").replace("\n", "");
        Character end = null;
        boolean escaped = false;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (escaped) {
                escaped = false;
                current.append(c);
                continue;
            }
            if (end != null && end.charValue() == c || c == ' ' && end == null) {
                if (current.length() > 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
                end = null;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\"' || c == '\'') {
                end = Character.valueOf(c);
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result;
    }

    private Args() {
    }
}

