/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.client.RemoteInitialContextFactory;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.loader.Files;
import org.apache.openejb.maven.plugin.AbstractSynchronizable;
import org.apache.openejb.maven.plugin.AbstractTomEEMojo;
import org.apache.openejb.maven.plugin.Synch;
import org.apache.openejb.maven.plugin.Synchronization;
import org.codehaus.plexus.util.FileUtils;

public abstract class UpdatableTomEEMojo
extends AbstractTomEEMojo {
    public static final int INITIAL_DELAY = 5000;
    public static final String RELOAD_CMD = "reload";
    @Parameter
    private Synchronization synchronization;
    @Parameter
    private List<Synch> synchronizations;
    @Parameter(property="tomee-plugin.buildDir", defaultValue="${project.build.directory}", readonly=true)
    private File buildDir;
    @Parameter(property="tomee-plugin.baseDir", defaultValue="${project.basedir}", readonly=true)
    private File baseDir;
    @Parameter(property="tomee-plugin.reload-on-update", defaultValue="false")
    private boolean reloadOnUpdate;
    private Timer timer;
    private SynchronizerRedeployer task;

    @Override
    protected void run() {
        if (this.synchronization != null) {
            this.initSynchronization(this.synchronization);
            this.avoidAutoReload();
        }
        if (this.synchronizations != null) {
            for (Synch s : this.synchronizations) {
                if (s.getSource() == null || s.getTarget() == null) {
                    this.getLog().warn((CharSequence)"Source or Target directory missing to a <synch> block, skipping");
                    continue;
                }
                this.initSynch(s);
                this.avoidAutoReload();
            }
        }
        if (this.startSynchronizers()) {
            this.forceReloadable = true;
        }
        if (this.removeTomeeWebapp && !this.ejbRemote) {
            this.getLog().warn((CharSequence)"TomEE webapp is asked to be removed (<ejbRemote>true> or <removeTomeeWebapp>true</removeTomeeWebapp>) so you can use reload feature");
        }
        super.run();
    }

    private void avoidAutoReload() {
        if (this.systemVariables == null) {
            this.systemVariables = new HashMap();
        }
        if (!this.systemVariables.containsKey("tomee.classloader.skip-background-process")) {
            this.systemVariables.put("tomee.classloader.skip-background-process", "true");
        }
    }

    private void initSynch(AbstractSynchronizable s) {
        s.getExtensions().addAll(s.getUpdateOnlyExtenions());
        if (this.reloadOnUpdate) {
            this.deployOpenEjbApplication = true;
        }
    }

    private void initSynchronization(Synchronization synchronization) {
        String destination = this.destinationName().replaceAll("\\.[jew]ar", "");
        if (synchronization.getBinariesDir() == null) {
            synchronization.setBinariesDir(new File(this.buildDir, "classes"));
        }
        if (synchronization.getResourcesDir() == null) {
            synchronization.setResourcesDir(new File(this.baseDir, "src/main/webapp"));
        }
        if (synchronization.getTargetResourcesDir() == null) {
            synchronization.setTargetResourcesDir(new File(this.catalinaBase, this.webappDir + "/" + destination));
        }
        if (synchronization.getTargetBinariesDir() == null) {
            synchronization.setTargetBinariesDir(new File(this.catalinaBase, this.webappDir + "/" + destination + "/WEB-INF/classes"));
        }
        if (synchronization.getUpdateInterval() <= 0) {
            synchronization.setUpdateInterval(5);
        }
        if (synchronization.getExtensions() == null) {
            synchronization.setExtensions(new ArrayList<String>(Arrays.asList(".html", ".css", ".js", ".xhtml")));
        }
        if (synchronization.getUpdateOnlyExtenions() == null) {
            synchronization.setUpdateOnlyExtensions(Collections.<String>emptyList());
        }
        this.initSynch(synchronization);
    }

    @Override
    protected void addShutdownHooks(RemoteServer server) {
        if (this.synchronization != null || this.synchronizations != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    UpdatableTomEEMojo.this.task.cancel();
                    UpdatableTomEEMojo.this.timer.cancel();
                }
            });
        }
        super.addShutdownHooks(server);
    }

    protected boolean startSynchronizers() {
        this.timer = new Timer("tomee-maven-plugin-synchronizer");
        ArrayList<Synchronizer> synchronizers = new ArrayList<Synchronizer>();
        long interval = 5000L;
        if (this.synchronization != null) {
            synchronizers.add(new Synchronizer(this.synchronization));
            interval = TimeUnit.SECONDS.toMillis(this.synchronization.getUpdateInterval());
        }
        if (this.synchronizations != null) {
            for (AbstractSynchronizable abstractSynchronizable : this.synchronizations) {
                synchronizers.add(new Synchronizer(abstractSynchronizable));
                if (interval >= (long)abstractSynchronizable.getUpdateInterval()) continue;
                interval = TimeUnit.SECONDS.toMillis(abstractSynchronizable.getUpdateInterval());
            }
        }
        if (!synchronizers.isEmpty()) {
            this.task = new SynchronizerRedeployer(synchronizers);
            this.getLog().info((CharSequence)("Starting synchronizer with an update interval of " + interval));
            if (interval > 5000L) {
                this.timer.scheduleAtFixedRate((TimerTask)this.task, interval, interval);
            } else {
                this.timer.scheduleAtFixedRate((TimerTask)this.task, 5000L, interval);
            }
            return true;
        }
        return false;
    }

    @Override
    protected Collection<String> availableCommands() {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.addAll(super.availableCommands());
        cmds.add(RELOAD_CMD);
        return cmds;
    }

    @Override
    protected boolean handleLine(String line) {
        if (super.handleLine(line)) {
            return true;
        }
        if (UpdatableTomEEMojo.isReload(line)) {
            this.reload();
            return true;
        }
        return false;
    }

    private static boolean isReload(String line) {
        if (RELOAD_CMD.equalsIgnoreCase(line)) {
            return true;
        }
        line = new StringBuilder(line).reverse().toString();
        return RELOAD_CMD.equalsIgnoreCase(line);
    }

    protected synchronized void reload() {
        if (this.deployOpenEjbApplication) {
            String path = this.deployedFile.getAbsolutePath();
            if (path.endsWith(".war") || path.endsWith(".ear")) {
                path = path.substring(0, path.length() - ".war".length());
            }
            this.getLog().info((CharSequence)("Reloading " + path));
            this.deployer().reload(path);
        } else {
            this.getLog().warn((CharSequence)"Reload command needs to activate openejb internal application. Add <deployOpenEjbApplication>true</deployOpenEjbApplication> to the plugin configuration to force it.");
        }
    }

    private Deployer deployer() {
        if (this.removeTomeeWebapp && !this.ejbRemote) {
            throw new OpenEJBRuntimeException("Can't use reload feature without TomEE Webapp, please set removeTomeeWebapp to false or ejbRemote to true");
        }
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
        properties.setProperty("java.naming.provider.url", "http://" + this.tomeeHost + ":" + this.tomeeHttpPort + "/tomee/ejb");
        try {
            InitialContext context = new InitialContext(properties);
            return (Deployer)context.lookup("openejb/DeployerBusinessRemote");
        }
        catch (NamingException e) {
            throw new OpenEJBRuntimeException("Can't lookup Deployer", (Throwable)e);
        }
    }

    private class SuffixesAndRegexFileFilter
    extends SuffixesFileFilter {
        private final Pattern pattern;

        public SuffixesAndRegexFileFilter(List<String> extensions, Pattern pattern) {
            super(extensions);
            this.pattern = pattern;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || super.accept(file) && this.pattern.matcher(file.getAbsolutePath()).matches();
        }
    }

    private static class SuffixesFileFilter
    implements FileFilter {
        private final String[] suffixes;

        public SuffixesFileFilter(List<String> extensions) {
            this.suffixes = extensions == null ? new String[0] : extensions.toArray(new String[extensions.size()]);
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (String suffix : this.suffixes) {
                if (!file.getName().endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
    }

    private class Synchronizer
    implements Callable<Integer> {
        private final FileFilter fileFilter;
        private final FileFilter updateOnlyFilter;
        private final AbstractSynchronizable synchronization;
        private long lastUpdate = System.currentTimeMillis();

        public Synchronizer(AbstractSynchronizable synch) {
            this.synchronization = synch;
            this.updateOnlyFilter = new SuffixesFileFilter(this.synchronization.getUpdateOnlyExtenions());
            this.fileFilter = this.synchronization.getRegex() != null ? new SuffixesAndRegexFileFilter(this.synchronization.getExtensions(), Pattern.compile(this.synchronization.getRegex())) : new SuffixesFileFilter(this.synchronization.getExtensions());
        }

        @Override
        public Integer call() throws Exception {
            long ts = System.currentTimeMillis();
            int updated = 0;
            for (Map.Entry<File, File> pair : this.synchronization.updates().entrySet()) {
                updated += this.updateFiles(pair.getKey(), pair.getValue(), ts);
            }
            this.lastUpdate = ts;
            return updated;
        }

        private int updateFiles(File source, File output, long ts) {
            if (!source.exists()) {
                UpdatableTomEEMojo.this.getLog().debug((CharSequence)(source.getAbsolutePath() + " doesn't exist"));
                return 0;
            }
            if (source.isFile()) {
                if (source.lastModified() < this.lastUpdate) {
                    return 0;
                }
                return this.updateFile(source, output, source, ts);
            }
            if (!source.isDirectory()) {
                UpdatableTomEEMojo.this.getLog().warn((CharSequence)(source.getAbsolutePath() + " is not a directory, skipping"));
                return 0;
            }
            List files = Files.collect((File)source, (FileFilter)this.fileFilter);
            int updated = 0;
            for (File file : files) {
                if (file.isDirectory() || file.lastModified() < this.lastUpdate) continue;
                updated += this.updateFile(source, output, file, ts);
            }
            return updated;
        }

        private int updateFile(File source, File target, File file, long ts) {
            File output;
            if (target.isFile() && target.exists()) {
                output = target;
            } else {
                String relativized = file.getAbsolutePath().replace(source.getAbsolutePath(), "");
                if (relativized.startsWith(File.separator)) {
                    relativized = relativized.substring(1);
                }
                output = new File(target, relativized);
            }
            if (file.exists()) {
                UpdatableTomEEMojo.this.getLog().info((CharSequence)("[Updating] " + file.getAbsolutePath() + " to " + output.getAbsolutePath()));
            } else {
                UpdatableTomEEMojo.this.getLog().info((CharSequence)("[Creating] " + file.getAbsolutePath() + " to " + output.getAbsolutePath()));
            }
            try {
                if (!output.getParentFile().exists()) {
                    FileUtils.forceMkdir((File)output.getParentFile());
                }
                FileUtils.copyFile((File)file, (File)output);
                if (!output.setLastModified(ts)) {
                    UpdatableTomEEMojo.this.getLog().debug((CharSequence)("Can't update last modified date of " + file));
                }
            }
            catch (IOException e) {
                UpdatableTomEEMojo.this.getLog().error((Throwable)e);
            }
            if (this.updateOnlyFilter.accept(file)) {
                return 0;
            }
            return 1;
        }
    }

    private class SynchronizerRedeployer
    extends TimerTask {
        private final Collection<Synchronizer> delegates;

        public SynchronizerRedeployer(Collection<Synchronizer> synchronizers) {
            this.delegates = synchronizers;
        }

        @Override
        public void run() {
            int updated = 0;
            for (Synchronizer s : this.delegates) {
                try {
                    updated += s.call().intValue();
                }
                catch (Exception e) {
                    UpdatableTomEEMojo.this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
            if (updated > 0 && UpdatableTomEEMojo.this.reloadOnUpdate && UpdatableTomEEMojo.this.deployedFile != null && UpdatableTomEEMojo.this.deployedFile.exists()) {
                UpdatableTomEEMojo.this.reload();
            }
        }
    }
}

