/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.invoker.model.BuildJob;
import org.apache.maven.shared.utils.logging.MessageUtils;

class InvokerSession {
    private List<BuildJob> buildJobs;
    private List<BuildJob> failedJobs;
    private List<BuildJob> errorJobs;
    private List<BuildJob> successfulJobs;
    private List<BuildJob> skippedJobs;

    InvokerSession() {
        this.buildJobs = new ArrayList<BuildJob>();
    }

    InvokerSession(List<BuildJob> buildJobs) {
        this.buildJobs = new ArrayList<BuildJob>(buildJobs);
    }

    public void addJob(BuildJob buildJob) {
        this.buildJobs.add(buildJob);
        this.resetStats();
    }

    public void setJobs(List<? extends BuildJob> buildJobs) {
        this.buildJobs = new ArrayList<BuildJob>(buildJobs);
        this.resetStats();
    }

    public List<BuildJob> getJobs() {
        return this.buildJobs;
    }

    public List<BuildJob> getSuccessfulJobs() {
        this.updateStats();
        return this.successfulJobs;
    }

    public List<BuildJob> getFailedJobs() {
        this.updateStats();
        return this.failedJobs;
    }

    public List<BuildJob> getErrorJobs() {
        this.updateStats();
        return this.errorJobs;
    }

    public List<BuildJob> getSkippedJobs() {
        this.updateStats();
        return this.skippedJobs;
    }

    private void resetStats() {
        this.successfulJobs = null;
        this.failedJobs = null;
        this.skippedJobs = null;
        this.errorJobs = null;
    }

    private void updateStats() {
        if (this.successfulJobs != null && this.skippedJobs != null && this.failedJobs != null && this.errorJobs != null) {
            return;
        }
        this.successfulJobs = new ArrayList<BuildJob>();
        this.failedJobs = new ArrayList<BuildJob>();
        this.skippedJobs = new ArrayList<BuildJob>();
        this.errorJobs = new ArrayList<BuildJob>();
        for (BuildJob buildJob : this.buildJobs) {
            if ("success".equals(buildJob.getResult())) {
                this.successfulJobs.add(buildJob);
                continue;
            }
            if ("skipped".equals(buildJob.getResult())) {
                this.skippedJobs.add(buildJob);
                continue;
            }
            if ("error".equals(buildJob.getResult())) {
                this.errorJobs.add(buildJob);
                continue;
            }
            if (buildJob.getResult() == null) continue;
            this.failedJobs.add(buildJob);
        }
    }

    public void logSummary(Log logger, boolean ignoreFailures) {
        this.updateStats();
        String separator = MessageUtils.buffer().strong((Object)"-------------------------------------------------").toString();
        logger.info((CharSequence)separator);
        logger.info((CharSequence)"Build Summary:");
        logger.info((CharSequence)("  Passed: " + this.successfulJobs.size() + ", Failed: " + this.failedJobs.size() + ", Errors: " + this.errorJobs.size() + ", Skipped: " + this.skippedJobs.size()));
        logger.info((CharSequence)separator);
        if (!this.failedJobs.isEmpty()) {
            String heading = "The following builds failed:";
            if (ignoreFailures) {
                logger.warn((CharSequence)heading);
            } else {
                logger.error((CharSequence)heading);
            }
            for (BuildJob buildJob : this.failedJobs) {
                String item = "*  " + buildJob.getProject();
                if (ignoreFailures) {
                    logger.warn((CharSequence)item);
                    continue;
                }
                logger.error((CharSequence)item);
            }
            logger.info((CharSequence)separator);
        }
    }

    public void handleFailures(Log logger, boolean ignoreFailures) throws MojoFailureException {
        String message;
        this.updateStats();
        if (!this.failedJobs.isEmpty()) {
            message = this.failedJobs.size() + " build" + (this.failedJobs.size() == 1 ? "" : "s") + " failed.";
            if (ignoreFailures) {
                logger.warn((CharSequence)("Ignoring that " + message));
            } else {
                throw new MojoFailureException(message + " See console output above for details.");
            }
        }
        if (!this.errorJobs.isEmpty()) {
            message = this.errorJobs.size() + " build" + (this.errorJobs.size() == 1 ? "" : "s") + " in error.";
            if (ignoreFailures) {
                logger.warn((CharSequence)("Ignoring that " + message));
            } else {
                throw new MojoFailureException(message + " See console output above for details.");
            }
        }
    }
}

