/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.wtp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.wtp.AbstractWtpResourceWriter;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseWtpmodulesWriter
extends AbstractWtpResourceWriter {
    protected static final String FILE_DOT_WTPMODULES = ".wtpmodules";

    public void write() throws MojoExecutionException {
        OutputStreamWriter w;
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.config.getEclipseProjectDirectory(), FILE_DOT_WTPMODULES)), "UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        writer.startElement("project-modules");
        writer.addAttribute("id", "moduleCoreId");
        writer.startElement("wb-module");
        writer.addAttribute("deploy-name", this.config.getEclipseProjectName());
        writer.startElement("module-type");
        this.writeModuleTypeAccordingToPackaging(this.config.getProject(), (XMLWriter)writer, this.config.getBuildOutputDirectory());
        writer.endElement();
        String target = "/";
        if ("war".equals(this.config.getPackaging())) {
            String warSourceDirectory = IdeUtils.getPluginSetting(this.config.getProject(), "org.apache.maven.plugins:maven-war-plugin", "warSourceDirectory", this.config.getProject().getBasedir() + "/src/main/webapp");
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", "/");
            writer.addAttribute("source-path", "/" + IdeUtils.toRelativeAndFixSeparator(this.config.getEclipseProjectDirectory(), new File(warSourceDirectory), false));
            writer.endElement();
            this.writeWarOrEarResources((XMLWriter)writer, this.config.getProject(), this.config.getLocalRepository());
            target = "/WEB-INF/classes";
        } else if ("ear".equals(this.config.getPackaging())) {
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", "/");
            writer.addAttribute("source-path", "/");
            writer.endElement();
            this.writeWarOrEarResources((XMLWriter)writer, this.config.getProject(), this.config.getLocalRepository());
        }
        for (int j = 0; j < this.config.getSourceDirs().length; ++j) {
            EclipseSourceDir dir = this.config.getSourceDirs()[j];
            if (dir.isTest()) continue;
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", target);
            writer.addAttribute("source-path", dir.getPath());
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        IOUtil.close((Writer)w);
    }
}

