/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser.list;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeComponent {
    private static final String EOL = System.getProperty("line.separator");
    private List<TreeComponent> children = new ArrayList<TreeComponent>();
    private String text;
    private TreeComponent father;
    private int type;

    TreeComponent(TreeComponent father, String text, int type) {
        this.text = text;
        this.father = father;
        this.type = type;
    }

    List<TreeComponent> getChildren() {
        return this.children;
    }

    TreeComponent addChildren(String t, int ttype) {
        if (t == null) {
            throw new IllegalArgumentException("argument is null");
        }
        TreeComponent ret = new TreeComponent(this, t, ttype);
        this.children.add(ret);
        return ret;
    }

    TreeComponent getFather() {
        return this.father;
    }

    int getDepth() {
        int ret = 0;
        TreeComponent c = this;
        while ((c = c.getFather()) != null) {
            ++ret;
        }
        return ret;
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        if (this.father != null) {
            sb.append(indent);
            sb.append("- ");
            sb.append(this.text);
            sb.append(EOL);
        }
        for (TreeComponent lc : this.children) {
            sb.append(lc.toString(indent + "   "));
        }
        return sb.toString();
    }

    String getText() {
        return this.text;
    }

    int getType() {
        return this.type;
    }
}

