/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\teh\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u000e\u0002\t9\fW.\u001a\t\u0003\u001faq!\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0005M1\u0011A\u0002\u001fs_>$hHC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9B#\u0001\u0004Qe\u0016$WMZ\u0005\u00033i\u0011aa\u0015;sS:<'BA\f\u0015\u0013\tiA$\u0003\u0002\u001e=\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0015\tyB!A\u0003vi&d7\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003%1W\r^2iKJLE\r\u0005\u0002$I5\tA#\u0003\u0002&)\t\u0019\u0011J\u001c;\t\u0013\u001d\u0002!\u0011!Q\u0001\n!r\u0013\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bCA\u0015-\u001b\u0005Q#BA\u0016\u0005\u0003\u001d\u0019G.^:uKJL!!\f\u0016\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi&\u0011qE\u0003\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005a!M]8lKJ\u001cuN\u001c4jOB\u0011\u0011BM\u0005\u0003g\t\u00111bS1gW\u0006\u001cuN\u001c4jO\"AQ\u0007\u0001B\u0001B\u0003%a'\u0001\u0006sKBd\u0017nY1NOJ\u0004\"!C\u001c\n\u0005a\u0012!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u001fF\u001b\u0005i$B\u0001\u001e?\u0015\ty\u0004)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0005S!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sO&\u0011a)\u0010\u0002\b\u001b\u0016$(/[2t\u0011!A\u0005A!A!\u0002\u0013I\u0015\u0001\u0002;j[\u0016\u0004\"A\u0013'\u000e\u0003-S!a\b \n\u00055[%\u0001\u0002+j[\u0016D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\u0006cV|G/\u0019\t\u0003\u0013EK!A\u0015\u0002\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\t\u0011Q\u0003!\u0011!Q\u0001\nU\u000b!\u0004\\3bI\u0016\u0014XI\u001c3q_&tGO\u00117pG.LgnZ*f]\u0012\u00042a\t,Y\u0013\t9FC\u0001\u0004PaRLwN\u001c\t\u0003\u0013eK!A\u0017\u0002\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\t\u000bq\u0003A\u0011A/\u0002\rqJg.\u001b;?))qv\fY1cG\u0012,gm\u001a\t\u0003\u0013\u0001AQ!D.A\u00029AQ!I.A\u0002\tBQaJ.A\u0002!BQ\u0001M.A\u0002EBQ!N.A\u0002YBQAO.A\u0002mBQ\u0001S.A\u0002%CQaT.A\u0002ACq\u0001V.\u0011\u0002\u0003\u0007Q\u000bC\u0004j\u0001\t\u0007I\u0011\u00026\u0002\u0013I,\u0007\u000f\\5dC&#W#\u0001\u0012\t\r1\u0004\u0001\u0015!\u0003#\u0003)\u0011X\r\u001d7jG\u0006LE\r\t\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0002aB\u0011!*]\u0005\u0003e.\u0013!\u0002T8h\u0007>tG/\u001a=u\u0011\u0019!\b\u0001)A\u0005a\u0006YAn\\4D_:$X\r\u001f;!\u0011\u001d1\bA1A\u0005\n]\fa\u0002\\3bI\u0016\u0014XI\u001c3q_&tG/F\u0001Y\u0011\u0019I\b\u0001)A\u00051\u0006yA.Z1eKJ,e\u000e\u001a9pS:$\b\u0005\u0003\u0005|\u0001\t\u0007I\u0011\u0001\u0002}\u0003M1W\r^2i%\u0016\fX/Z:u-\u0016\u00148/[8o+\u0005i\bCA\u0012\u007f\u0013\tyHCA\u0003TQ>\u0014H\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011B?\u0002)\u0019,Go\u00195SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8!\u0011%\t9\u0001\u0001b\u0001\n\u0003\u0011A0\u0001\u0012pM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f\u001e,feNLwN\u001c\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003~\u0003\rzgMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3tiZ+'o]5p]\u0002B\u0011\"a\u0004\u0001\u0005\u0004%\tA\u0001?\u000211L7\u000f^(gMN,GOU3rk\u0016\u001cHOV3sg&|g\u000eC\u0004\u0002\u0014\u0001\u0001\u000b\u0011B?\u000231L7\u000f^(gMN,GOU3rk\u0016\u001cHOV3sg&|g\u000e\t\u0005\n\u0003/\u0001!\u0019!C\u0005\u00033\tq!\\1y/\u0006LG/\u0006\u0002\u0002\u001cA!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001\u00027b]\u001eT!!!\n\u0002\t)\fg/Y\u0005\u0005\u0003S\tyBA\u0004J]R,w-\u001a:\t\u0011\u00055\u0002\u0001)A\u0005\u00037\t\u0001\"\\1y/\u0006LG\u000f\t\u0005\n\u0003c\u0001!\u0019!C\u0005\u00033\t\u0001\"\\5o\u0005f$Xm\u001d\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002\u001c\u0005IQ.\u001b8CsR,7\u000f\t\u0005\n\u0003s\u0001!\u0019!C\u0005\u00033\t\u0001\"\\1y\u0005f$Xm\u001d\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002\u001c\u0005IQ.\u0019=CsR,7\u000f\t\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u00033\t\u0011BZ3uG\"\u001c\u0016N_3\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u00037\t!BZ3uG\"\u001c\u0016N_3!\u0011%\tI\u0005\u0001b\u0001\n\u0013\tY%\u0001\u0011ce>\\WM]*vaB|'\u000f^:MK\u0006$WM]#q_\u000eD'+Z9vKN$XCAA'!\r\u0019\u0013qJ\u0005\u0004\u0003#\"\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002N\u0005\t#M]8lKJ\u001cV\u000f\u001d9peR\u001cH*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:uA!I\u0011\u0011\f\u0001C\u0002\u0013%\u00111L\u0001\u0014M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u000b\u0003\u0003;\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G\u0002\u0015aB2mS\u0016tGo]\u0005\u0005\u0003O\n\tGA\nGKR\u001c\u0007nU3tg&|g\u000eS1oI2,'\u000f\u0003\u0005\u0002l\u0001\u0001\u000b\u0011BA/\u0003Q1W\r^2i'\u0016\u001c8/[8o\u0011\u0006tG\r\\3sA!9\u0011q\u000e\u0001\u0005R\u0005E\u0014a\u00037bi\u0016\u001cH/\u00129pG\"$B!a\u001d\u0002vA\u00191E\u0016\u0012\t\u0011\u0005]\u0014Q\u000ea\u0001\u0003s\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002|\u0005uT\"\u0001 \n\u0007\u0005}dH\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005\r\u0005\u0001\"\u0015\u0002\u0006\u0006aAn\\4F]\u0012|eMZ:fiR!\u0011qQAG!\r\u0019\u0013\u0011R\u0005\u0004\u0003\u0017#\"\u0001\u0002'p]\u001eD\u0001\"a\u001e\u0002\u0002\u0002\u0007\u0011\u0011\u0010\u0005\b\u0003#\u0003A\u0011KAJ\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0003+\u000bi*a(\u0011\t\r2\u0016q\u0013\t\u0004\u0013\u0005e\u0015bAAN\u0005\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007\u0002CA<\u0003\u001f\u0003\r!!\u001f\t\u000f\u0005\u0005\u0016q\u0012a\u0001E\u0005)Q\r]8dQ\"9\u0011Q\u0015\u0001\u0005B\u0005\u001d\u0016\u0001E5oSRL\u0017\r^3TQV$Hm\\<o)\t\ti\u0005C\u0004\u0002,\u0002!\t%!,\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o)\t\ty\u000bE\u0002$\u0003cK1!a-\u0015\u0005\u0011)f.\u001b;\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\u0006!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002\"a/\u0002J\u0006-\u0017q\u001a\t\u0005GY\u000bi\f\u0005\u0003\u0002@\u0006\u0015WBAAa\u0015\r\t\u0019\rB\u0001\u0004Y><\u0017\u0002BAd\u0003\u0003\u0014Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007\u0002CA<\u0003k\u0003\r!!\u001f\t\u0011\u00055\u0017Q\u0017a\u0001\u0003\u000f\u000b1BZ3uG\"|eMZ:fi\"A\u0011\u0011[A[\u0001\u0004\t\u0019.A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0003+\f9.D\u0001\u0001\u0013\r\tIN\u0003\u0002\n\r\u0016$8\r\u001b#bi\u0006Dq!!8\u0001\t\u0003\ty.A\u000enCf\u0014WmV1s]&3wJ^3sg&TX\r\u001a*fG>\u0014Hm\u001d\u000b\u0007\u0003_\u000b\t/!=\t\u0011\u0005\r\u00181\u001ca\u0001\u0003K\fqA]3d_J$7\u000f\u0005\u0003\u0002h\u00065XBAAu\u0015\r\tYOP\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005=\u0018\u0011\u001e\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0011\u0005]\u00141\u001ca\u0001\u0003sBq!!>\u0001\t#\n90A\bgKR\u001c\u0007N\u0012:p[2+\u0017\rZ3s)\u0011\tIP!\u0005\u0011\r\u0005m(Q\u0001B\u0006\u001d\u0011\tiP!\u0001\u000f\u0007E\ty0C\u0001\u0016\u0013\r\u0011\u0019\u0001F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119A!\u0003\u0003\u0007M+\u0017OC\u0002\u0003\u0004Q\u0001ra\tB\u0007\u0003s\n\u0019.C\u0002\u0003\u0010Q\u0011a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\n\u0003g\u0004\rA!\u0006\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\t]!1\u0005\b\u0005\u00053\u0011y\"\u0004\u0002\u0003\u001c)\u0019!Q\u0004 \u0002\u0011I,\u0017/^3tiNLAA!\t\u0003\u001c\u0005aa)\u001a;dQJ+\u0017/^3ti&!!Q\u0005B\u0014\u0005\u001d\u0011U/\u001b7eKJTAA!\t\u0003\u001c!9!1\u0006\u0001\u0005R\t5\u0012!\b4fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$hI]8n\u0019\u0016\fG-\u001a:\u0015\r\u0005\u001d%q\u0006B\u0019\u0011!\t9H!\u000bA\u0002\u0005e\u0004b\u0002B\u001a\u0005S\u0001\rAI\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0004\u00038\u0001!\tF!\u000f\u00027\u0019,Go\u00195MCR,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0019\t9Ia\u000f\u0003>!A\u0011q\u000fB\u001b\u0001\u0004\tI\bC\u0004\u00034\tU\u0002\u0019\u0001\u0012\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D\u0005)b-\u001a;dQ>3gm]3u\rJ|W\u000eT3bI\u0016\u0014H\u0003CAD\u0005\u000b\u00129E!\u0013\t\u0011\u0005]$q\ba\u0001\u0003sBqAa\r\u0003@\u0001\u0007!\u0005\u0003\u0005\u0003L\t}\u0002\u0019AAD\u0003A)\u0017M\u001d7jKN$xJ\u001d'bi\u0016\u001cH\u000fC\u0004\u0003P\u0001!\tE!\u0015\u0002\u0015\t,\u0018\u000e\u001c3GKR\u001c\u0007\u000e\u0006\u0003\u0003T\t-\u0004C\u0002B+\u0005G\u0012IG\u0004\u0003\u0003X\t}c\u0002\u0002B-\u0005;r1!\u0005B.\u0013\u0005)\u0011BA\u0002\u0005\u0013\r\u0011\tGA\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\u0011\u0011)Ga\u001a\u0003)I+7/\u001e7u/&$\b\u000eU1si&$\u0018n\u001c8t\u0015\r\u0011\tG\u0001\t\u0005GY\u0013)\u0002\u0003\u0005\u0003n\t5\u0003\u0019\u0001B8\u00031\u0001\u0018M\u001d;ji&|g.T1q!!\u0011\tHa\u001e\u0002z\tmTB\u0001B:\u0015\r\u0011)\bF\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B=\u0005g\u00121!T1q!\rI!QP\u0005\u0004\u0005\u007f\u0012!a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0007b\u0002BB\u0001\u0011\u0005#QQ\u0001\tiJ,hnY1uKR1\u0011q\u0016BD\u0005\u0017C\u0001B!#\u0003\u0002\u0002\u0007\u0011\u0011P\u0001\u0003iBD\u0001B!$\u0003\u0002\u0002\u0007!qR\u0001\u0016_\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f!\rI!\u0011S\u0005\u0004\u0005'\u0013!!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/\u001a\u0005\b\u0005/\u0003A\u0011\u000bBM\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0004\u00020\nm%Q\u0014\u0005\t\u0003o\u0012)\n1\u0001\u0002z!A!q\u0014BK\u0001\u0004\t9)\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0005G\u0003A\u0011\tBS\u0003U1W\r^2i\u000bB|7\r[:Ge>lG*Z1eKJ$BAa*\u00030BA!\u0011\u000fB<\u0003s\u0012I\u000b\u0005\u0003\u0003\u001a\t-\u0016\u0002\u0002BW\u00057\u0011a\"\u00129pG\",e\u000eZ(gMN,G\u000f\u0003\u0005\u00032\n\u0005\u0006\u0019\u0001BZ\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\t\u0005c\u00129(!\u001f\u00036B!\u0011Q\u001bB\\\u0013\r\u0011IL\u0003\u0002\n\u000bB|7\r\u001b#bi\u0006DqA!0\u0001\t\u0013\u0011y,\u0001\ftQ>,H\u000e\u001a$pY2|w/\u001a:UQJ|G\u000f\u001e7f)\u0019\tiE!1\u0003D\"1qJa/A\u0002AC\u0001\"a\u001e\u0003<\u0002\u0007\u0011\u0011\u0010\u0005\u000e\u0005\u000f\u0004\u0001\u0013aA\u0001\u0002\u0013%!\u0011\u001a\u0018\u0002%M,\b/\u001a:%g>,(oY3Ce>\\WM]\u000b\u0002Q\u001dI!Q\u001a\u0002\u0002\u0002#\u0005!qZ\u0001\u0015%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193\u0011\u0007%\u0011\tN\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001Bj'\u0011\u0011\tN!6\u0011\u0007\r\u00129.C\u0002\u0003ZR\u0011a!\u00118z%\u00164\u0007b\u0002/\u0003R\u0012\u0005!Q\u001c\u000b\u0003\u0005\u001fD!B!9\u0003RF\u0005I\u0011\u0001Br\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!Q\u001d\u0016\u0004+\n\u001d8F\u0001Bu!\u0011\u0011YO!>\u000e\u0005\t5(\u0002\u0002Bx\u0005c\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tMH#\u0001\u0006b]:|G/\u0019;j_:LAAa>\u0003n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Metrics metrics;
    private final Time time;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final LogContext logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private final boolean brokerSupportsLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$9() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
    }

    private /* synthetic */ BrokerEndPoint super$sourceBroker() {
        return super.sourceBroker();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private boolean brokerSupportsLeaderEpochRequest() {
        return this.brokerSupportsLeaderEpochRequest;
    }

    private FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localReplicaOrException(topicPartition).epochs().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.latestEpoch()));
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localReplicaOrException(topicPartition).logEndOffset().messageOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        Replica replica = this.replicaMgr.localReplicaOrException(topicPartition);
        return replica.epochs().flatMap((Function1 & Serializable & scala.Serializable)epochCache -> {
            Tuple2<Object, Object> tuple2 = epochCache.endOffsetFor(epoch);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int foundEpoch = tuple2._1$mcI$sp();
            long foundOffset = tuple2._2$mcJ$sp();
            Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(foundEpoch, foundOffset);
            Tuple2.mcIJ.sp sp3 = sp2;
            int foundEpoch2 = sp3._1$mcI$sp();
            long foundOffset2 = sp3._2$mcJ$sp();
            return foundOffset2 == -1L ? None$.MODULE$ : new Some((Object)new OffsetAndEpoch(foundOffset2, foundEpoch2));
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        block2: {
            boolean justShutdown = super.initiateShutdown();
            if (!justShutdown) break block2;
            try {
                this.leaderEndpoint().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.leaderEndpoint()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.leaderEndpoint().close();
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.leaderEndpoint()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Replica replica = this.replicaMgr.localReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != replica.logEndOffset().messageOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset())})));
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData$1.highWatermark)})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)replica.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset().messageOffset()), partitionData.highWatermark);
        long leaderLogStartOffset = partitionData.logStartOffset;
        replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        replica.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Follower set replica high watermark for partition ").append(topicPartition).append(" to ").append(followerHighWatermark).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        this.replicaMgr.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        block0: {
            if (this.fetchRequestVersion() > 2 || records.sizeInBytes() <= 0 || records.validBytes() > 0) break block0;
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
        }
    }

    @Override
    public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        Object object;
        try {
            ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
            FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
            object = !this.fetchSessionHandler().handleResponse(fetchResponse) ? Nil$.MODULE$ : ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala()).toSeq();
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        return object;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -1L);
    }

    private long fetchOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        ListOffsetRequest.PartitionData requestPartitionData = new ListOffsetRequest.PartitionData(earliestOrLatest, Optional.of(Predef$.MODULE$.int2Integer(currentLeaderEpoch)));
        Map requestPartitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)requestPartitionData)}));
        ListOffsetRequest.Builder requestBuilder = ListOffsetRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(requestPartitions).asJava());
        ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData responsePartitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition);
        Errors errors = responsePartitionData.error;
        if (!Errors.NONE.equals(errors)) {
            throw errors.exception();
        }
        long l = this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(responsePartitionData.offset) : Predef$.MODULE$.Long2long((Long)responsePartitionData.offsets.get(0));
        return l;
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        None$ none$;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder();
        partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
                if (fetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, topicPartition)) {
                    try {
                        long logStartOffset = $this.replicaMgr.localReplicaOrException(topicPartition).logStartOffset();
                        builder.add(topicPartition, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch()))));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition);
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
            none$ = new Some((Object)requestBuilder);
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        block1: {
            Replica replica = this.replicaMgr.localReplicaOrException(tp);
            Partition partition = (Partition)this.replicaMgr.getPartition(tp).get();
            partition.truncateTo(offsetTruncationState.offset(), false);
            if (offsetTruncationState.offset() < replica.highWatermark().messageOffset()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(String.valueOf(BoxesRunTime.boxToLong((long)replica.highWatermark().messageOffset()))).toString());
            }
            if (!offsetTruncationState.truncationCompleted()) break block1;
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        partition.truncateFullyAndStartAt(offset, false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        Map map;
        if (this.brokerSupportsLeaderEpochRequest()) {
            Map map2;
            Tuple2 tuple2 = partitions.partition((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$fetchEpochsFromLeader$2(x0$3)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map partitionsWithEpoch = (Map)tuple2._1();
            Map partitionsWithoutEpoch = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)partitionsWithEpoch, (Object)partitionsWithoutEpoch);
            Tuple2 tuple23 = tuple22;
            Map partitionsWithEpoch2 = (Map)tuple23._1();
            Map partitionsWithoutEpoch2 = (Map)tuple23._2();
            Map resultWithoutEpoch = ReplicaFetcherThread.undefinedResponseMap$1(Errors.NONE, partitionsWithoutEpoch2);
            if (partitionsWithEpoch2.isEmpty()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
                return resultWithoutEpoch;
            }
            OffsetsForLeaderEpochRequest.Builder epochRequest = new OffsetsForLeaderEpochRequest.Builder(this.offsetForLeaderEpochRequestVersion(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitionsWithEpoch2).asJava());
            try {
                ClientResponse response = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
                OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Receive leaderEpoch response ").append(response).append("; ").append(new StringBuilder(31).append("Skipped request for partitions ").append(partitionsWithoutEpoch2.keys()).toString()).toString());
                map2 = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(responseBody.responses()).asScala();
            }
            catch (Throwable t) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                map2 = ReplicaFetcherThread.undefinedResponseMap$1(Errors.forException((Throwable)t), partitionsWithEpoch2);
            }
            Map resultWithEpoch = map2;
            map = resultWithEpoch.$plus$plus((GenTraversableOnce)resultWithoutEpoch);
        } else {
            map = ReplicaFetcherThread.undefinedResponseMap$1(Errors.NONE, partitions);
        }
        return map;
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition);
        return quota.isThrottled(topicPartition) && quota.isQuotaExceeded() && !isReplicaInSync;
    }

    private static final Map undefinedResponseMap$1(Errors error, Map requestMap) {
        return (Map)requestMap.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(error, -1, -1L));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$fetchEpochsFromLeader$2(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple2._2();
        boolean bl = epochData.leaderEpoch != -1;
        return bl;
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.metrics = metrics;
        this.time = time;
        this.quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = new LogContext(new StringBuilder(39).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(super.sourceBroker().id()).append(", ").append(new StringBuilder(12).append("fetcherId=").append(fetcherId).append("] ").toString()).toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0 & Serializable & scala.Serializable)() -> new ReplicaFetcherBlockingSend(this.super$sourceBroker(), $this.brokerConfig, $this.metrics, $this.time, $this.fetcherId, new StringBuilder(16).append("broker-").append(this.replicaId()).append("-fetcher-").append($this.fetcherId).toString(), this.logContext()));
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV2$.MODULE$) ? 10 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0))))))));
        this.offsetForLeaderEpochRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? 1 : 0));
        this.listOffsetRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0))));
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.brokerSupportsLeaderEpochRequest = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.logContext(), super.sourceBroker().id());
    }
}

