/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogAppendInfo;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011DU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bI*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011%i\u0001A!A!\u0002\u0013q1$\u0001\u0003oC6,\u0007CA\b\u0019\u001d\t\u0001b\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\r\u00051AH]8pizR\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\ta\u0001\u0015:fI\u00164\u0017BA\r\u001b\u0005\u0019\u0019FO]5oO*\u0011q\u0003F\u0005\u0003\u001bqI!!\b\u0010\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u0003?\u0011\tQ!\u001e;jYND\u0011\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0015\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\"\u0011aB2mkN$XM]\u0005\u0003O\u0011\u0012aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/\u0003\u0002\"\u0015!A!\u0006\u0001B\u0001B\u0003%1&\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0002\nY%\u0011QF\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003\u0013EJ!A\r\u0002\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"AA\u0007\u0001B\u0001B\u0003%Q'A\u0003rk>$\u0018\r\u0005\u0002\nm%\u0011qG\u0001\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJD\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u0004\"!C\u001e\n\u0005q\u0012!\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0019a\u0014N\\5u}Q9\u0001)\u0011\"D\t\u00163\u0005CA\u0005\u0001\u0011\u0015iQ\b1\u0001\u000f\u0011\u0015\tS\b1\u0001#\u0011\u0015QS\b1\u0001,\u0011\u0015yS\b1\u00011\u0011\u0015!T\b1\u00016\u0011\u0015IT\b1\u0001;\u0011\u001dA\u0005A1A\u0005\n%\u000b\u0011B]3qY&\u001c\u0017-\u00133\u0016\u0003)\u0003\"a\u0013'\u000e\u0003QI!!\u0014\u000b\u0003\u0007%sG\u000f\u0003\u0004P\u0001\u0001\u0006IAS\u0001\u000be\u0016\u0004H.[2b\u0013\u0012\u0004\u0003bB)\u0001\u0005\u0004%IAU\u0001\t[\u0006D()\u001f;fgV\t1\u000b\u0005\u0002U36\tQK\u0003\u0002W/\u0006!A.\u00198h\u0015\u0005A\u0016\u0001\u00026bm\u0006L!AW+\u0003\u000f%sG/Z4fe\"1A\f\u0001Q\u0001\nM\u000b\u0011\"\\1y\u0005f$Xm\u001d\u0011\t\u000fy\u0003!\u0019!C\u0005%\u0006Ia-\u001a;dQNK'0\u001a\u0005\u0007A\u0002\u0001\u000b\u0011B*\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0003c\u0001\u0011E3-A\u0006mCR,7\u000f^#q_\u000eDGC\u00013h!\rYUMS\u0005\u0003MR\u0011aa\u00149uS>t\u0007\"\u00025b\u0001\u0004I\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003UJl\u0011a\u001b\u0006\u0003Y6\faaY8n[>t'BA\u0003o\u0015\ty\u0007/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0006\u0019qN]4\n\u0005M\\'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006k\u0002!\tF^\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u000b\u0003oj\u0004\"a\u0013=\n\u0005e$\"\u0001\u0002'p]\u001eDQ\u0001\u001b;A\u0002%DQ\u0001 \u0001\u0005Ru\f\u0011#\u001a8e\u001f\u001a47/\u001a;G_J,\u0005o\\2i)\u0015q\u0018QAA\u0004!\rYUm \t\u0004\u0013\u0005\u0005\u0011bAA\u0002\u0005\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007\"\u00025|\u0001\u0004I\u0007BBA\u0005w\u0002\u0007!*A\u0003fa>\u001c\u0007\u000eC\u0004\u0002\u000e\u0001!\t!a\u0004\u0002\u001f\u0019,Go\u00195Ge>lG*Z1eKJ$B!!\u0005\u0002,A1\u00111CA\r\u0003;i!!!\u0006\u000b\u0007\u0005]A#\u0001\u0006d_2dWm\u0019;j_:LA!a\u0007\u0002\u0016\t\u00191+Z9\u0011\r-\u000by\"[A\u0012\u0013\r\t\t\u0003\u0006\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\u0015\u0012qE\u0007\u0002\u0001%\u0019\u0011\u0011\u0006\u0006\u0003\u0013\u0019+Go\u00195ECR\f\u0007\u0002CA\u0017\u0003\u0017\u0001\r!a\f\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005E\u0012Q\b\b\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011qG6\u0002\u0011I,\u0017/^3tiNLA!a\u000f\u00026\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u0011qHA!\u0005\u001d\u0011U/\u001b7eKJTA!a\u000f\u00026!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0013\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0002J\u0005]\u0013\u0011LA/!\u0011YU-a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015\u0005\u0003\rawnZ\u0005\u0005\u0003+\nyEA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\u0007Q\u0006\r\u0003\u0019A5\t\u000f\u0005m\u00131\ta\u0001o\u0006Ya-\u001a;dQ>3gm]3u\u0011!\ty&a\u0011A\u0002\u0005\u0005\u0014!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0004\u0002d\u0005u\u00141\u0011\b\u0005\u0003K\nIH\u0004\u0003\u0002h\u0005]d\u0002BA5\u0003krA!a\u001b\u0002t9!\u0011QNA9\u001d\r\t\u0012qN\u0005\u0002c&\u0011q\u000e]\u0005\u0003\u000b9L!\u0001\\7\n\u0007\u0005]2.\u0003\u0003\u0002|\u0005U\u0012!\u0004$fi\u000eD'+Z:q_:\u001cX-\u0003\u0003\u0002\u0000\u0005\u0005%!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0003\u0002|\u0005U\u0002\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%5.\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003\u001b\u000b9IA\u0004SK\u000e|'\u000fZ:\t\u000f\u0005E\u0005\u0001\"\u0015\u0002\u0014\u0006ib-\u001a;dQ\u0016\u000b'\u000f\\5fgR|eMZ:fi\u001a\u0013x.\u001c'fC\u0012,'\u000fF\u0003x\u0003+\u000b9\n\u0003\u0004i\u0003\u001f\u0003\r!\u001b\u0005\b\u00033\u000by\t1\u0001K\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u000f\u0005u\u0005\u0001\"\u0015\u0002 \u0006Yb-\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;Ge>lG*Z1eKJ$Ra^AQ\u0003GCa\u0001[AN\u0001\u0004I\u0007bBAM\u00037\u0003\rA\u0013\u0005\b\u0003O\u0003A\u0011BAU\u0003\u0001zgMZ:fiNs\u0017\r]:i_R4%o\\7DkJ\u0014XM\u001c;SKBd\u0017nY1\u0015\r\u0005-\u0016\u0011WAZ!\u0011\ti%!,\n\t\u0005=\u0016q\n\u0002\u0012\u0019><wJ\u001a4tKR\u001cf.\u00199tQ>$\bB\u00025\u0002&\u0002\u0007\u0011\u000eC\u0004\u0002\u001a\u0006\u0015\u0006\u0019\u0001&\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\u0006)b-\u001a;dQ\u0016\u0003xn\u00195t\rJ|W\u000eT3bI\u0016\u0014H\u0003BA^\u0003\u000f\u0004r!a\u0005\u0002>&\f\t-\u0003\u0003\u0002@\u0006U!aA'baB!\u00111GAb\u0013\u0011\t)-!\u000e\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi\"A\u0011\u0011ZA[\u0001\u0004\tY-\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004r!a\u0005\u0002>&\fi\r\u0005\u0003\u0002&\u0005=\u0017bAAi\u0015\tIQ\t]8dQ\u0012\u000bG/\u0019\u0005\b\u0003+\u0004A\u0011IAl\u0003!!(/\u001e8dCR,GCBAm\u0003?\f\t\u000fE\u0002L\u00037L1!!8\u0015\u0005\u0011)f.\u001b;\t\r!\f\u0019\u000e1\u0001j\u0011!\t\u0019/a5A\u0002\u0005\u0015\u0018a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u0007%\t9/C\u0002\u0002j\n\u0011Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X\rC\u0004\u0002n\u0002!\t&a<\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#HCBAm\u0003c\f\u0019\u0010\u0003\u0004i\u0003W\u0004\r!\u001b\u0005\b\u0003k\fY\u000f1\u0001x\u0003\u0019ygMZ:fi\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\u0018A\u00032vS2$g)\u001a;dQR!\u0011Q B\u000b!\u0019\tyP!\u0004\u0003\u00149!!\u0011\u0001B\u0005\u001d\u0011\u0011\u0019Aa\u0002\u000f\u0007E\u0011)!C\u0001\u0006\u0013\t\u0019A!C\u0002\u0003\f\t\tQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0003\u0003\u0010\tE!\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7OC\u0002\u0003\f\t\u0001BaS3\u00020!A!qCA|\u0001\u0004\u0011I\"\u0001\u0007qCJ$\u0018\u000e^5p]6\u000b\u0007\u000fE\u0004\u0002\u0014\u0005u\u0016Na\u0007\u0011\u0007%\u0011i\"C\u0002\u0003 \t\u00111\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016\u0004")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).epochs().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.latestEpoch()));
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalReplicaOrException(topicPartition).logEndOffset().messageOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        Replica replica = this.replicaMgr.futureLocalReplicaOrException(topicPartition);
        return replica.epochs().flatMap((Function1 & Serializable & scala.Serializable)epochCache -> {
            Tuple2<Object, Object> tuple2 = epochCache.endOffsetFor(epoch);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int foundEpoch = tuple2._1$mcI$sp();
            long foundOffset = tuple2._2$mcJ$sp();
            Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(foundEpoch, foundOffset);
            Tuple2.mcIJ.sp sp3 = sp2;
            int foundEpoch2 = sp3._1$mcI$sp();
            long foundOffset2 = sp3._2$mcJ$sp();
            return foundOffset2 == -1L ? None$.MODULE$ : new Some((Object)new OffsetAndEpoch(foundOffset2, foundEpoch2));
        });
    }

    @Override
    public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), request.version() <= 2, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel());
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray())).mkString(",")).toString());
        }
        return (Seq)partitionData.elem;
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Replica futureReplica = this.replicaMgr.futureLocalReplicaOrException(topicPartition);
        Partition partition = (Partition)this.replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        if (fetchOffset != futureReplica.logEndOffset().messageOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureReplica.logEndOffset().messageOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, true);
        long futureReplicaHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(futureReplica.logEndOffset().messageOffset()), partitionData.highWatermark);
        futureReplica.highWatermark_$eq(new LogOffsetMetadata(futureReplicaHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        futureReplica.maybeIncrementLogStartOffset(partitionData.logStartOffset);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        LogOffsetSnapshot offsetSnapshot = this.offsetSnapshotFromCurrentReplica(topicPartition, leaderEpoch);
        return offsetSnapshot.logStartOffset();
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        LogOffsetSnapshot offsetSnapshot = this.offsetSnapshotFromCurrentReplica(topicPartition, leaderEpoch);
        return offsetSnapshot.logEndOffset().messageOffset();
    }

    private LogOffsetSnapshot offsetSnapshotFromCurrentReplica(TopicPartition topicPartition, int leaderEpoch) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        return partition.fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 != null) {
                TopicPartition tp = (TopicPartition)tuple22._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple22._2();
                try {
                    EpochEndOffset epochEndOffset;
                    if (epochData.leaderEpoch == -1) {
                        epochEndOffset = new EpochEndOffset(-1, -1L);
                    } else {
                        Partition partition = $this.replicaMgr.getPartitionOrException(tp, false);
                        epochEndOffset = partition.lastOffsetForLeaderEpoch(epochData.currentLeaderEpoch, epochData.leaderEpoch, false);
                    }
                    EpochEndOffset endOffset = epochEndOffset;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)t), -1, -1L));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateFullyAndStartAt(offset, true);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        BoxedUnit boxedUnit;
        Option maxPartitionOpt = ((TraversableOnce)partitionMap.filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$buildFetch$1(this, x0$3)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            Tuple2 tuple2;
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$greater((Object)((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() < ((TopicPartition)right._1()).partition()) break block3;
                }
                tuple2 = left;
                return tuple2;
            }
            tuple2 = right;
            return tuple2;
        });
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (maxPartitionOpt.nonEmpty()) {
            Tuple2 tuple2 = (Tuple2)maxPartitionOpt.get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)partitionFetchState);
            Tuple2 tuple23 = tuple22;
            TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
            PartitionFetchState partitionFetchState2 = (PartitionFetchState)tuple23._2();
            try {
                long logStartOffset = this.replicaMgr.futureLocalReplicaOrException(topicPartition2).logStartOffset();
                boxedUnit = requestMap.put(topicPartition2, new FetchRequest.PartitionData(partitionFetchState2.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(partitionFetchState2.currentLeaderEpoch()))));
            }
            catch (KafkaStorageException kafkaStorageException) {
                boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition2);
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        None$ fetchRequestOpt = requestMap.isEmpty() ? None$.MODULE$ : new Some((Object)FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())));
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            FetchPartitionData data = (FetchPartitionData)tuple2._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable & scala.Serializable)x$3 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)x$3).asJava()).orNull(Predef$.MODULE$.$conforms());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset, data.logStartOffset(), abortedTransactions, (BaseRecords)data.records()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$buildFetch$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
        boolean bl = partitionFetchState.isReadyForFetch() && !$this.quota.isQuotaExceeded();
        return bl;
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

