/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread$;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherStats;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import kafka.utils.CoreUtils$;
import kafka.utils.DelayedItem;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.PartitionStates;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011Mc!B\u0001\u0003\u0003\u00039!!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\tQ!\u001e;jYNL!!\u0004\u0006\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\n\u001f\u0001\u0011\t\u0011)A\u0005!u\tAA\\1nKB\u0011\u0011C\u0007\b\u0003%a\u0001\"a\u0005\f\u000e\u0003QQ!!\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0003\u0019\u0001&/\u001a3fM&\u00111\u0004\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e1\u0012BA\b\r\u0011!y\u0002A!A!\u0002\u0013\u0001\u0012\u0001C2mS\u0016tG/\u00133\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\nAb]8ve\u000e,'I]8lKJ,\u0012a\t\t\u0003I\u001dj\u0011!\n\u0006\u0003M\u0011\tqa\u00197vgR,'/\u0003\u0002)K\tq!I]8lKJ,e\u000e\u001a)pS:$\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u001bM|WO]2f\u0005J|7.\u001a:!\u0011!a\u0003A!A!\u0002\u0013i\u0013A\u00044fi\u000eD')Y2l\u001f\u001a4Wj\u001d\t\u0003]=j\u0011AF\u0005\u0003aY\u00111!\u00138u\u0011%\u0011\u0004A!A!\u0002\u0013\u0019d'A\bjg&sG/\u001a:skB$\u0018N\u00197f!\tqC'\u0003\u00026-\t9!i\\8mK\u0006t\u0017B\u0001\u001a\r\u0011\u0015A\u0004\u0001\"\u0001:\u0003\u0019a\u0014N\\5u}Q1!\bP\u001f?\u007f\u0001\u0003\"a\u000f\u0001\u000e\u0003\tAQaD\u001cA\u0002AAQaH\u001cA\u0002AAQ!I\u001cA\u0002\rBq\u0001L\u001c\u0011\u0002\u0003\u0007Q\u0006C\u00043oA\u0005\t\u0019A\u001a\u0006\t\t\u0003\u0001a\u0011\u0002\n\r\u0016$8\r\u001b#bi\u0006\u00042\u0001R)U\u001d\t)u*D\u0001G\u0015\t9\u0005*\u0001\u0005sKF,Xm\u001d;t\u0015\tI%*\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b-S!\u0001T'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0015aA8sO&\u0011\u0001KR\u0001\u000e\r\u0016$8\r\u001b*fgB|gn]3\n\u0005I\u001b&!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0002Q\rB\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bS\u0001\u0007e\u0016\u001cwN\u001d3\n\u0005e3&a\u0002*fG>\u0014Hm]\u0003\u00057\u0002\u0001ALA\u0005Fa>\u001c\u0007\u000eR1uCB\u0011Q\f\u0019\b\u0003\u000bzK!a\u0018$\u00029=3gm]3ug\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti&\u0011!+\u0019\u0006\u0003?\u001aCqa\u0019\u0001C\u0002\u0013%A-A\bqCJ$\u0018\u000e^5p]N#\u0018\r^3t+\u0005)\u0007c\u00014jW6\tqM\u0003\u0002i\u0011\u0006I\u0011N\u001c;fe:\fGn]\u0005\u0003U\u001e\u0014q\u0002U1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\t\u0003w1L!!\u001c\u0002\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\r=\u0004\u0001\u0015!\u0003f\u0003A\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u001c\b\u0005C\u0004r\u0001\t\u0007I\u0011\u0002:\u0002!A\f'\u000f^5uS>tW*\u00199M_\u000e\\W#A:\u0011\u0005QlX\"A;\u000b\u0005Y<\u0018!\u00027pG.\u001c(B\u0001=z\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003un\fA!\u001e;jY*\tA0\u0001\u0003kCZ\f\u0017B\u0001@v\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\"9\u0011\u0011\u0001\u0001!\u0002\u0013\u0019\u0018!\u00059beRLG/[8o\u001b\u0006\u0004Hj\\2lA!I\u0011Q\u0001\u0001C\u0002\u0013%\u0011qA\u0001\u0011a\u0006\u0014H/\u001b;j_:l\u0015\r]\"p]\u0012,\"!!\u0003\u0011\u0007Q\fY!C\u0002\u0002\u000eU\u0014\u0011bQ8oI&$\u0018n\u001c8\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0013\t\u0011\u0003]1si&$\u0018n\u001c8NCB\u001cuN\u001c3!\u0011%\t)\u0002\u0001b\u0001\n\u0013\t9\"\u0001\u0005nKR\u0014\u0018nY%e+\t\tI\u0002\u0005\u0003\u0002\u001c\u0005}QBAA\u000f\u0015\tIE!\u0003\u0003\u0002\"\u0005u!!E\"mS\u0016tG/\u00133B]\u0012\u0014%o\\6fe\"A\u0011Q\u0005\u0001!\u0002\u0013\tI\"A\u0005nKR\u0014\u0018nY%eA!I\u0011\u0011\u0006\u0001C\u0002\u0013\u0005\u00111F\u0001\rM\u0016$8\r[3s'R\fGo]\u000b\u0003\u0003[\u00012aOA\u0018\u0013\r\t\tD\u0001\u0002\r\r\u0016$8\r[3s'R\fGo\u001d\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002.\u0005ia-\u001a;dQ\u0016\u00148\u000b^1ug\u0002B\u0011\"!\u000f\u0001\u0005\u0004%\t!a\u000f\u0002\u001f\u0019,Go\u00195fe2\u000bwm\u0015;biN,\"!!\u0010\u0011\u0007m\ny$C\u0002\u0002B\t\u0011qBR3uG\",'\u000fT1h'R\fGo\u001d\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002>\u0005\u0001b-\u001a;dQ\u0016\u0014H*Y4Ti\u0006$8\u000f\t\u0005\b\u0003\u0013\u0002a\u0011CA&\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA\u0011QJA0\u0003W\n)\bE\u0003/\u0003\u001f\n\u0019&C\u0002\u0002RY\u0011aa\u00149uS>t\u0007\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005eC!A\u0002m_\u001eLA!!\u0018\u0002X\tiAj\\4BaB,g\u000eZ%oM>D\u0001\"!\u0019\u0002H\u0001\u0007\u00111M\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\t)'a\u001a\u000e\u0003!K1!!\u001bI\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001\"!\u001c\u0002H\u0001\u0007\u0011qN\u0001\fM\u0016$8\r[(gMN,G\u000fE\u0002/\u0003cJ1!a\u001d\u0017\u0005\u0011auN\\4\t\u0011\u0005]\u0014q\ta\u0001\u0003s\nQ\u0002]1si&$\u0018n\u001c8ECR\f\u0007cAA>\u00036\t\u0001\u0001C\u0004\u0002\u0000\u00011\t\"!!\u0002\u0011Q\u0014XO\\2bi\u0016$b!a!\u0002\n\u0006-\u0005c\u0001\u0018\u0002\u0006&\u0019\u0011q\u0011\f\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003C\ni\b1\u0001\u0002d!A\u0011QRA?\u0001\u0004\ty)A\bueVt7-\u0019;j_:\u001cF/\u0019;f!\rY\u0014\u0011S\u0005\u0004\u0003'\u0013!!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/\u001a\u0005\b\u0003/\u0003a\u0011CAM\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0004\u0002\u0004\u0006m\u0015Q\u0014\u0005\t\u0003C\n)\n1\u0001\u0002d!A\u0011qTAK\u0001\u0004\ty'\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003G\u0003a\u0011CAS\u0003)\u0011W/\u001b7e\r\u0016$8\r\u001b\u000b\u0005\u0003O\u001b\t\u0001\u0005\u0004\u0002*\u0006}&\u0011\u001f\b\u0004w\u0005-vaBAW\u0005!\u0005\u0011qV\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e!\rY\u0014\u0011\u0017\u0004\u0007\u0003\tA\t!a-\u0014\t\u0005E\u0016Q\u0017\t\u0004]\u0005]\u0016bAA]-\t1\u0011I\\=SK\u001aDq\u0001OAY\t\u0003\ti\f\u0006\u0002\u00020\u001a9\u0011\u0011YAY\u0001\u0006\r'\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7/\u0006\u0003\u0002F\u0006u7\u0003CA`\u0003k\u000b9-!4\u0011\u00079\nI-C\u0002\u0002LZ\u0011q\u0001\u0015:pIV\u001cG\u000fE\u0002/\u0003\u001fL1!!5\u0017\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011-\t).a0\u0003\u0016\u0004%\t!a6\u0002\rI,7/\u001e7u+\t\tI\u000e\u0005\u0003\u0002\\\u0006uG\u0002\u0001\u0003\t\u0003?\fyL1\u0001\u0002b\n\t!+\u0005\u0003\u0002d\u0006%\bc\u0001\u0018\u0002f&\u0019\u0011q\u001d\f\u0003\u000f9{G\u000f[5oOB\u0019a&a;\n\u0007\u00055hCA\u0002B]fD1\"!=\u0002@\nE\t\u0015!\u0003\u0002Z\u00069!/Z:vYR\u0004\u0003bCA{\u0003\u007f\u0013)\u001a!C\u0001\u0003o\f1\u0003]1si&$\u0018n\u001c8t/&$\b.\u0012:s_J,\"!!?\u0011\r\u0005m(\u0011AA2\u001b\t\tiPC\u0002\u0002\u0000Z\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019!!@\u0003\u0007M+G\u000fC\u0006\u0003\b\u0005}&\u0011#Q\u0001\n\u0005e\u0018\u0001\u00069beRLG/[8og^KG\u000f[#se>\u0014\b\u0005C\u00049\u0003\u007f#\tAa\u0003\u0015\r\t5!\u0011\u0003B\n!\u0019\u0011y!a0\u0002Z6\u0011\u0011\u0011\u0017\u0005\t\u0003+\u0014I\u00011\u0001\u0002Z\"A\u0011Q\u001fB\u0005\u0001\u0004\tI\u0010\u0003\u0006\u0003\u0018\u0005}\u0016\u0011!C\u0001\u00053\tAaY8qsV!!1\u0004B\u0011)\u0019\u0011iBa\t\u0003&A1!qBA`\u0005?\u0001B!a7\u0003\"\u0011A\u0011q\u001cB\u000b\u0005\u0004\t\t\u000f\u0003\u0006\u0002V\nU\u0001\u0013!a\u0001\u0005?A!\"!>\u0003\u0016A\u0005\t\u0019AA}\u0011)\u0011I#a0\u0012\u0002\u0013\u0005!1F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0011\u0011iCa\u0011\u0016\u0005\t=\"\u0006BAm\u0005cY#Aa\r\u0011\t\tU\"qH\u0007\u0003\u0005oQAA!\u000f\u0003<\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005{1\u0012AC1o]>$\u0018\r^5p]&!!\u0011\tB\u001c\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\t\u0003?\u00149C1\u0001\u0002b\"Q!qIA`#\u0003%\tA!\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!!1\nB(+\t\u0011iE\u000b\u0003\u0002z\nEB\u0001CAp\u0005\u000b\u0012\r!!9\t\u0015\tM\u0013qXA\u0001\n\u0003\u0012)&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005/\u0002BA!\u0017\u0003`5\u0011!1\f\u0006\u0004\u0005;Z\u0018\u0001\u00027b]\u001eL1a\u0007B.\u0011)\u0011\u0019'a0\u0002\u0002\u0013\u0005!QM\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002[!Q!\u0011NA`\u0003\u0003%\tAa\u001b\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011\u001eB7\u0011%\u0011yGa\u001a\u0002\u0002\u0003\u0007Q&A\u0002yIEB!Ba\u001d\u0002@\u0006\u0005I\u0011\tB;\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B<!\u0019\tYP!\u001f\u0002j&!!1PA\u007f\u0005!IE/\u001a:bi>\u0014\bB\u0003B@\u0003\u007f\u000b\t\u0011\"\u0001\u0003\u0002\u0006A1-\u00198FcV\fG\u000eF\u00024\u0005\u0007C!Ba\u001c\u0003~\u0005\u0005\t\u0019AAu\u0011)\u00119)a0\u0002\u0002\u0013\u0005#\u0011R\u0001\tQ\u0006\u001c\bnQ8eKR\tQ\u0006\u0003\u0006\u0003\u000e\u0006}\u0016\u0011!C!\u0005\u001f\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005/B!Ba%\u0002@\u0006\u0005I\u0011\tBK\u0003\u0019)\u0017/^1mgR\u00191Ga&\t\u0015\t=$\u0011SA\u0001\u0002\u0004\tIo\u0002\u0006\u0003\u001c\u0006E\u0016\u0011!E\u0001\u0005;\u000bACU3tk2$x+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c\b\u0003\u0002B\b\u0005?3!\"!1\u00022\u0006\u0005\t\u0012\u0001BQ'\u0019\u0011y*!.\u0002N\"9\u0001Ha(\u0005\u0002\t\u0015FC\u0001BO\u0011)\u0011iIa(\u0002\u0002\u0013\u0015#q\u0012\u0005\u000b\u0005W\u0013y*!A\u0005\u0002\n5\u0016!B1qa2LX\u0003\u0002BX\u0005k#bA!-\u00038\ne\u0006C\u0002B\b\u0003\u007f\u0013\u0019\f\u0005\u0003\u0002\\\nUF\u0001CAp\u0005S\u0013\r!!9\t\u0011\u0005U'\u0011\u0016a\u0001\u0005gC\u0001\"!>\u0003*\u0002\u0007\u0011\u0011 \u0005\u000b\u0005{\u0013y*!A\u0005\u0002\n}\u0016aB;oCB\u0004H._\u000b\u0005\u0005\u0003\u0014i\r\u0006\u0003\u0003D\n=\u0007#\u0002\u0018\u0002P\t\u0015\u0007c\u0002\u0018\u0003H\n-\u0017\u0011`\u0005\u0004\u0005\u00134\"A\u0002+va2,'\u0007\u0005\u0003\u0002\\\n5G\u0001CAp\u0005w\u0013\r!!9\t\u0015\tE'1XA\u0001\u0002\u0004\u0011\u0019.A\u0002yIA\u0002bAa\u0004\u0002@\n-\u0007B\u0003Bl\u0005?\u000b\t\u0011\"\u0003\u0003Z\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\u000e\u0005\u0003\u0003Z\tu\u0017\u0002\u0002Bp\u00057\u0012aa\u00142kK\u000e$\bB\u0003Br\u0003c\u000b\n\u0011\"\u0001\u0003f\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"Aa:+\u00075\u0012\t\u0004\u0003\u0006\u0003l\u0006E\u0016\u0013!C\u0001\u0005[\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TC\u0001BxU\r\u0019$\u0011\u0007\t\u0006]\u0005=#1\u001f\t\u0005\u0005k\u0014YPD\u0002F\u0005oL1A!?G\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\u0011iPa@\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0019!\u0011 $\t\u0011\r\r\u0011\u0011\u0015a\u0001\u0007\u000b\tA\u0002]1si&$\u0018n\u001c8NCB\u0004r!a?\u0004\b\u0005\r4.\u0003\u0003\u0004\n\u0005u(aA'ba\"91Q\u0002\u0001\u0007\u0012\r=\u0011a\u00037bi\u0016\u001cH/\u00129pG\"$Ba!\u0005\u0004\u0014A!a&a\u0014.\u0011!\t\tga\u0003A\u0002\u0005\r\u0004bBB\f\u0001\u0019E1\u0011D\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003_\u001aY\u0002\u0003\u0005\u0002b\rU\u0001\u0019AA2\u0011\u001d\u0019y\u0002\u0001D\t\u0007C\t\u0011#\u001a8e\u001f\u001a47/\u001a;G_J,\u0005o\\2i)\u0019\u0019\u0019ca\u000b\u0004.A)a&a\u0014\u0004&A\u00191ha\n\n\u0007\r%\"A\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u0011\u0005\u00054Q\u0004a\u0001\u0003GBqaa\f\u0004\u001e\u0001\u0007Q&A\u0003fa>\u001c\u0007\u000eC\u0004\u00044\u00011\tb!\u000e\u0002+\u0019,Go\u00195Fa>\u001c\u0007n\u001d$s_6dU-\u00193feR!1qGB !!\tYpa\u0002\u0002d\re\u0002cA#\u0004<%\u00191Q\b$\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi\"A1\u0011IB\u0019\u0001\u0004\u0019\u0019%\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\u0002\"a?\u0004\b\u0005\r4Q\t\t\u0004\u0003wR\u0006bBB%\u0001\u0019E11J\u0001\u0010M\u0016$8\r\u001b$s_6dU-\u00193feR!1QJB1!\u0019\u0019ye!\u0017\u0004`9!1\u0011KB+\u001d\r\u001921K\u0005\u0002/%\u00191q\u000b\f\u0002\u000fA\f7m[1hK&!11LB/\u0005\r\u0019V-\u001d\u0006\u0004\u0007/2\u0002c\u0002\u0018\u0003H\u0006\r\u0014\u0011\u0010\u0005\t\u0007G\u001a9\u00051\u0001\u0003t\u0006aa-\u001a;dQJ+\u0017/^3ti\"91q\r\u0001\u0007\u0012\r%\u0014!\b4fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$hI]8n\u0019\u0016\fG-\u001a:\u0015\r\u0005=41NB7\u0011!\t\tg!\u001aA\u0002\u0005\r\u0004bBB8\u0007K\u0002\r!L\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0004\u0004t\u00011\tb!\u001e\u00027\u0019,Go\u00195MCR,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0019\tyga\u001e\u0004z!A\u0011\u0011MB9\u0001\u0004\t\u0019\u0007C\u0004\u0004p\rE\u0004\u0019A\u0017\t\u000f\ru\u0004\u0001\"\u0011\u0004\u0000\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002\u0004\"911\u0011\u0001\u0005B\r}\u0014A\u00023p/>\u00148\u000eC\u0004\u0004\b\u0002!Iaa \u0002\u00155\f\u0017PY3GKR\u001c\u0007\u000eC\u0004\u0004\f\u0002!Ia!$\u00025!\fg\u000e\u001a7f!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u000bJ\u0014xN]:\u0015\t\u0005\r5q\u0012\u0005\t\u0007\u0003\u001aI\t1\u0001\u0004\u0012B11qJBJ\u0003GJAa!&\u0004^\tA\u0011\n^3sC\ndW\rC\u0004\u0004\u001a\u0002!Iaa'\u0002/\t,\u0018\u000e\u001c3MK\u0006$WM]#q_\u000eD'+Z9vKN$HCABO!\u0019\tI+a0\u0004D!91\u0011\u0015\u0001\u0005\n\r}\u0014!D7bs\n,GK];oG\u0006$X\rC\u0004\u0004\"\u0002!Ia!*\u0015\t\r\u001d61\u0016\t\u0007\u0003S\u000byl!+\u0011\u0011\u0005m8qAA2\u0003\u001fC\u0001b!,\u0004$\u0002\u00071qG\u0001\u000eM\u0016$8\r[3e\u000bB|7\r[:\t\u000f\rE\u0006\u0001\"\u0003\u00044\u0006\trN\u001c)beRLG/[8o\r\u0016t7-\u001a3\u0015\t\u0005\r5Q\u0017\u0005\t\u0007o\u001by\u000b1\u0001\u0002d\u0005\u0011A\u000f\u001d\u0005\b\u0003\u007f\u0002A\u0011BB^)\u0019\tyi!0\u0004@\"A\u0011\u0011MB]\u0001\u0004\t\u0019\u0007\u0003\u0005\u0004B\u000ee\u0006\u0019AB\u001d\u00039)\u0007o\\2i\u000b:$wJ\u001a4tKRDqa!2\u0001\t\u0013\u00199-A\nqe>\u001cWm]:GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\u0004\u000e%7Q\u001a\u0005\t\u0007\u0017\u001c\u0019\r1\u0001\u0004\u0006\u0005Ya-\u001a;dQN#\u0018\r^3t\u0011!\u0019\u0019ga1A\u0002\tM\bbBBi\u0001\u0011\u000511[\u0001\u001c[\u0006\u00148\u000eU1si&$\u0018n\u001c8t\r>\u0014HK];oG\u0006$\u0018n\u001c8\u0015\r\u0005\r5Q[Bl\u0011!\t\tga4A\u0002\u0005\r\u0004\u0002CBm\u0007\u001f\u0004\r!a\u001c\u0002!Q\u0014XO\\2bi&|gn\u00144gg\u0016$\bbBBo\u0001\u0011\u00051q\\\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\t\u0005\r5\u0011\u001d\u0005\t\u0007G\u001cY\u000e1\u0001\u0004f\u0006\u0011\u0012N\\5uS\u0006dg)\u001a;dQN#\u0018\r^3t!!\tYpa\u0002\u0002d\r\u0015\u0002bBBu\u0001\u0011%11^\u00010kB$\u0017\r^3GKR\u001c\u0007n\u00144gg\u0016$\u0018I\u001c3NCf\u0014W-T1sWR\u0013XO\\2bi&|gnQ8na2,G/\u001a\u000b\u0005\u0003\u0007\u001bi\u000f\u0003\u0005\u0004p\u000e\u001d\b\u0019ABU\u000311W\r^2i\u001f\u001a47/\u001a;t\u0011\u001d\u0019\u0019\u0010\u0001C\u0005\u0007k\f\u0001dZ3u\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f)\u0019\tyia>\u0004z\"A1qWBy\u0001\u0004\t\u0019\u0007\u0003\u0005\u0004|\u000eE\b\u0019AB\u001d\u0003EaW-\u00193fe\u0016\u0003xn\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0007\u007f\u0004A\u0011\u0002C\u0001\u0003UA\u0017M\u001c3mK>+Ho\u00144SC:<W-\u0012:s_J$Ra\rC\u0002\t\u000bA\u0001\"!\u0019\u0004~\u0002\u0007\u00111\r\u0005\b\t\u000f\u0019i\u00101\u0001l\u0003)1W\r^2i'R\fG/\u001a\u0005\b\t\u0017\u0001A\u0011\u0003C\u0007\u0003Y1W\r^2i\u001f\u001a47/\u001a;B]\u0012$&/\u001e8dCR,GCBA8\t\u001f!\t\u0002\u0003\u0005\u0002b\u0011%\u0001\u0019AA2\u0011\u001d\u0019y\u0007\"\u0003A\u00025Bq\u0001\"\u0006\u0001\t\u0003!9\"A\beK2\f\u0017\u0010U1si&$\u0018n\u001c8t)\u0019\t\u0019\t\"\u0007\u0005\u001c!A1\u0011\tC\n\u0001\u0004\u0019\t\n\u0003\u0005\u0005\u001e\u0011M\u0001\u0019AA8\u0003\u0015!W\r\\1z\u0011\u001d!\t\u0003\u0001C\u0001\tG\t\u0001C]3n_Z,\u0007+\u0019:uSRLwN\\:\u0015\t\u0005\rEQ\u0005\u0005\t\tO!y\u00021\u0001\u0002z\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000fC\u0004\u0005,\u0001!\tA!#\u0002\u001dA\f'\u000f^5uS>t7i\\;oi\"AAq\u0001\u0001\u0005\u0002\t!y\u0003\u0006\u0003\u00052\u0011M\u0002\u0003\u0002\u0018\u0002P-D\u0001\"!\u0019\u0005.\u0001\u0007\u00111\r\u0005\t\to\u0001A\u0011\u0001\u0002\u0005:\u0005!\u0002/\u0019:uSRLwN\\:B]\u0012|eMZ:fiN,\"\u0001b\u000f\u0011\u0011\u0005m8qAA2\t{\u00012a\u000fC \u0013\r!\tE\u0001\u0002\u0012\u0013:LG/[1m\r\u0016$8\r[*uCR,\u0007b\u0002C#\u0001\u0011EAqI\u0001\u0010i>lU-\\8ssJ+7m\u001c:egR!A\u0011\nC(!\r)F1J\u0005\u0004\t\u001b2&!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0005R\u0011\r\u0003\u0019\u0001+\u0002\u000fI,7m\u001c:eg\u0002")
public abstract class AbstractFetcherThread
extends ShutdownableThread {
    private final BrokerEndPoint sourceBroker;
    private final int fetchBackOffMs;
    private final PartitionStates<PartitionFetchState> partitionStates;
    private final ReentrantLock partitionMapLock;
    private final Condition partitionMapCond;
    private final ClientIdAndBroker metricId;
    private final FetcherStats fetcherStats;
    private final FetcherLagStats fetcherLagStats;

    public static boolean $lessinit$greater$default$5() {
        return AbstractFetcherThread$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return AbstractFetcherThread$.MODULE$.$lessinit$greater$default$4();
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    private PartitionStates<PartitionFetchState> partitionStates() {
        return this.partitionStates;
    }

    private ReentrantLock partitionMapLock() {
        return this.partitionMapLock;
    }

    private Condition partitionMapCond() {
        return this.partitionMapCond;
    }

    private ClientIdAndBroker metricId() {
        return this.metricId;
    }

    public FetcherStats fetcherStats() {
        return this.fetcherStats;
    }

    public FetcherLagStats fetcherLagStats() {
        return this.fetcherLagStats;
    }

    public abstract Option<LogAppendInfo> processPartitionData(TopicPartition var1, long var2, FetchResponse.PartitionData<Records> var4);

    public abstract void truncate(TopicPartition var1, OffsetTruncationState var2);

    public abstract void truncateFullyAndStartAt(TopicPartition var1, long var2);

    public abstract ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> var1);

    public abstract Option<Object> latestEpoch(TopicPartition var1);

    public abstract long logEndOffset(TopicPartition var1);

    public abstract Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition var1, int var2);

    public abstract Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> var1);

    public abstract Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder var1);

    public abstract long fetchEarliestOffsetFromLeader(TopicPartition var1, int var2);

    public abstract long fetchLatestOffsetFromLeader(TopicPartition var1, int var2);

    @Override
    public void shutdown() {
        this.initiateShutdown();
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.partitionMapCond().signalAll());
        this.awaitShutdown();
        this.fetcherStats().unregister();
        this.fetcherLagStats().unregister();
    }

    @Override
    public void doWork() {
        this.maybeTruncate();
        this.maybeFetch();
    }

    private void maybeFetch() {
        Tuple2 tuple2 = (Tuple2)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.partitionStates().partitionStateMap()).asScala();
            ResultWithPartitions<Option<FetchRequest.Builder>> resultWithPartitions = this.buildFetch((Map<TopicPartition, PartitionFetchState>)fetchStates);
            if (resultWithPartitions == null) {
                throw new MatchError(resultWithPartitions);
            }
            Option<FetchRequest.Builder> fetchRequestOpt = resultWithPartitions.result();
            Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple2 = new Tuple2(fetchRequestOpt, partitionsWithError);
            Tuple2 tuple22 = tuple2;
            Option fetchRequestOpt2 = (Option)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError2);
            if (fetchRequestOpt2.isEmpty()) {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("There are no active partitions. Back off for ").append($this.fetchBackOffMs).append(" ms before sending a fetch request").toString());
                object = BoxesRunTime.boxToBoolean((boolean)this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS));
            } else {
                object = BoxedUnit.UNIT;
            }
            return new Tuple2((Object)fetchStates, (Object)fetchRequestOpt2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)tuple2._1();
        Option fetchRequestOpt = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fetchStates, (Object)fetchRequestOpt);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map fetchStates2 = (scala.collection.mutable.Map)tuple23._1();
        Option fetchRequestOpt2 = (Option)tuple23._2();
        fetchRequestOpt2.foreach((Function1 & Serializable & scala.Serializable)fetchRequest -> {
            this.processFetchRequest((Map<TopicPartition, PartitionFetchState>)fetchStates2, fetchRequest);
            return BoxedUnit.UNIT;
        });
    }

    private void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        block0: {
            if (!partitions.nonEmpty()) break block0;
            this.delayPartitions(partitions, this.fetchBackOffMs);
        }
    }

    private ResultWithPartitions<Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>> buildLeaderEpochRequest() {
        return (ResultWithPartitions)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> {
            ObjectRef partitionsWithoutEpochs = ObjectRef.create((Object)Set$.MODULE$.empty());
            ObjectRef partitionsWithEpochs = ObjectRef.create((Object)Map$.MODULE$.empty());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).foreach((Function1 & Serializable & scala.Serializable)state -> {
                BoxedUnit boxedUnit;
                TopicPartition tp = state.topicPartition();
                if (((PartitionFetchState)state.value()).isTruncating()) {
                    scala.collection.mutable.Iterable iterable;
                    Option<Object> option = this.latestEpoch(tp);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int latestEpoch = BoxesRunTime.unboxToInt((Object)some.value());
                        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.of(Predef$.MODULE$.int2Integer(((PartitionFetchState)state.value()).currentLeaderEpoch())), latestEpoch);
                        iterable = (scala.collection.mutable.Iterable)((scala.collection.mutable.Map)partitionsWithEpochs$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)partitionData));
                    } else if (None$.MODULE$.equals(option)) {
                        iterable = (scala.collection.mutable.Iterable)((scala.collection.mutable.Set)partitionsWithoutEpochs$1.elem).$plus$eq((Object)tp);
                    } else {
                        throw new MatchError(option);
                    }
                    boxedUnit = iterable;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Build leaderEpoch request ").append((scala.collection.mutable.Map)partitionsWithEpochs$1.elem).toString());
            return new ResultWithPartitions<scala.collection.mutable.Map>((scala.collection.mutable.Map)partitionsWithEpochs.elem, (Set<TopicPartition>)((scala.collection.mutable.Set)partitionsWithoutEpochs.elem));
        });
    }

    private void maybeTruncate() {
        block1: {
            ResultWithPartitions<Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>> resultWithPartitions = this.buildLeaderEpochRequest();
            if (resultWithPartitions == null) {
                throw new MatchError(resultWithPartitions);
            }
            Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> epochRequests = resultWithPartitions.result();
            Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2 tuple2 = new Tuple2(epochRequests, partitionsWithError);
            Tuple2 tuple22 = tuple2;
            Map epochRequests2 = (Map)tuple22._1();
            Set partitionsWithError2 = (Set)tuple22._2();
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError2);
            if (!epochRequests2.nonEmpty()) break block1;
            Map<TopicPartition, EpochEndOffset> fetchedEpochs = this.fetchEpochsFromLeader((Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>)epochRequests2);
            CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Map leaderEpochs = (Map)fetchedEpochs.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherThread.$anonfun$maybeTruncate$2(this, x0$1)));
                ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> resultWithPartitions = this.maybeTruncate((Map<TopicPartition, EpochEndOffset>)leaderEpochs);
                if (resultWithPartitions == null) {
                    throw new MatchError(resultWithPartitions);
                }
                Map<TopicPartition, OffsetTruncationState> fetchOffsets = resultWithPartitions.result();
                Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
                Tuple2 tuple2 = new Tuple2(fetchOffsets, partitionsWithError);
                Tuple2 tuple22 = tuple2;
                Map fetchOffsets2 = (Map)tuple22._1();
                Set partitionsWithError2 = (Set)tuple22._2();
                this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError2);
                this.updateFetchOffsetAndMaybeMarkTruncationComplete((Map<TopicPartition, OffsetTruncationState>)fetchOffsets2);
            });
        }
    }

    private ResultWithPartitions<Map<TopicPartition, OffsetTruncationState>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        HashMap fetchOffsets = HashMap$.MODULE$.empty();
        HashSet partitionsWithError = HashSet$.MODULE$.empty();
        fetchedEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            HashSet hashSet;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                EpochEndOffset leaderEpochOffset = (EpochEndOffset)tuple2._2();
                try {
                    Option option;
                    Errors errors = leaderEpochOffset.error();
                    if (Errors.NONE.equals(errors)) {
                        OffsetTruncationState offsetTruncationState = this.truncate(tp, leaderEpochOffset);
                        option = fetchOffsets.put((Object)tp, (Object)offsetTruncationState);
                    } else if (Errors.FENCED_LEADER_EPOCH.equals(errors)) {
                        this.onPartitionFenced(tp);
                        option = BoxedUnit.UNIT;
                    } else {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Retrying leaderEpoch request for partition ").append(tp).append(" as the leader reported an error: ").append(errors).toString());
                        option = partitionsWithError.$plus$eq((Object)tp);
                    }
                    hashSet = option;
                }
                catch (KafkaStorageException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Failed to truncate ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    hashSet = partitionsWithError.$plus$eq((Object)tp);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        });
        return new ResultWithPartitions<HashMap>(fetchOffsets, (Set<TopicPartition>)partitionsWithError);
    }

    private void onPartitionFenced(TopicPartition tp) {
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Option$.MODULE$.apply(this.partitionStates().stateValue(tp)).foreach((Function1 & Serializable & scala.Serializable)currentFetchState -> {
            AbstractFetcherThread.$anonfun$onPartitionFenced$2(this, tp, currentFetchState);
            return BoxedUnit.UNIT;
        }));
    }

    /*
     * WARNING - void declaration
     */
    private OffsetTruncationState truncate(TopicPartition topicPartition, EpochEndOffset epochEndOffset) {
        void var3_3;
        OffsetTruncationState offsetTruncationState = this.getOffsetTruncationState(topicPartition, epochEndOffset);
        this.truncate(topicPartition, offsetTruncationState);
        return var3_3;
    }

    private void processFetchRequest(Map<TopicPartition, PartitionFetchState> fetchStates, FetchRequest.Builder fetchRequest) {
        block3: {
            Object object;
            scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            ObjectRef responseData = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
            try {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Sending fetch request ").append(fetchRequest).toString());
                responseData.elem = this.fetchFromLeader(fetchRequest);
                object = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                if (this.isRunning()) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error in response for fetch request ").append(fetchRequest).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    object = CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                        partitionsWithError.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.partitionStates().partitionSet()).asScala());
                        return this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS);
                    });
                }
                object = BoxedUnit.UNIT;
            }
            this.fetcherStats().requestRate().mark();
            Object object2 = ((Seq)responseData.elem).nonEmpty() ? CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Seq)responseData$1.elem).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                AbstractFetcherThread.$anonfun$processFetchRequest$6(this, fetchStates, partitionsWithError, x0$3);
                return BoxedUnit.UNIT;
            })) : BoxedUnit.UNIT;
            if (!partitionsWithError.nonEmpty()) break block3;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Handling errors for partitions ").append(partitionsWithError).toString());
            this.handlePartitionsWithErrors((Iterable<TopicPartition>)partitionsWithError);
        }
    }

    public void markPartitionsForTruncation(TopicPartition topicPartition, long truncationOffset) {
        this.partitionMapLock().lockInterruptibly();
        try {
            Option$.MODULE$.apply(this.partitionStates().stateValue(topicPartition)).foreach((Function1 & Serializable & scala.Serializable)state -> {
                AbstractFetcherThread.$anonfun$markPartitionsForTruncation$1(this, topicPartition, truncationOffset, state);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void addPartitions(Map<TopicPartition, OffsetAndEpoch> initialFetchStates) {
        this.partitionMapLock().lockInterruptibly();
        try {
            initialFetchStates.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                AbstractFetcherThread.$anonfun$addPartitions$1(this, x0$4);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    private void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        scala.collection.immutable.Map newStates = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)state -> {
            PartitionFetchState partitionFetchState;
            PartitionFetchState currentFetchState = (PartitionFetchState)state.value();
            Option option = fetchOffsets.get((Object)state.topicPartition());
            if (option instanceof Some) {
                Some some = (Some)option;
                OffsetTruncationState offsetTruncationState = (OffsetTruncationState)some.value();
                Product state2 = offsetTruncationState.truncationCompleted() ? Fetching$.MODULE$ : Truncating$.MODULE$;
                partitionFetchState = new PartitionFetchState(offsetTruncationState.offset(), currentFetchState.currentLeaderEpoch(), currentFetchState.delay(), (ReplicaState)state2);
            } else if (None$.MODULE$.equals(option)) {
                partitionFetchState = currentFetchState;
            } else {
                throw new MatchError((Object)option);
            }
            PartitionFetchState maybeTruncationComplete = partitionFetchState;
            return new Tuple2((Object)state.topicPartition(), (Object)maybeTruncationComplete);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.partitionStates().set((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newStates).asJava());
    }

    private OffsetTruncationState getOffsetTruncationState(TopicPartition tp, EpochEndOffset leaderEpochOffset) {
        return (OffsetTruncationState)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> {
            OffsetTruncationState offsetTruncationState;
            if (leaderEpochOffset.endOffset() == -1L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Based on replica's leader epoch, leader replied with an unknown offset in ").append(tp).append(". ").append(new StringBuilder(54).append("The initial fetch offset ").append(((PartitionFetchState)this.partitionStates().stateValue(tp)).fetchOffset()).append(" will be used for truncation.").toString()).toString());
                offsetTruncationState = new OffsetTruncationState(((PartitionFetchState)this.partitionStates().stateValue(tp)).fetchOffset(), true);
            } else if (leaderEpochOffset.leaderEpoch() == -1) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append("Leader or replica is on protocol version where leader epoch is not considered in the OffsetsForLeaderEpoch response. ").append(new StringBuilder(53).append("The leader's offset ").append(leaderEpochOffset.endOffset()).append(" will be used for truncation in ").append(tp).append(".").toString()).toString());
                offsetTruncationState = new OffsetTruncationState(package$.MODULE$.min(leaderEpochOffset.endOffset(), this.logEndOffset(tp)), true);
            } else {
                OffsetTruncationState offsetTruncationState2;
                Some some;
                OffsetAndEpoch offsetAndEpoch;
                long replicaEndOffset = this.logEndOffset(tp);
                Option<OffsetAndEpoch> option = this.endOffsetForEpoch(tp, leaderEpochOffset.leaderEpoch());
                if (option instanceof Some && (offsetAndEpoch = (OffsetAndEpoch)(some = (Some)option).value()) != null) {
                    OffsetTruncationState offsetTruncationState3;
                    long followerEndOffset = offsetAndEpoch.offset();
                    int followerEpoch = offsetAndEpoch.leaderEpoch();
                    if (followerEpoch != leaderEpochOffset.leaderEpoch()) {
                        long intermediateOffsetToTruncateTo = package$.MODULE$.min(followerEndOffset, replicaEndOffset);
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Based on replica's leader epoch, leader replied with epoch ").append(leaderEpochOffset.leaderEpoch()).append(" ").append(new StringBuilder(29).append("unknown to the replica for ").append(tp).append(". ").toString()).append(new StringBuilder(70).append("Will truncate to ").append(intermediateOffsetToTruncateTo).append(" and send another leader epoch request to the leader.").toString()).toString());
                        offsetTruncationState3 = new OffsetTruncationState(intermediateOffsetToTruncateTo, false);
                    } else {
                        long offsetToTruncateTo = package$.MODULE$.min(followerEndOffset, leaderEpochOffset.endOffset());
                        offsetTruncationState3 = new OffsetTruncationState(package$.MODULE$.min(offsetToTruncateTo, replicaEndOffset), true);
                    }
                    offsetTruncationState2 = offsetTruncationState3;
                } else if (None$.MODULE$.equals(option)) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Based on replica's leader epoch, leader replied with epoch ").append(leaderEpochOffset.leaderEpoch()).append(" ").append(new StringBuilder(41).append("below any replica's tracked epochs for ").append(tp).append(". ").toString()).append(new StringBuilder(54).append("The leader's offset only ").append(leaderEpochOffset.endOffset()).append(" will be used for truncation.").toString()).toString());
                    offsetTruncationState2 = new OffsetTruncationState(package$.MODULE$.min(leaderEpochOffset.endOffset(), replicaEndOffset), true);
                } else {
                    throw new MatchError(option);
                }
                offsetTruncationState = offsetTruncationState2;
            }
            return offsetTruncationState;
        });
    }

    private boolean handleOutOfRangeError(TopicPartition topicPartition, PartitionFetchState fetchState) {
        boolean bl;
        try {
            long newOffset = this.fetchOffsetAndTruncate(topicPartition, fetchState.currentLeaderEpoch());
            PartitionFetchState newFetchState = PartitionFetchState$.MODULE$.apply(newOffset, fetchState.currentLeaderEpoch(), Fetching$.MODULE$);
            this.partitionStates().updateAndMoveToEnd(topicPartition, (Object)newFetchState);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Current offset ").append(fetchState.fetchOffset()).append(" for partition ").append(topicPartition).append(" is ").append(new StringBuilder(77).append("out of range, which typically implies a leader change. Reset fetch offset to ").append(newOffset).toString()).toString());
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FencedLeaderEpochException) {
                this.onPartitionFenced(topicPartition);
                bl2 = true;
            } else {
                boolean bl3 = throwable2 instanceof UnknownTopicOrPartitionException ? true : (throwable2 instanceof UnknownLeaderEpochException ? true : throwable2 instanceof NotLeaderForPartitionException);
                if (bl3) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Could not fetch offset for ").append(topicPartition).append(" due to error: ").append(throwable2.getMessage()).toString());
                    bl2 = false;
                } else if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error getting offset for partition ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable3);
                    bl2 = false;
                } else {
                    throw throwable;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    public long fetchOffsetAndTruncate(TopicPartition topicPartition, int currentLeaderEpoch) {
        long l;
        long replicaEndOffset = this.logEndOffset(topicPartition);
        long leaderEndOffset = this.fetchLatestOffsetFromLeader(topicPartition, currentLeaderEpoch);
        if (leaderEndOffset < replicaEndOffset) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Reset fetch offset for partition ").append(topicPartition).append(" from ").append(replicaEndOffset).append(" to current ").append(new StringBuilder(23).append("leader's latest offset ").append(leaderEndOffset).toString()).toString());
            this.truncate(topicPartition, new EpochEndOffset(Errors.NONE, -1, leaderEndOffset));
            l = leaderEndOffset;
        } else {
            long leaderStartOffset = this.fetchEarliestOffsetFromLeader(topicPartition, currentLeaderEpoch);
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Reset fetch offset for partition ").append(topicPartition).append(" from ").append(replicaEndOffset).append(" to current ").append(new StringBuilder(22).append("leader's start offset ").append(leaderStartOffset).toString()).toString());
            long offsetToFetch = Math.max(leaderStartOffset, replicaEndOffset);
            if (leaderStartOffset > replicaEndOffset) {
                this.truncateFullyAndStartAt(topicPartition, leaderStartOffset);
            }
            l = offsetToFetch;
        }
        return l;
    }

    public void delayPartitions(Iterable<TopicPartition> partitions, long delay) {
        this.partitionMapLock().lockInterruptibly();
        try {
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                AbstractFetcherThread.$anonfun$delayPartitions$1(this, delay, partition);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void removePartitions(Set<TopicPartition> topicPartitions) {
        this.partitionMapLock().lockInterruptibly();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                AbstractFetcherThread.$anonfun$removePartitions$1(this, topicPartition);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public int partitionCount() {
        int n;
        this.partitionMapLock().lockInterruptibly();
        try {
            n = this.partitionStates().size();
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return n;
    }

    public Option<PartitionFetchState> fetchState(TopicPartition topicPartition) {
        return (Option)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply(this.partitionStates().stateValue(topicPartition)));
    }

    public Map<TopicPartition, InitialFetchState> partitionsAndOffsets() {
        return (Map)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1 & Serializable & scala.Serializable)state -> {
            InitialFetchState initialFetchState = new InitialFetchState(this.sourceBroker(), ((PartitionFetchState)state.value()).currentLeaderEpoch(), ((PartitionFetchState)state.value()).fetchOffset());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.topicPartition()), (Object)initialFetchState);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public MemoryRecords toMemoryRecords(Records records) {
        MemoryRecords memoryRecords;
        Records records2 = records;
        if (records2 instanceof MemoryRecords) {
            MemoryRecords memoryRecords2;
            memoryRecords = memoryRecords2 = (MemoryRecords)records2;
        } else if (records2 instanceof FileRecords) {
            FileRecords fileRecords = (FileRecords)records2;
            ByteBuffer buffer = ByteBuffer.allocate(fileRecords.sizeInBytes());
            fileRecords.readInto(buffer, 0);
            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
        } else {
            throw new MatchError((Object)records2);
        }
        return memoryRecords;
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncate$2(AbstractFetcherThread $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        boolean bl = $this.partitionStates().contains(tp);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$onPartitionFenced$2(AbstractFetcherThread $this, TopicPartition tp$2, PartitionFetchState currentFetchState) {
        int currentLeaderEpoch = currentFetchState.currentLeaderEpoch();
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("Partition ").append(tp$2).append(" has an older epoch (").append(currentLeaderEpoch).append(") than the current leader. Will await ").append("the new LeaderAndIsr state before resuming fetching.").toString());
        $this.partitionStates().remove(tp$2);
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$8(AbstractFetcherThread $this, TopicPartition topicPartition$3, FetchResponse.PartitionData partitionData$1, PartitionFetchState fetchState$1, LogAppendInfo logAppendInfo) {
        block0: {
            long nextOffset = logAppendInfo.lastOffset() + 1L;
            $this.fetcherLagStats().getAndMaybePut(topicPartition$3).lag_$eq(Math.max(0L, partitionData$1.highWatermark - nextOffset));
            int validBytes = logAppendInfo.validBytes();
            if (validBytes <= 0 || !$this.partitionStates().contains(topicPartition$3)) break block0;
            PartitionFetchState newFetchState = PartitionFetchState$.MODULE$.apply(nextOffset, fetchState$1.currentLeaderEpoch(), Fetching$.MODULE$);
            $this.partitionStates().updateAndMoveToEnd(topicPartition$3, (Object)newFetchState);
            $this.fetcherStats().byteRate().mark((long)validBytes);
        }
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$6(AbstractFetcherThread $this, Map fetchStates$2, scala.collection.mutable.Set partitionsWithError$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)tuple2._2();
        Option$.MODULE$.apply($this.partitionStates().stateValue(topicPartition)).foreach((Function1 & Serializable & scala.Serializable)currentFetchState -> {
            BoxedUnit boxedUnit;
            PartitionFetchState fetchState = (PartitionFetchState)fetchStates$2.apply((Object)topicPartition);
            if (fetchState.fetchOffset() == currentFetchState.fetchOffset() && currentFetchState.isReadyForFetch()) {
                BoxedUnit boxedUnit2;
                Errors errors = partitionData$1.error;
                if (Errors.NONE.equals(errors)) {
                    SetLike setLike;
                    try {
                        Option<LogAppendInfo> logAppendInfoOpt = $this.processPartitionData(topicPartition, currentFetchState.fetchOffset(), (FetchResponse.PartitionData<Records>)partitionData);
                        logAppendInfoOpt.foreach((Function1 & Serializable & scala.Serializable)logAppendInfo -> {
                            AbstractFetcherThread.$anonfun$processFetchRequest$8($this, topicPartition, partitionData, fetchState, logAppendInfo);
                            return BoxedUnit.UNIT;
                        });
                        setLike = BoxedUnit.UNIT;
                    }
                    catch (CorruptRecordException ime) {
                        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Found invalid messages during fetch for partition ").append(topicPartition).append(" ").append(new StringBuilder(7).append("offset ").append(currentFetchState.fetchOffset()).toString()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ime);
                        setLike = partitionsWithError$2.$plus$eq((Object)topicPartition);
                    }
                    catch (KafkaStorageException e) {
                        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error while processing data for partition ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        setLike = partitionsWithError$2.$plus$eq((Object)topicPartition);
                    }
                    catch (Throwable e) {
                        throw new KafkaException(new StringBuilder(37).append("Error processing data for partition ").append(topicPartition).append(" ").append(new StringBuilder(7).append("offset ").append(currentFetchState.fetchOffset()).toString()).toString(), e);
                    }
                    boxedUnit2 = setLike;
                } else if (Errors.OFFSET_OUT_OF_RANGE.equals(errors)) {
                    boxedUnit2 = !$this.handleOutOfRangeError(topicPartition, (PartitionFetchState)currentFetchState) ? partitionsWithError$2.$plus$eq((Object)topicPartition) : BoxedUnit.UNIT;
                } else if (Errors.UNKNOWN_LEADER_EPOCH.equals(errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Remote broker has a smaller leader epoch for partition ").append(topicPartition).append(" than ").append(new StringBuilder(40).append("this replica's current leader epoch of ").append(fetchState.currentLeaderEpoch()).append(".").toString()).toString());
                    boxedUnit2 = partitionsWithError$2.$plus$eq((Object)topicPartition);
                } else if (Errors.FENCED_LEADER_EPOCH.equals(errors)) {
                    $this.onPartitionFenced(topicPartition);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (Errors.NOT_LEADER_FOR_PARTITION.equals(errors)) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(102).append("Remote broker is not the leader for partition ").append(topicPartition).append(", which could indicate ").append("that the partition is being moved").toString());
                    boxedUnit2 = partitionsWithError$2.$plus$eq((Object)topicPartition);
                } else {
                    $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Error for partition ").append(topicPartition).append(" at offset ").append(currentFetchState.fetchOffset()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> partitionData$1.error.exception());
                    boxedUnit2 = partitionsWithError$2.$plus$eq((Object)topicPartition);
                }
                boxedUnit = boxedUnit2;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherThread $this, TopicPartition topicPartition$2, long truncationOffset$1, PartitionFetchState state) {
        PartitionFetchState newState = new PartitionFetchState(package$.MODULE$.min(truncationOffset$1, state.fetchOffset()), state.currentLeaderEpoch(), state.delay(), Truncating$.MODULE$);
        $this.partitionStates().updateAndMoveToEnd(topicPartition$2, (Object)newState);
        $this.partitionMapCond().signalAll();
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(AbstractFetcherThread $this, Tuple2 x0$4) {
        PartitionFetchState partitionFetchState;
        TopicPartition tp;
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            tp = (TopicPartition)tuple2._1();
            OffsetAndEpoch initialFetchState = (OffsetAndEpoch)tuple2._2();
            PartitionFetchState currentState = (PartitionFetchState)$this.partitionStates().stateValue(tp);
            if (currentState != null && currentState.currentLeaderEpoch() == initialFetchState.leaderEpoch()) {
                partitionFetchState = currentState;
            } else {
                long initialFetchOffset = initialFetchState.offset() < 0L ? $this.fetchOffsetAndTruncate(tp, initialFetchState.leaderEpoch()) : initialFetchState.offset();
                partitionFetchState = PartitionFetchState$.MODULE$.apply(initialFetchOffset, initialFetchState.leaderEpoch(), Truncating$.MODULE$);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState updatedState = partitionFetchState;
        $this.partitionStates().updateAndMoveToEnd(tp, (Object)updatedState);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$2(AbstractFetcherThread $this, long delay$1, TopicPartition partition$1, PartitionFetchState currentFetchState) {
        block0: {
            if (currentFetchState.isDelayed()) break block0;
            $this.partitionStates().updateAndMoveToEnd(partition$1, (Object)new PartitionFetchState(currentFetchState.fetchOffset(), currentFetchState.currentLeaderEpoch(), new DelayedItem(delay$1), currentFetchState.state()));
        }
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$1(AbstractFetcherThread $this, long delay$1, TopicPartition partition) {
        Option$.MODULE$.apply($this.partitionStates().stateValue(partition)).foreach((Function1 & Serializable & scala.Serializable)currentFetchState -> {
            AbstractFetcherThread.$anonfun$delayPartitions$2($this, delay$1, partition, currentFetchState);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removePartitions$1(AbstractFetcherThread $this, TopicPartition topicPartition) {
        $this.partitionStates().remove(topicPartition);
        $this.fetcherLagStats().unregister(topicPartition);
    }

    public AbstractFetcherThread(String name, String clientId, BrokerEndPoint sourceBroker, int fetchBackOffMs, boolean isInterruptible) {
        this.sourceBroker = sourceBroker;
        this.fetchBackOffMs = fetchBackOffMs;
        super(name, isInterruptible);
        this.partitionStates = new PartitionStates();
        this.partitionMapLock = new ReentrantLock();
        this.partitionMapCond = this.partitionMapLock().newCondition();
        this.metricId = new ClientIdAndBroker(clientId, sourceBroker.host(), sourceBroker.port());
        this.fetcherStats = new FetcherStats(this.metricId());
        this.fetcherLagStats = new FetcherLagStats(this.metricId());
    }

    public static class ResultWithPartitions<R>
    implements Product,
    scala.Serializable {
        private final R result;
        private final Set<TopicPartition> partitionsWithError;

        public R result() {
            return this.result;
        }

        public Set<TopicPartition> partitionsWithError() {
            return this.partitionsWithError;
        }

        public <R> ResultWithPartitions<R> copy(R result, Set<TopicPartition> partitionsWithError) {
            return new ResultWithPartitions<R>(result, partitionsWithError);
        }

        public <R> R copy$default$1() {
            return this.result();
        }

        public <R> Set<TopicPartition> copy$default$2() {
            return this.partitionsWithError();
        }

        public String productPrefix() {
            return "ResultWithPartitions";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.result();
                    break;
                }
                case 1: {
                    object = this.partitionsWithError();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResultWithPartitions;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResultWithPartitions)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResultWithPartitions resultWithPartitions = (ResultWithPartitions)x$1;
            if (!BoxesRunTime.equals(this.result(), resultWithPartitions.result())) return false;
            Set<TopicPartition> set = this.partitionsWithError();
            Set<TopicPartition> set2 = resultWithPartitions.partitionsWithError();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (!resultWithPartitions.canEqual(this)) return false;
            return true;
        }

        public ResultWithPartitions(R result, Set<TopicPartition> partitionsWithError) {
            this.result = result;
            this.partitionsWithError = partitionsWithError;
            Product.$init$((Product)this);
        }
    }
}

