/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;

public class TaskMetrics {
    private static final String AVG_LATENCY_DESCRIPTION = "The average latency of ";
    private static final String MAX_LATENCY_DESCRIPTION = "The maximum latency of ";
    private static final String RATE_DESCRIPTION_PREFIX = "The average number of ";
    private static final String RATE_DESCRIPTION_SUFFIX = " per second";
    private static final String COMMIT = "commit";
    private static final String COMMIT_DESCRIPTION = "calls to commit";
    private static final String COMMIT_TOTAL_DESCRIPTION = "The total number of calls to commit";
    private static final String COMMIT_RATE_DESCRIPTION = "The average number of calls to commit per second";
    private static final String COMMIT_AVG_LATENCY_DESCRIPTION = "The average latency of calls to commit";
    private static final String COMMIT_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to commit";
    private static final String PUNCTUATE = "punctuate";
    private static final String PUNCTUATE_DESCRIPTION = "calls to punctuate";
    private static final String PUNCTUATE_TOTAL_DESCRIPTION = "The total number of calls to punctuate";
    private static final String PUNCTUATE_RATE_DESCRIPTION = "The average number of calls to punctuate per second";
    private static final String PUNCTUATE_AVG_LATENCY_DESCRIPTION = "The average latency of calls to punctuate";
    private static final String PUNCTUATE_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to punctuate";
    private static final String ENFORCED_PROCESSING = "enforced-processing";
    private static final String ENFORCED_PROCESSING_TOTAL_DESCRIPTION = "The total number of occurrences of enforced-processing operations";
    private static final String ENFORCED_PROCESSING_RATE_DESCRIPTION = "The average number of occurrences of enforced-processing operations per second";
    private static final String RECORD_LATENESS = "record-lateness";
    private static final String RECORD_LATENESS_MAX_DESCRIPTION = "The observed maximum lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time";
    private static final String RECORD_LATENESS_AVG_DESCRIPTION = "The observed average lateness of records in milliseconds, measured by comparing the record timestamp with the current stream time";
    private static final String DROPPED_RECORDS = "dropped-records";
    private static final String DROPPED_RECORDS_DESCRIPTION = "dropped records";
    private static final String DROPPED_RECORDS_TOTAL_DESCRIPTION = "The total number of dropped records";
    private static final String DROPPED_RECORDS_RATE_DESCRIPTION = "The average number of dropped records per second";
    private static final String PROCESS = "process";
    private static final String PROCESS_LATENCY = "process-latency";
    private static final String PROCESS_DESCRIPTION = "calls to process";
    private static final String PROCESS_AVG_LATENCY_DESCRIPTION = "The average latency of calls to process";
    private static final String PROCESS_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to process";

    private TaskMetrics() {
    }

    public static Sensor processLatencySensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.LATEST) {
            return TaskMetrics.avgAndMaxSensor(threadId, taskId, PROCESS_LATENCY, PROCESS_AVG_LATENCY_DESCRIPTION, PROCESS_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
        }
        return TaskMetrics.emptySensor(threadId, taskId, PROCESS_LATENCY, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
    }

    public static Sensor punctuateSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.LATEST) {
            return TaskMetrics.invocationRateAndCountAndAvgAndMaxLatencySensor(threadId, taskId, PUNCTUATE, PUNCTUATE_RATE_DESCRIPTION, PUNCTUATE_TOTAL_DESCRIPTION, PUNCTUATE_AVG_LATENCY_DESCRIPTION, PUNCTUATE_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
        }
        return TaskMetrics.emptySensor(threadId, taskId, PUNCTUATE, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
    }

    public static Sensor commitSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensor) {
        return TaskMetrics.invocationRateAndCountAndAvgAndMaxLatencySensor(threadId, taskId, COMMIT, COMMIT_RATE_DESCRIPTION, COMMIT_TOTAL_DESCRIPTION, COMMIT_AVG_LATENCY_DESCRIPTION, COMMIT_MAX_LATENCY_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, parentSensor);
    }

    public static Sensor enforcedProcessingSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        return TaskMetrics.invocationRateAndCountSensor(threadId, taskId, ENFORCED_PROCESSING, ENFORCED_PROCESSING_RATE_DESCRIPTION, ENFORCED_PROCESSING_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, parentSensors);
    }

    public static Sensor recordLatenessSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        return TaskMetrics.avgAndMaxSensor(threadId, taskId, RECORD_LATENESS, RECORD_LATENESS_AVG_DESCRIPTION, RECORD_LATENESS_MAX_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
    }

    public static Sensor droppedRecordsSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        return TaskMetrics.invocationRateAndCountSensor(threadId, taskId, DROPPED_RECORDS, DROPPED_RECORDS_RATE_DESCRIPTION, DROPPED_RECORDS_TOTAL_DESCRIPTION, Sensor.RecordingLevel.INFO, streamsMetrics, new Sensor[0]);
    }

    public static Sensor droppedRecordsSensorOrSkippedRecordsSensor(String threadId, String taskId, StreamsMetricsImpl streamsMetrics) {
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            return ThreadMetrics.skipRecordSensor(threadId, streamsMetrics);
        }
        return TaskMetrics.droppedRecordsSensor(threadId, taskId, streamsMetrics);
    }

    public static Sensor droppedRecordsSensorOrExpiredWindowRecordDropSensor(String threadId, String taskId, String storeType, String storeName, StreamsMetricsImpl streamsMetrics) {
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            return StateStoreMetrics.expiredWindowRecordDropSensor(threadId, taskId, storeType, storeName, streamsMetrics);
        }
        return TaskMetrics.droppedRecordsSensor(threadId, taskId, streamsMetrics);
    }

    public static Sensor droppedRecordsSensorOrLateRecordDropSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        if (streamsMetrics.version() == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            return ProcessorNodeMetrics.lateRecordDropSensor(threadId, taskId, processorNodeId, streamsMetrics);
        }
        return TaskMetrics.droppedRecordsSensor(threadId, taskId, streamsMetrics);
    }

    private static Sensor invocationRateAndCountSensor(String threadId, String taskId, String metricName, String descriptionOfRate, String descriptionOfCount, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, metricName, recordingLevel, parentSensors);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-task-metrics", streamsMetrics.taskLevelTagMap(threadId, taskId), metricName, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static Sensor avgAndMaxSensor(String threadId, String taskId, String metricName, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, metricName, recordingLevel, parentSensors);
        Map<String, String> tagMap = streamsMetrics.taskLevelTagMap(threadId, taskId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-task-metrics", tagMap, metricName, descriptionOfAvg, descriptionOfMax);
        return sensor;
    }

    private static Sensor invocationRateAndCountAndAvgAndMaxLatencySensor(String threadId, String taskId, String metricName, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvg, String descriptionOfMax, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, metricName, recordingLevel, parentSensors);
        Map<String, String> tagMap = streamsMetrics.taskLevelTagMap(threadId, taskId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-task-metrics", tagMap, metricName + "-latency", descriptionOfAvg, descriptionOfMax);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-task-metrics", tagMap, metricName, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static Sensor emptySensor(String threadId, String taskId, String metricName, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        return streamsMetrics.taskLevelSensor(threadId, taskId, metricName, recordingLevel, parentSensors);
    }
}

