/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.header;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.Serializable;
import java.util.Locale;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.services.userprof.UserProfileService;
import org.apache.isis.viewer.wicket.model.models.ServiceActionsModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.widgets.navbar.BrandLogo;
import org.apache.isis.viewer.wicket.ui.components.widgets.navbar.BrandName;
import org.apache.isis.viewer.wicket.ui.components.widgets.navbar.Placement;
import org.apache.isis.viewer.wicket.ui.pages.error.ErrorPage;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class HeaderPanel
extends PanelAbstract<Model<String>> {
    private static final String ID_USER_NAME = "userName";
    private static final String ID_PRIMARY_MENU_BAR = "primaryMenuBar";
    private static final String ID_SECONDARY_MENU_BAR = "secondaryMenuBar";
    private static final String ID_TERTIARY_MENU_BAR = "tertiaryMenuBar";
    @Inject
    @Named(value="applicationName")
    private String applicationName;
    @Inject(optional=true)
    @Named(value="brandLogo")
    private String brandLogo;

    public HeaderPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.addApplicationName();
        this.addUserName();
        this.addServiceActionMenuBars();
    }

    protected void onConfigure() {
        super.onConfigure();
        PageParameters parameters = this.getPage().getPageParameters();
        this.setVisible(parameters.get("isis.no.header").isNull());
    }

    protected void addApplicationName() {
        Class homePage = this.getApplication().getHomePage();
        BookmarkablePageLink applicationNameLink = new BookmarkablePageLink("applicationName", homePage);
        Placement placement = Placement.HEADER;
        BrandLogo brandImage = new BrandLogo("brandLogo", placement);
        BrandName brandName = new BrandName("brandText", Placement.HEADER);
        applicationNameLink.add(new Component[]{brandName, brandImage});
        this.add(new Component[]{applicationNameLink});
    }

    protected void addUserName() {
        UserProfileService userProfileService = this.getUserProfileService();
        Label userName = new Label(ID_USER_NAME, userProfileService.userProfileName());
        this.add(new Component[]{userName});
    }

    private UserProfileService getUserProfileService() {
        return new UserProfileService(){

            public String userProfileName() {
                if (HeaderPanel.this.getPage() instanceof ErrorPage) {
                    return HeaderPanel.this.getAuthenticationSession().getUserName();
                }
                try {
                    UserProfileService userProfileService = (UserProfileService)HeaderPanel.this.lookupService(UserProfileService.class);
                    String userProfileName = userProfileService != null ? userProfileService.userProfileName() : null;
                    return userProfileName != null ? userProfileName : HeaderPanel.this.getAuthenticationSession().getUserName();
                }
                catch (Exception e) {
                    return HeaderPanel.this.getAuthenticationSession().getUserName();
                }
            }
        };
    }

    protected void addServiceActionMenuBars() {
        if (this.getPage() instanceof ErrorPage) {
            Components.permanentlyHide((MarkupContainer)this, ID_PRIMARY_MENU_BAR);
            Components.permanentlyHide((MarkupContainer)this, ID_SECONDARY_MENU_BAR);
            this.addMenuBar((MarkupContainer)this, ID_TERTIARY_MENU_BAR, DomainServiceLayout.MenuBar.TERTIARY);
        } else {
            this.addMenuBar((MarkupContainer)this, ID_PRIMARY_MENU_BAR, DomainServiceLayout.MenuBar.PRIMARY);
            this.addMenuBar((MarkupContainer)this, ID_SECONDARY_MENU_BAR, DomainServiceLayout.MenuBar.SECONDARY);
            this.addMenuBar((MarkupContainer)this, ID_TERTIARY_MENU_BAR, DomainServiceLayout.MenuBar.TERTIARY);
        }
    }

    private void addMenuBar(MarkupContainer container, String id, DomainServiceLayout.MenuBar menuBar) {
        ServiceActionsModel model = new ServiceActionsModel(menuBar);
        Component menuBarComponent = this.getComponentFactoryRegistry().createComponent(ComponentType.SERVICE_ACTIONS, id, (IModel<?>)model);
        menuBarComponent.add(new Behavior[]{AttributeAppender.append((String)"class", (Serializable)((Object)menuBar.name().toLowerCase(Locale.ENGLISH)))});
        container.add(new Component[]{menuBarComponent});
    }
}

