/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.conn;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.impl.nio.conn.CPool;
import org.apache.http.impl.nio.conn.CPoolEntry;
import org.apache.http.impl.nio.conn.CPoolProxy;
import org.apache.http.impl.nio.conn.ManagedNHttpClientConnectionFactory;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.conn.ManagedNHttpClientConnection;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NHttpConnectionFactory;
import org.apache.http.nio.conn.PlainIOSessionFactory;
import org.apache.http.nio.conn.SchemeIOSessionFactory;
import org.apache.http.nio.conn.ssl.SSLIOSessionFactory;
import org.apache.http.nio.pool.NIOConnFactory;
import org.apache.http.nio.pool.SocketAddressResolver;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolingNHttpClientConnectionManager
implements NHttpClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConnectingIOReactor ioreactor;
    private final ConfigData configData;
    private final CPool pool;
    private final Registry<SchemeIOSessionFactory> iosessionFactoryRegistry;

    private static Registry<SchemeIOSessionFactory> getDefaultRegistry() {
        return RegistryBuilder.create().register("http", (Object)PlainIOSessionFactory.INSTANCE).register("https", (Object)SSLIOSessionFactory.getDefaultStrategy()).build();
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor) {
        this(ioreactor, PoolingNHttpClientConnectionManager.getDefaultRegistry());
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, Registry<SchemeIOSessionFactory> iosessionFactoryRegistry) {
        this(ioreactor, null, iosessionFactoryRegistry, null);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, DnsResolver dnsResolver) {
        this(ioreactor, connFactory, PoolingNHttpClientConnectionManager.getDefaultRegistry(), dnsResolver);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory) {
        this(ioreactor, connFactory, PoolingNHttpClientConnectionManager.getDefaultRegistry(), null);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, Registry<SchemeIOSessionFactory> iosessionFactoryRegistry) {
        this(ioreactor, connFactory, iosessionFactoryRegistry, null);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, Registry<SchemeIOSessionFactory> iosessionFactoryRegistry, DnsResolver dnsResolver) {
        this(ioreactor, connFactory, iosessionFactoryRegistry, null, dnsResolver, -1L, TimeUnit.MILLISECONDS);
    }

    public PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory, Registry<SchemeIOSessionFactory> iosessionFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, long timeToLive, TimeUnit tunit) {
        Args.notNull((Object)ioreactor, (String)"I/O reactor");
        Args.notNull(iosessionFactoryRegistry, (String)"I/O session factory registry");
        this.ioreactor = ioreactor;
        this.configData = new ConfigData();
        this.pool = new CPool(ioreactor, new InternalConnectionFactory(this.configData, connFactory), new InternalAddressResolver(schemePortResolver, dnsResolver), 2, 20, timeToLive, tunit != null ? tunit : TimeUnit.MILLISECONDS);
        this.iosessionFactoryRegistry = iosessionFactoryRegistry;
    }

    PoolingNHttpClientConnectionManager(ConnectingIOReactor ioreactor, CPool pool, Registry<SchemeIOSessionFactory> iosessionFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, long timeToLive, TimeUnit tunit) {
        this.ioreactor = ioreactor;
        this.configData = new ConfigData();
        this.pool = pool;
        this.iosessionFactoryRegistry = iosessionFactoryRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void execute(IOEventDispatch eventDispatch) throws IOException {
        this.ioreactor.execute(eventDispatch);
    }

    public void shutdown(long waitMs) throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(waitMs);
        this.log.debug((Object)"Connection manager shut down");
    }

    @Override
    public void shutdown() throws IOException {
        this.log.debug((Object)"Connection manager is shutting down");
        this.pool.shutdown(2000L);
        this.log.debug((Object)"Connection manager shut down");
    }

    private String format(HttpRoute route, Object state) {
        StringBuilder buf = new StringBuilder();
        buf.append("[route: ").append(route).append("]");
        if (state != null) {
            buf.append("[state: ").append(state).append("]");
        }
        return buf.toString();
    }

    private String formatStats(HttpRoute route) {
        StringBuilder buf = new StringBuilder();
        PoolStats totals = this.pool.getTotalStats();
        PoolStats stats = this.pool.getStats(route);
        buf.append("[total kept alive: ").append(totals.getAvailable()).append("; ");
        buf.append("route allocated: ").append(stats.getLeased() + stats.getAvailable());
        buf.append(" of ").append(stats.getMax()).append("; ");
        buf.append("total allocated: ").append(totals.getLeased() + totals.getAvailable());
        buf.append(" of ").append(totals.getMax()).append("]");
        return buf.toString();
    }

    private String format(CPoolEntry entry) {
        StringBuilder buf = new StringBuilder();
        buf.append("[id: ").append(entry.getId()).append("]");
        buf.append("[route: ").append(entry.getRoute()).append("]");
        Object state = entry.getState();
        if (state != null) {
            buf.append("[state: ").append(state).append("]");
        }
        return buf.toString();
    }

    @Override
    public Future<NHttpClientConnection> requestConnection(HttpRoute route, Object state, long connectTimeout, TimeUnit tunit, FutureCallback<NHttpClientConnection> callback) {
        Args.notNull((Object)route, (String)"HTTP route");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection request: " + this.format(route, state) + this.formatStats(route)));
        }
        BasicFuture future = new BasicFuture(callback);
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        SchemeIOSessionFactory sf = (SchemeIOSessionFactory)this.iosessionFactoryRegistry.lookup(host.getSchemeName());
        if (sf == null) {
            future.failed((Exception)new IOException("Unsupported scheme: " + host.getSchemeName()));
            return future;
        }
        this.pool.lease(route, state, connectTimeout, tunit != null ? tunit : TimeUnit.MILLISECONDS, new InternalPoolEntryCallback((BasicFuture<NHttpClientConnection>)future));
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(NHttpClientConnection managedConn, Object state, long keepalive, TimeUnit tunit) {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        NHttpClientConnection nHttpClientConnection = managedConn;
        synchronized (nHttpClientConnection) {
            NHttpClientConnection conn;
            CPoolEntry entry;
            block8: {
                entry = CPoolProxy.detach(managedConn);
                if (entry == null) {
                    return;
                }
                conn = (NHttpClientConnection)entry.getConnection();
                try {
                    if (!conn.isOpen()) break block8;
                    entry.setState(state);
                    entry.updateExpiry(keepalive, tunit != null ? tunit : TimeUnit.MILLISECONDS);
                    if (!this.log.isDebugEnabled()) break block8;
                    String s = keepalive > 0L ? "for " + (double)keepalive / 1000.0 + " seconds" : "indefinitely";
                    this.log.debug((Object)("Connection " + this.format(entry) + " can be kept alive " + s));
                }
                catch (Throwable throwable) {
                    this.pool.release(entry, conn.isOpen() && entry.isRouteComplete());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Connection released: " + this.format(entry) + this.formatStats((HttpRoute)entry.getRoute())));
                    }
                    throw throwable;
                }
            }
            this.pool.release(entry, conn.isOpen() && entry.isRouteComplete());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection released: " + this.format(entry) + this.formatStats((HttpRoute)entry.getRoute())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(NHttpClientConnection managedConn, HttpRoute route, HttpContext context) throws IOException {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        Args.notNull((Object)route, (String)"HTTP route");
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        SchemeIOSessionFactory sf = (SchemeIOSessionFactory)this.iosessionFactoryRegistry.lookup(host.getSchemeName());
        if (sf == null) {
            throw new IOException("Unsupported scheme: " + host.getSchemeName());
        }
        NHttpClientConnection nHttpClientConnection = managedConn;
        synchronized (nHttpClientConnection) {
            CPoolEntry entry = CPoolProxy.getPoolEntry(managedConn);
            ManagedNHttpClientConnection conn = (ManagedNHttpClientConnection)entry.getConnection();
            IOSession currentSession = sf.create(host, conn.getIOSession());
            conn.bind(currentSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgrade(NHttpClientConnection managedConn, HttpRoute route, HttpContext context) throws IOException {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        Args.notNull((Object)route, (String)"HTTP route");
        HttpHost host = route.getTargetHost();
        SchemeIOSessionFactory sf = (SchemeIOSessionFactory)this.iosessionFactoryRegistry.lookup(host.getSchemeName());
        if (sf == null) {
            throw new IOException("Unsupported scheme: " + host.getSchemeName());
        }
        NHttpClientConnection nHttpClientConnection = managedConn;
        synchronized (nHttpClientConnection) {
            CPoolEntry entry = CPoolProxy.getPoolEntry(managedConn);
            ManagedNHttpClientConnection conn = (ManagedNHttpClientConnection)entry.getConnection();
            Asserts.check((boolean)sf.isLayering(), (String)"Layering is not supported for this scheme");
            IOSession currentSession = sf.create(host, conn.getIOSession());
            conn.bind(currentSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void routeComplete(NHttpClientConnection managedConn, HttpRoute route, HttpContext context) {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        Args.notNull((Object)route, (String)"HTTP route");
        NHttpClientConnection nHttpClientConnection = managedConn;
        synchronized (nHttpClientConnection) {
            CPoolEntry entry = CPoolProxy.getPoolEntry(managedConn);
            entry.markRouteComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRouteComplete(NHttpClientConnection managedConn) {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        NHttpClientConnection nHttpClientConnection = managedConn;
        synchronized (nHttpClientConnection) {
            CPoolEntry entry = CPoolProxy.getPoolEntry(managedConn);
            return entry.isRouteComplete();
        }
    }

    @Override
    public void closeIdleConnections(long idleTimeout, TimeUnit tunit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + idleTimeout + " " + (Object)((Object)tunit)));
        }
        this.pool.closeIdle(idleTimeout, tunit);
    }

    @Override
    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        this.pool.closeExpired();
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    public void setMaxTotal(int max) {
        this.pool.setMaxTotal(max);
    }

    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    public void setDefaultMaxPerRoute(int max) {
        this.pool.setDefaultMaxPerRoute(max);
    }

    public int getMaxPerRoute(HttpRoute route) {
        return this.pool.getMaxPerRoute(route);
    }

    public void setMaxPerRoute(HttpRoute route, int max) {
        this.pool.setMaxPerRoute(route, max);
    }

    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    public PoolStats getStats(HttpRoute route) {
        return this.pool.getStats(route);
    }

    public SocketConfig getDefaultSocketConfig() {
        return this.configData.getDefaultSocketConfig();
    }

    public void setDefaultSocketConfig(SocketConfig defaultSocketConfig) {
        this.configData.setDefaultSocketConfig(defaultSocketConfig);
    }

    public ConnectionConfig getDefaultConnectionConfig() {
        return this.configData.getDefaultConnectionConfig();
    }

    public void setDefaultConnectionConfig(ConnectionConfig defaultConnectionConfig) {
        this.configData.setDefaultConnectionConfig(defaultConnectionConfig);
    }

    public SocketConfig getSocketConfig(HttpHost host) {
        return this.configData.getSocketConfig(host);
    }

    public void setSocketConfig(HttpHost host, SocketConfig socketConfig) {
        this.configData.setSocketConfig(host, socketConfig);
    }

    public ConnectionConfig getConnectionConfig(HttpHost host) {
        return this.configData.getConnectionConfig(host);
    }

    public void setConnectionConfig(HttpHost host, ConnectionConfig connectionConfig) {
        this.configData.setConnectionConfig(host, connectionConfig);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InternalAddressResolver
    implements SocketAddressResolver<HttpRoute> {
        private final SchemePortResolver schemePortResolver;
        private final DnsResolver dnsResolver;

        public InternalAddressResolver(SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
            this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
            this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
        }

        public SocketAddress resolveLocalAddress(HttpRoute route) throws IOException {
            return route.getLocalAddress() != null ? new InetSocketAddress(route.getLocalAddress(), 0) : null;
        }

        public SocketAddress resolveRemoteAddress(HttpRoute route) throws IOException {
            HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
            int port = this.schemePortResolver.resolve(host);
            InetAddress[] addresses = this.dnsResolver.resolve(host.getHostName());
            return new InetSocketAddress(addresses[0], port);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InternalConnectionFactory
    implements NIOConnFactory<HttpRoute, ManagedNHttpClientConnection> {
        private final ConfigData configData;
        private final NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory;

        InternalConnectionFactory(ConfigData configData, NHttpConnectionFactory<ManagedNHttpClientConnection> connFactory) {
            this.configData = configData != null ? configData : new ConfigData();
            this.connFactory = connFactory != null ? connFactory : ManagedNHttpClientConnectionFactory.INSTANCE;
        }

        public ManagedNHttpClientConnection create(HttpRoute route, IOSession iosession) throws IOException {
            ConnectionConfig config = null;
            if (route.getProxyHost() != null) {
                config = this.configData.getConnectionConfig(route.getProxyHost());
            }
            if (config == null) {
                config = this.configData.getConnectionConfig(route.getTargetHost());
            }
            if (config == null) {
                config = this.configData.getDefaultConnectionConfig();
            }
            if (config == null) {
                config = ConnectionConfig.DEFAULT;
            }
            ManagedNHttpClientConnection conn = this.connFactory.create(iosession, config);
            iosession.setAttribute("http.connection", (Object)conn);
            return conn;
        }
    }

    static class ConfigData {
        private final Map<HttpHost, SocketConfig> socketConfigMap = new ConcurrentHashMap<HttpHost, SocketConfig>();
        private final Map<HttpHost, ConnectionConfig> connectionConfigMap = new ConcurrentHashMap<HttpHost, ConnectionConfig>();
        private volatile SocketConfig defaultSocketConfig;
        private volatile ConnectionConfig defaultConnectionConfig;

        ConfigData() {
        }

        public SocketConfig getDefaultSocketConfig() {
            return this.defaultSocketConfig;
        }

        public void setDefaultSocketConfig(SocketConfig defaultSocketConfig) {
            this.defaultSocketConfig = defaultSocketConfig;
        }

        public ConnectionConfig getDefaultConnectionConfig() {
            return this.defaultConnectionConfig;
        }

        public void setDefaultConnectionConfig(ConnectionConfig defaultConnectionConfig) {
            this.defaultConnectionConfig = defaultConnectionConfig;
        }

        public SocketConfig getSocketConfig(HttpHost host) {
            return this.socketConfigMap.get(host);
        }

        public void setSocketConfig(HttpHost host, SocketConfig socketConfig) {
            this.socketConfigMap.put(host, socketConfig);
        }

        public ConnectionConfig getConnectionConfig(HttpHost host) {
            return this.connectionConfigMap.get(host);
        }

        public void setConnectionConfig(HttpHost host, ConnectionConfig connectionConfig) {
            this.connectionConfigMap.put(host, connectionConfig);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InternalPoolEntryCallback
    implements FutureCallback<CPoolEntry> {
        private final BasicFuture<NHttpClientConnection> future;

        public InternalPoolEntryCallback(BasicFuture<NHttpClientConnection> future) {
            this.future = future;
        }

        public void completed(CPoolEntry entry) {
            NHttpClientConnection managedConn;
            Asserts.check((entry.getConnection() != null ? 1 : 0) != 0, (String)"Pool entry with no connection");
            if (PoolingNHttpClientConnectionManager.this.log.isDebugEnabled()) {
                PoolingNHttpClientConnectionManager.this.log.debug((Object)("Connection leased: " + PoolingNHttpClientConnectionManager.this.format(entry) + PoolingNHttpClientConnectionManager.this.formatStats((HttpRoute)entry.getRoute())));
            }
            if (!this.future.completed((Object)(managedConn = CPoolProxy.newProxy(entry)))) {
                PoolingNHttpClientConnectionManager.this.pool.release(entry, true);
            }
        }

        public void failed(Exception ex) {
            if (PoolingNHttpClientConnectionManager.this.log.isDebugEnabled()) {
                PoolingNHttpClientConnectionManager.this.log.debug((Object)"Connection request failed", (Throwable)ex);
            }
            this.future.failed(ex);
        }

        public void cancelled() {
            PoolingNHttpClientConnectionManager.this.log.debug((Object)"Connection request cancelled");
            this.future.cancel(true);
        }
    }
}

