/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.DaemonId;
import org.apache.hadoop.hive.llap.security.LlapSigner;
import org.apache.hadoop.hive.llap.security.SecretManager;
import org.apache.hadoop.hive.llap.security.SigningSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.DelegationKey;

public class LlapSignerImpl
implements LlapSigner {
    private final SigningSecretManager secretManager;

    public LlapSignerImpl(Configuration conf, DaemonId daemonId) {
        this.secretManager = SecretManager.createSecretManager((Configuration)conf, (String)daemonId.getClusterString());
    }

    @VisibleForTesting
    public LlapSignerImpl(SigningSecretManager sm) {
        this.secretManager = sm;
    }

    public LlapSigner.SignedMessage serializeAndSign(LlapSigner.Signable message) throws IOException {
        LlapSigner.SignedMessage result = new LlapSigner.SignedMessage();
        DelegationKey key = this.secretManager.getCurrentKey();
        message.setSignInfo(key.getKeyId(), UserGroupInformation.getCurrentUser().getUserName());
        result.message = message.serialize();
        result.signature = this.secretManager.signWithKey(result.message, key);
        return result;
    }

    public void checkSignature(byte[] message, byte[] signature, int keyId) throws SecurityException {
        byte[] expectedSignature = this.secretManager.signWithKey(message, keyId);
        if (Arrays.equals(signature, expectedSignature)) {
            return;
        }
        throw new SecurityException("Message signature does not match");
    }
}

