/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.inject.Named;
import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consume;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.PropertyInject;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.cdi.AnnotatedMethodDelegate;
import org.apache.camel.cdi.AnnotatedTypeDelegate;
import org.apache.camel.cdi.AnyLiteral;
import org.apache.camel.cdi.BeanDelegate;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.CamelBeanInjectionTarget;
import org.apache.camel.cdi.CamelContextDefaultProducer;
import org.apache.camel.cdi.CdiCamelContextAnnotated;
import org.apache.camel.cdi.CdiCamelContextBean;
import org.apache.camel.cdi.CdiCamelEnvironment;
import org.apache.camel.cdi.CdiCamelFactory;
import org.apache.camel.cdi.CdiEventEndpoint;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.CdiTypeConverterLoader;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.DefaultLiteral;
import org.apache.camel.cdi.Excluded;
import org.apache.camel.cdi.ForwardingObserverMethod;
import org.apache.camel.cdi.Mock;
import org.apache.camel.cdi.Uri;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.management.event.AbstractExchangeEvent;
import org.apache.camel.model.RouteContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiCamelExtension
implements Extension {
    private final Logger logger = LoggerFactory.getLogger(CdiCamelExtension.class);
    private final CdiCamelEnvironment environment = new CdiCamelEnvironment();
    private final Set<Class<?>> converters = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AnnotatedType<?>> camelBeans = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AnnotatedType<?>> eagerBeans = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<InjectionPoint, ForwardingObserverMethod<?>> cdiEventEndpoints = new ConcurrentHashMap();
    private final Set<Bean<?>> cdiBeans = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Annotation> contextQualifiers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Annotation> eventQualifiers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Method, Bean<?>> producerBeans = new ConcurrentHashMap();
    private final Map<Method, Set<Annotation>> producerQualifiers = new ConcurrentHashMap<Method, Set<Annotation>>();

    ForwardingObserverMethod<?> getObserverMethod(InjectionPoint ip) {
        return this.cdiEventEndpoints.get(ip);
    }

    Set<Annotation> getObserverEvents() {
        return this.eventQualifiers;
    }

    Set<Annotation> getContextQualifiers() {
        return this.contextQualifiers;
    }

    private void processAnnotatedType(@Observes ProcessAnnotatedType<?> pat) {
        if (pat.getAnnotatedType().isAnnotationPresent(Vetoed.class)) {
            pat.veto();
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), Converter.class)) {
            this.converters.add(pat.getAnnotatedType().getJavaClass());
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), BeanInject.class, Consume.class, EndpointInject.class, Produce.class, PropertyInject.class)) {
            this.camelBeans.add(pat.getAnnotatedType());
        }
        if (CdiSpiHelper.hasAnnotation(pat.getAnnotatedType(), Consume.class)) {
            this.eagerBeans.add(pat.getAnnotatedType());
        }
    }

    private <T extends CamelContext> void camelContextBeans(@Observes ProcessInjectionTarget<T> pit, BeanManager manager) {
        pit.setInjectionTarget(this.environment.camelContextInjectionTarget(pit.getInjectionTarget(), (Annotated)pit.getAnnotatedType(), manager, this));
    }

    private <T extends CamelContext> void camelContextProducers(@Observes ProcessProducer<?, T> pp, BeanManager manager) {
        pp.setProducer(this.environment.camelContextProducer(pp.getProducer(), (Annotated)pp.getAnnotatedMember(), manager, this));
    }

    private <T> void camelBeansPostProcessor(@Observes ProcessInjectionTarget<T> pit, BeanManager manager) {
        if (this.camelBeans.contains(pit.getAnnotatedType())) {
            pit.setInjectionTarget(new CamelBeanInjectionTarget(pit.getInjectionTarget(), manager));
        }
    }

    private <T extends CamelContextAware> void camelContextAware(@Observes ProcessInjectionTarget<T> pit, BeanManager manager) {
        pit.setInjectionTarget(new CamelBeanInjectionTarget(pit.getInjectionTarget(), manager));
    }

    private void cdiEventEndpoints(@Observes ProcessBean<?> pb) {
        for (InjectionPoint ip : pb.getBean().getInjectionPoints()) {
            if (!CdiEventEndpoint.class.equals(CdiSpiHelper.getRawType(ip.getType()))) continue;
            if (ip.getType() instanceof ParameterizedType) {
                this.cdiEventEndpoints.put(ip, new ForwardingObserverMethod(((ParameterizedType)ip.getType()).getActualTypeArguments()[0], ip.getQualifiers()));
                continue;
            }
            if (!(ip.getType() instanceof Class)) continue;
            this.cdiEventEndpoints.put(ip, new ForwardingObserverMethod((Type)((Object)Object.class), ip.getQualifiers()));
        }
    }

    private <T extends Endpoint> void endpointBeans(@Observes ProcessProducerMethod<T, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void consumerTemplateBeans(@Observes ProcessProducerMethod<ConsumerTemplate, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void producerTemplateBeans(@Observes ProcessProducerMethod<ProducerTemplate, CdiCamelFactory> ppm) {
        this.producerBeans.put(ppm.getAnnotatedProducerMethod().getJavaMember(), ppm.getBean());
    }

    private void camelFactoryProducers(@Observes ProcessAnnotatedType<CdiCamelFactory> pat, BeanManager manager) {
        AnnotatedType at = pat.getAnnotatedType();
        HashSet methods = new HashSet();
        for (AnnotatedMethod am : pat.getAnnotatedType().getMethods()) {
            Class<?> type;
            if (!am.isAnnotationPresent(Produces.class) || !Endpoint.class.isAssignableFrom(type = CdiSpiHelper.getRawType(am.getBaseType())) && !ConsumerTemplate.class.equals(type) && !ProducerTemplate.class.equals(type)) continue;
            Set<Annotation> qualifiers = CdiSpiHelper.getQualifiers((Annotated)am, manager);
            this.producerQualifiers.put(am.getJavaMember(), qualifiers);
            HashSet<Annotation> annotations = new HashSet<Annotation>(am.getAnnotations());
            annotations.removeAll(qualifiers);
            annotations.add(Excluded.INSTANCE);
            methods.add(new AnnotatedMethodDelegate(am, annotations));
        }
        pat.setAnnotatedType(new AnnotatedTypeDelegate(at, methods));
    }

    private <T extends EventObject> void camelEventNotifiers(@Observes ProcessObserverMethod<T, ?> pom) {
        Type type = pom.getObserverMethod().getObservedType();
        if (type instanceof Class && ((Class)Class.class.cast(type)).getPackage().equals(AbstractExchangeEvent.class.getPackage())) {
            this.eventQualifiers.addAll(pom.getObserverMethod().getObservedQualifiers().isEmpty() ? Collections.singleton(AnyLiteral.INSTANCE) : pom.getObserverMethod().getObservedQualifiers());
        }
    }

    private void beans(@Observes ProcessProducerField<?, ?> pb) {
        this.cdiBeans.add(pb.getBean());
    }

    private void beans(@Observes ProcessProducerMethod<?, ?> pb) {
        this.cdiBeans.add(pb.getBean());
    }

    private void beans(@Observes ProcessBean<?> pb) {
        this.cdiBeans.add(pb.getBean());
    }

    private void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager manager) {
        HashSet<ContextName> contextNames = new HashSet<ContextName>();
        for (Bean<?> bean : this.cdiBeans) {
            ContextName name;
            if (bean.getTypes().contains(CamelContext.class)) {
                this.contextQualifiers.addAll(bean.getQualifiers());
                continue;
            }
            if (!bean.getTypes().contains(RoutesBuilder.class) && !bean.getTypes().contains(RouteContainer.class) || (name = CdiSpiHelper.getFirstElementOfType(bean.getQualifiers(), ContextName.class)) == null) continue;
            contextNames.add(name);
        }
        contextNames.removeAll(this.contextQualifiers);
        if (this.contextQualifiers.isEmpty() && contextNames.isEmpty() && this.shouldDeployDefaultCamelContext(this.cdiBeans)) {
            abd.addBean(this.camelContextBean(manager, new Annotation[]{AnyLiteral.INSTANCE, DefaultLiteral.INSTANCE}));
        } else if (this.contextQualifiers.isEmpty() && contextNames.size() == 1) {
            ContextName name = (ContextName)contextNames.iterator().next();
            abd.addBean(this.camelContextBean(manager, new Annotation[]{AnyLiteral.INSTANCE, DefaultLiteral.INSTANCE, name}));
            Collections.addAll(this.contextQualifiers, AnyLiteral.INSTANCE, DefaultLiteral.INSTANCE, name);
        } else {
            for (ContextName contextName : contextNames) {
                abd.addBean(this.camelContextBean(manager, new Annotation[]{AnyLiteral.INSTANCE, contextName}));
                Collections.addAll(this.contextQualifiers, AnyLiteral.INSTANCE, contextName);
            }
        }
        for (Map.Entry entry : this.producerBeans.entrySet()) {
            Bean bean = (Bean)entry.getValue();
            HashSet<Annotation> qualifiers = new HashSet<Annotation>((Collection)this.producerQualifiers.get(entry.getKey()));
            Class<?> type = ((Method)entry.getKey()).getReturnType();
            if (CdiEventEndpoint.class.equals(type)) {
                for (InjectionPoint ip : this.cdiEventEndpoints.keySet()) {
                    qualifiers.addAll(ip.getQualifiers());
                }
            } else if (Endpoint.class.isAssignableFrom(type) || ConsumerTemplate.class.equals(type) || ProducerTemplate.class.equals(type)) {
                qualifiers.addAll(CdiSpiHelper.excludeElementOfTypes(this.contextQualifiers, Default.class, Named.class));
            }
            abd.addBean(new BeanDelegate(bean, qualifiers));
        }
        for (ObserverMethod observerMethod : this.cdiEventEndpoints.values()) {
            abd.addObserverMethod(observerMethod);
        }
    }

    private boolean shouldDeployDefaultCamelContext(Set<Bean<?>> beans) {
        for (Bean<?> bean : beans) {
            if (bean.getBeanClass().getPackage().equals(this.getClass().getPackage()) || !bean.getTypes().contains(CamelContextAware.class) && !bean.getTypes().contains(Component.class) && !bean.getTypes().contains(RouteContainer.class) && !bean.getTypes().contains(RoutesBuilder.class) || !bean.getQualifiers().contains(DefaultLiteral.INSTANCE)) continue;
            return true;
        }
        for (AnnotatedType annotatedType : this.camelBeans) {
            for (Annotated field : annotatedType.getFields()) {
                if (!CdiSpiHelper.hasDefaultContext(field)) continue;
                return true;
            }
            for (Annotated method : annotatedType.getMethods()) {
                if (!CdiSpiHelper.hasDefaultContext(method)) continue;
                return true;
            }
        }
        for (Bean<?> bean : beans) {
            if (bean.getBeanClass().getPackage().equals(this.getClass().getPackage())) continue;
            for (InjectionPoint ip : bean.getInjectionPoints()) {
                if (!CdiSpiHelper.getRawType(ip.getType()).getName().startsWith("org.apache.camel")) continue;
                for (Annotation qualifier : ip.getQualifiers()) {
                    if (!qualifier.annotationType().equals(Uri.class) && !qualifier.annotationType().equals(Mock.class) && !qualifier.annotationType().equals(Default.class)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Bean<?> camelContextBean(BeanManager manager, Annotation ... qualifiers) {
        CdiCamelContextAnnotated annotated = new CdiCamelContextAnnotated(manager, qualifiers);
        return new CdiCamelContextBean(annotated, this.environment.camelContextInjectionTarget(new CamelContextDefaultProducer(), annotated, manager, this));
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager manager) {
        ArrayList<CamelContext> contexts = new ArrayList<CamelContext>();
        for (Bean context : manager.getBeans(CamelContext.class, new Annotation[]{AnyLiteral.INSTANCE})) {
            contexts.add(BeanManagerHelper.getReference(manager, CamelContext.class, context));
        }
        CdiTypeConverterLoader loader = new CdiTypeConverterLoader();
        for (Class<?> converter : this.converters) {
            for (CamelContext camelContext : contexts) {
                loader.loadConverterMethods(camelContext.getTypeConverterRegistry(), converter);
            }
        }
        boolean deploymentException = false;
        HashSet routes = new HashSet(manager.getBeans(RoutesBuilder.class, new Annotation[]{AnyLiteral.INSTANCE}));
        routes.addAll(manager.getBeans(RouteContainer.class, new Annotation[]{AnyLiteral.INSTANCE}));
        for (Bean bean : manager.getBeans(CamelContext.class, new Annotation[]{AnyLiteral.INSTANCE})) {
            for (Bean route : routes) {
                HashSet qualifiers = new HashSet(bean.getQualifiers());
                qualifiers.retainAll(route.getQualifiers());
                if (qualifiers.size() <= 1) continue;
                deploymentException |= !this.addRouteToContext(route, bean, manager, adv);
            }
        }
        if (deploymentException) {
            return;
        }
        for (AnnotatedType annotatedType : this.eagerBeans) {
            BeanManagerHelper.getReferencesByType(manager, annotatedType.getJavaClass(), new Annotation[]{AnyLiteral.INSTANCE}).toString();
        }
        for (CamelContext camelContext : contexts) {
            if (ServiceStatus.Started.equals((Object)camelContext.getStatus())) continue;
            this.logger.info("Camel CDI is starting Camel context [{}]", (Object)camelContext.getName());
            try {
                camelContext.start();
            }
            catch (Exception exception) {
                adv.addDeploymentProblem((Throwable)exception);
            }
        }
        this.camelBeans.clear();
        this.cdiBeans.clear();
        this.converters.clear();
        this.eagerBeans.clear();
        this.producerBeans.clear();
        this.producerQualifiers.clear();
    }

    private boolean addRouteToContext(Bean<?> routeBean, Bean<?> contextBean, BeanManager manager, AfterDeploymentValidation adv) {
        try {
            CamelContext context = BeanManagerHelper.getReference(manager, CamelContext.class, contextBean);
            try {
                Object route = BeanManagerHelper.getReference(manager, Object.class, routeBean);
                if (route instanceof RoutesBuilder) {
                    context.addRoutes((RoutesBuilder)route);
                } else if (route instanceof RouteContainer) {
                    context.addRouteDefinitions((Collection)((RouteContainer)route).getRoutes());
                } else {
                    throw new IllegalArgumentException("Invalid routes type [" + routeBean.getBeanClass().getName() + "], must be either of type RoutesBuilder or RouteContainer!");
                }
                return true;
            }
            catch (Exception cause) {
                adv.addDeploymentProblem((Throwable)new InjectionException("Error adding routes of type [" + routeBean.getBeanClass().getName() + "] to Camel context [" + context.getName() + "]", (Throwable)cause));
            }
        }
        catch (Exception exception) {
            adv.addDeploymentProblem((Throwable)exception);
        }
        return false;
    }
}

