/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers.mysql;

import org.apache.activemq.artemis.jdbc.store.sql.GenericSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public class MySQLSQLProvider
extends GenericSQLProvider {
    private static final int MAX_BLOB_SIZE = 0;
    private final String createFileTableSQL;
    private final String createJournalTableSQL;
    private final String copyFileRecordByIdSQL;

    private MySQLSQLProvider(String tName) {
        super(tName.toLowerCase());
        this.createFileTableSQL = "CREATE TABLE " + this.tableName + "(ID INTEGER NOT NULL AUTO_INCREMENT," + "FILENAME VARCHAR(255), EXTENSION VARCHAR(10), DATA LONGBLOB, PRIMARY KEY(ID)) ENGINE=InnoDB;";
        this.createJournalTableSQL = "CREATE TABLE " + this.tableName + "(id BIGINT,recordType SMALLINT,compactCount SMALLINT,txId BIGINT,userRecordType SMALLINT,variableSize INTEGER,record LONGBLOB,txDataSize INTEGER,txData LONGBLOB,txCheckNoRecords INTEGER,seq BIGINT) ENGINE=InnoDB;";
        this.copyFileRecordByIdSQL = " UPDATE " + this.tableName + ", (SELECT DATA AS FROM_DATA FROM " + this.tableName + " WHERE id=?) SELECT_COPY SET DATA=FROM_DATA WHERE id=?;";
    }

    @Override
    public int getMaxBlobSize() {
        return 0;
    }

    @Override
    public String getCreateFileTableSQL() {
        return this.createFileTableSQL;
    }

    @Override
    public String getCreateJournalTableSQL() {
        return this.createJournalTableSQL;
    }

    @Override
    public String getCopyFileRecordByIdSQL() {
        return this.copyFileRecordByIdSQL;
    }

    public static class Factory
    implements SQLProvider.Factory {
        @Override
        public SQLProvider create(String tableName) {
            return new MySQLSQLProvider(tableName);
        }
    }
}

