/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Random;
import net.openhft.koloboke.collect.hash.HashOverflowException;
import net.openhft.koloboke.collect.impl.PrimitiveConstants;
import net.openhft.koloboke.collect.impl.ShortArrays;
import net.openhft.koloboke.collect.impl.ThreadLocalRandom;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.HashConfigWrapper;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVShortLHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableLHash;

public abstract class UpdatableSeparateKVShortLHashSO
extends UpdatableLHash
implements SeparateKVShortLHash,
PrimitiveConstants,
UnsafeConstants {
    short freeValue;
    short[] set;

    void copy(SeparateKVShortLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (short[])hash.keys().clone();
    }

    void move(SeparateKVShortLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, short freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public short freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public short removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Short)key);
    }

    public boolean contains(short key) {
        return this.index(key) >= 0;
    }

    int index(short key) {
        short free = this.freeValue;
        if (key != free) {
            short[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVShortKeyMixing.mix(key) & capacityMask;
            short cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }

    private short findNewFreeOrRemoved() {
        short newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 65535) {
                throw new HashOverflowException();
            }
            short free = this.freeValue;
            Random random = ThreadLocalRandom.current();
            if (size > 49152) {
                int nf = random.nextInt(65536) * 21859;
                for (int i = 0; i < 65536; ++i) {
                    newFree = (short)(nf += 21859);
                    if (newFree == free || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (short)random.nextInt()) == free || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    short changeFree() {
        int mc = this.modCount();
        short newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ShortArrays.replaceAll(this.set, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.set = new short[capacity];
        if (this.freeValue != 0) {
            Arrays.fill(this.set, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.set, this.freeValue);
    }
}

