/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.impl.InternalFloatDoubleMapOps;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVFloatDoubleQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashSeparateKVFloatKeyMap;
import net.openhft.koloboke.collect.map.hash.HashFloatDoubleMap;

public abstract class UpdatableQHashSeparateKVFloatDoubleMapSO
extends UpdatableQHashSeparateKVFloatKeyMap
implements HashFloatDoubleMap,
InternalFloatDoubleMapOps,
SeparateKVFloatDoubleQHash {
    long[] values;

    void copy(SeparateKVFloatDoubleQHash hash) {
        super.copy(hash);
        this.values = (long[])hash.valueArray().clone();
    }

    void move(SeparateKVFloatDoubleQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public long[] valueArray() {
        return this.values;
    }

    int valueIndex(long value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFE || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(long value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(long value) {
        throw new UnsupportedOperationException();
    }

    int valueIndex(double value) {
        if (this.isEmpty()) {
            return -1;
        }
        long val = Double.doubleToLongBits(value);
        int index = -1;
        int mc = this.modCount();
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFE || val != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(double value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Double)value);
    }

    int insert(int key, long value) {
        int[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix(key) % capacity;
        int cur = keys[index];
        if (cur != 0x7FFFFFFE) {
            if (cur == key) {
                return index;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == 0x7FFFFFFE) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return bIndex;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == 0x7FFFFFFE) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return fIndex;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new long[capacity];
    }
}

