/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.CharCollection;
import net.openhft.koloboke.collect.CharCursor;
import net.openhft.koloboke.collect.CharIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractCharValueView;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonFloatCharMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalFloatCharMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVFloatCharQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashSeparateKVFloatCharMapSO;
import net.openhft.koloboke.collect.map.FloatCharCursor;
import net.openhft.koloboke.collect.set.CharSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.CharBinaryOperator;
import net.openhft.koloboke.function.CharConsumer;
import net.openhft.koloboke.function.CharPredicate;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.FloatCharConsumer;
import net.openhft.koloboke.function.FloatCharPredicate;
import net.openhft.koloboke.function.FloatCharToCharFunction;
import net.openhft.koloboke.function.FloatToCharFunction;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.Predicate;

public class UpdatableQHashSeparateKVFloatCharMapGO
extends UpdatableQHashSeparateKVFloatCharMapSO {
    @Override
    final void copy(SeparateKVFloatCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVFloatCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    @Override
    public boolean containsEntry(float key, char value) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public boolean containsEntry(int key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int index = this.index(k);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return null;
    }

    public char get(float key) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Character getOrDefault(Object key, Character defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int index = this.index(k);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return defaultValue;
    }

    public char getOrDefault(float key, char defaultValue) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Float, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            action.accept((Object)Float.valueOf(Float.intBitsToFloat(key)), (Object)Character.valueOf(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(FloatCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(FloatCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public FloatCharCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatCharMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalFloatCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalFloatCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Float, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacity = newKeys.length;
        char[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            int index = QHash.SeparateKVFloatKeyMixing.mix(key) % capacity;
            if (newKeys[index] != 0x7FFFFFFE) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] == 0x7FFFFFFE) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] == 0x7FFFFFFE) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Character put(Float key, Character value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.insert(k, value.charValue());
        if (index < 0) {
            return null;
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value.charValue();
        return Character.valueOf(prevValue);
    }

    @Override
    public char put(float key, char value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Character putIfAbsent(Float key, Character value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.insert(k, value.charValue());
        if (index < 0) {
            return null;
        }
        return Character.valueOf(this.values[index]);
    }

    @Override
    public char putIfAbsent(float key, char value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(float key, char value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public void justPut(int key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Character compute(Float key, BiFunction<? super Float, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int index;
        char[] vals;
        int k;
        block12: {
            k = Float.floatToIntBits(key.floatValue());
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                Character newValue2;
                if (cur != 0x7FFFFFFE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = (Character)remappingFunction.apply((Object)Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2.charValue();
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = (Character)remappingFunction.apply((Object)Float.valueOf(Float.intBitsToFloat(k)), (Object)Character.valueOf(vals[index]))) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public char compute(float key, FloatCharToCharFunction remappingFunction) {
        char newValue;
        int index;
        char[] vals;
        int k;
        block10: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                if (cur != 0x7FFFFFFE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newValue = remappingFunction.applyAsChar(Float.intBitsToFloat(k), this.defaultValue());
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(Float.intBitsToFloat(k), vals[index]);
        return newValue;
    }

    @Override
    public Character computeIfAbsent(Float key, Function<? super Float, ? extends Character> mappingFunction) {
        Character value;
        int k = Float.floatToIntBits(key.floatValue());
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int[] keys = this.set;
        char[] vals = this.values;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
        int cur = keys[index];
        if (cur == k) {
            return Character.valueOf(vals[index]);
        }
        if (cur != 0x7FFFFFFE) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    return Character.valueOf(vals[bIndex]);
                }
                if (cur == 0x7FFFFFFE) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    return Character.valueOf(vals[fIndex]);
                }
                if (cur == 0x7FFFFFFE) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        if ((value = (Character)mappingFunction.apply((Object)Float.valueOf(Float.intBitsToFloat(k)))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value.charValue();
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(float key, FloatToCharFunction mappingFunction) {
        int k = Float.floatToIntBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int[] keys = this.set;
        char[] vals = this.values;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
        int cur = keys[index];
        if (cur == k) {
            return vals[index];
        }
        if (cur != 0x7FFFFFFE) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    return vals[bIndex];
                }
                if (cur == 0x7FFFFFFE) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    return vals[fIndex];
                }
                if (cur == 0x7FFFFFFE) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        char value = mappingFunction.applyAsChar(Float.intBitsToFloat(k));
        this.incrementModCount();
        keys[index] = k;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public Character computeIfPresent(Float key, BiFunction<? super Float, ? super Character, ? extends Character> remappingFunction) {
        int k = Float.floatToIntBits(key.floatValue());
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            Character newValue = (Character)remappingFunction.apply((Object)Float.valueOf(Float.intBitsToFloat(k)), (Object)Character.valueOf(vals[index]));
            if (newValue != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public char computeIfPresent(float key, FloatCharToCharFunction remappingFunction) {
        int k = Float.floatToIntBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            char newValue;
            char[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsChar(Float.intBitsToFloat(k), vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Character merge(Float key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        Character newValue;
        int index;
        char[] vals;
        block12: {
            int k = Float.floatToIntBits(key.floatValue());
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                if (cur != 0x7FFFFFFE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block12;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value.charValue();
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = (Character)remappingFunction.apply((Object)Character.valueOf(vals[index]), (Object)value)) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public char merge(float key, char value, CharBinaryOperator remappingFunction) {
        char newValue;
        int index;
        char[] vals;
        block10: {
            int k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVFloatKeyMixing.mix(k) % capacity;
            int cur = keys[index];
            if (cur != k) {
                if (cur != 0x7FFFFFFE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == k) {
                            index = bIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == k) {
                            index = fIndex;
                            break block10;
                        }
                        if (cur == 0x7FFFFFFE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(vals[index], value);
        return newValue;
    }

    public char addValue(float key, char value) {
        char newValue;
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return value;
        }
        char[] vals = this.values;
        vals[index] = newValue = (char)(vals[index] + value);
        return newValue;
    }

    public char addValue(float key, char addition, char defaultValue) {
        char newValue;
        char value;
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value = (char)(defaultValue + addition));
        if (index < 0) {
            return value;
        }
        char[] vals = this.values;
        vals[index] = newValue = (char)(vals[index] + addition);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Float, ? extends Character> m) {
        CommonFloatCharMapOps.putAll(this, m);
    }

    @Override
    public Character replace(Float key, Character value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value.charValue();
            return Character.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public char replace(float key, char value) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Float key, Character oldValue, Character newValue) {
        return this.replace(key.floatValue(), oldValue.charValue(), newValue.charValue());
    }

    @Override
    public boolean replace(float key, char oldValue, char newValue) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Float, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            vals[i] = ((Character)function.apply((Object)Float.valueOf(Float.intBitsToFloat(key)), (Object)Character.valueOf(vals[i]))).charValue();
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(FloatCharToCharFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            vals[i] = function.applyAsChar(Float.intBitsToFloat(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Character remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public char remove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), ((Character)value).charValue());
    }

    public boolean remove(float key, char value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(FloatCharPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements FloatCharCursor {
        final int[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        int curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(char value) {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        final int[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        int curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public char elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        final int[] keys;
        final char[] vals;
        int expectedModCount;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            this.vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                    int[] keys = this.keys;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFE) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept((Object)Character.valueOf(vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Character>> {
        final int[] keys;
        final char[] vals;
        int expectedModCount;
        int index;
        int curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Character> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Character>> {
        final int[] keys;
        final char[] vals;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            this.vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Character> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                    int[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVFloatCharMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVFloatCharMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashSeparateKVFloatCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return UpdatableQHashSeparateKVFloatCharMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept((Object)Character.valueOf(vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= s.removeChar(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                result[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                a[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return UpdatableQHashSeparateKVFloatCharMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVFloatCharMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(CharPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends FloatCharEntry {
        private int key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends FloatCharEntry {
        final int modCount;
        private final int index;
        final int key;
        private char value;

        MutableEntry(int modCount, int index, int key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            UpdatableQHashSeparateKVFloatCharMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class FloatCharEntry
    extends AbstractEntry<Float, Character> {
        FloatCharEntry() {
        }

        abstract int key();

        @Override
        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract char value();

        @Override
        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Character>>
    implements HashObjSet<Map.Entry<Float, Character>>,
    InternalObjCollectionOps<Map.Entry<Float, Character>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Float, Character>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashSeparateKVFloatCharMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashSeparateKVFloatCharMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashSeparateKVFloatCharMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashSeparateKVFloatCharMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || predicate.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Float, Character>> iterator() {
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Character>> cursor() {
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashSeparateKVFloatCharMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = UpdatableQHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = UpdatableQHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashSeparateKVFloatCharMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                char value = ((Character)e.getValue()).charValue();
                return UpdatableQHashSeparateKVFloatCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Character>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashSeparateKVFloatCharMapGO.this.clear();
        }
    }
}

