/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.LongCollection;
import net.openhft.koloboke.collect.LongCursor;
import net.openhft.koloboke.collect.LongIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractLongValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonLongLongMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalLongLongMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.ParallelKVLongLongQHash;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashParallelKVLongLongMapSO;
import net.openhft.koloboke.collect.map.LongLongCursor;
import net.openhft.koloboke.collect.set.LongSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.LongBinaryOperator;
import net.openhft.koloboke.function.LongConsumer;
import net.openhft.koloboke.function.LongLongConsumer;
import net.openhft.koloboke.function.LongLongPredicate;
import net.openhft.koloboke.function.LongLongToLongFunction;
import net.openhft.koloboke.function.LongPredicate;
import net.openhft.koloboke.function.LongUnaryOperator;
import net.openhft.koloboke.function.Predicate;

public class UpdatableQHashParallelKVLongLongMapGO
extends UpdatableQHashParallelKVLongLongMapSO {
    final void copy(ParallelKVLongLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVLongLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    @Override
    public boolean containsEntry(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1] == value;
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return null;
    }

    public long get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return this.defaultValue();
    }

    @Override
    public Long getOrDefault(Object key, Long defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return defaultValue;
    }

    public long getOrDefault(long key, long defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.table[index + 1];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            action.accept((Object)key, (Object)tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongLongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            action.accept(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongLongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free || predicate.test(key, tab[i + 1])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public LongLongCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongLongMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalLongLongMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free || m.containsEntry(key, tab[i + 1])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalLongLongMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            m.justPut(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Long, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            long val = tab[i + 1];
            hashCode += (int)(key ^ key >>> 32) ^ (int)(val ^ val >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(tab[i + 1]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacity = newTab.length;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            int index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
            if (newTab[index] != free) {
                int bIndex = index;
                int fIndex = index;
                int step = 2;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newTab[bIndex] == free) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newTab[fIndex] == free) {
                        index = fIndex;
                        break;
                    }
                    step += 4;
                }
            }
            newTab[index] = key;
            newTab[index + 1] = tab[i + 1];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Long put(Long key, Long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        long[] tab = this.table;
        long prevValue = tab[index + 1];
        tab[index + 1] = value;
        return prevValue;
    }

    @Override
    public long put(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        long[] tab = this.table;
        long prevValue = tab[index + 1];
        tab[index + 1] = value;
        return prevValue;
    }

    @Override
    public Long putIfAbsent(Long key, Long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.table[index + 1];
    }

    @Override
    public long putIfAbsent(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.table[index + 1];
    }

    @Override
    public void justPut(long key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.table[index + 1] = value;
    }

    @Override
    public Long compute(Long key, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        Long newValue;
        int index;
        long[] tab;
        long k;
        block13: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix(k) % capacity;
            long cur = tab[index];
            if (cur != k) {
                Long newValue2;
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                if ((newValue2 = (Long)remappingFunction.apply((Object)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = k;
                    tab[index + 1] = newValue2;
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = (Long)remappingFunction.apply((Object)k, (Object)tab[index + 1])) != null) {
            tab[index + 1] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public long compute(long key, LongLongToLongFunction remappingFunction) {
        long newValue;
        int index;
        long[] tab;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                long newValue2 = remappingFunction.applyAsLong(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = newValue2;
                this.postInsertHook();
                return newValue2;
            }
        }
        tab[index + 1] = newValue = remappingFunction.applyAsLong(key, tab[index + 1]);
        return newValue;
    }

    @Override
    public Long computeIfAbsent(Long key, Function<? super Long, ? extends Long> mappingFunction) {
        Long value;
        long k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVLongKeyMixing.mix(k) % capacity;
        long cur = tab[index];
        if (cur == k) {
            return tab[index + 1];
        }
        if (cur != free) {
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == k) {
                    return tab[bIndex + 1];
                }
                if (cur == free) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == k) {
                    return tab[fIndex + 1];
                }
                if (cur == free) {
                    index = fIndex;
                    break;
                }
                step += 4;
            }
        }
        if ((value = (Long)mappingFunction.apply((Object)k)) != null) {
            this.incrementModCount();
            tab[index] = k;
            tab[index + 1] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public long computeIfAbsent(long key, LongUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
        long cur = tab[index];
        if (cur == key) {
            return tab[index + 1];
        }
        if (cur != free) {
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == key) {
                    return tab[bIndex + 1];
                }
                if (cur == free) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == key) {
                    return tab[fIndex + 1];
                }
                if (cur == free) {
                    index = fIndex;
                    break;
                }
                step += 4;
            }
        }
        long value = mappingFunction.applyAsLong(key);
        this.incrementModCount();
        tab[index] = key;
        tab[index + 1] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public Long computeIfPresent(Long key, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        long k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] tab = this.table;
            Long newValue = (Long)remappingFunction.apply((Object)k, (Object)tab[index + 1]);
            if (newValue != null) {
                tab[index + 1] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public long computeIfPresent(long key, LongLongToLongFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long newValue;
            long[] tab = this.table;
            tab[index + 1] = newValue = remappingFunction.applyAsLong(key, tab[index + 1]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Long merge(Long key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        Long newValue;
        int index;
        long[] tab;
        block13: {
            long k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix(k) % capacity;
            long cur = tab[index];
            if (cur != k) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                this.incrementModCount();
                tab[index] = k;
                tab[index + 1] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = (Long)remappingFunction.apply((Object)tab[index + 1], (Object)value)) != null) {
            tab[index + 1] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public long merge(long key, long value, LongBinaryOperator remappingFunction) {
        long newValue;
        int index;
        long[] tab;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVLongKeyMixing.mix(key) % capacity;
            long cur = tab[index];
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 2;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = tab[bIndex]) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = tab[fIndex]) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 4;
                    }
                }
                this.incrementModCount();
                tab[index] = key;
                tab[index + 1] = value;
                this.postInsertHook();
                return value;
            }
        }
        tab[index + 1] = newValue = remappingFunction.applyAsLong(tab[index + 1], value);
        return newValue;
    }

    public long addValue(long key, long value) {
        long newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        long[] tab = this.table;
        tab[index + 1] = newValue = tab[index + 1] + value;
        return newValue;
    }

    public long addValue(long key, long addition, long defaultValue) {
        long newValue;
        long value = defaultValue + addition;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        long[] tab = this.table;
        tab[index + 1] = newValue = tab[index + 1] + addition;
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Long, ? extends Long> m) {
        CommonLongLongMapOps.putAll(this, m);
    }

    @Override
    public Long replace(Long key, Long value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            long oldValue = tab[index + 1];
            tab[index + 1] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public long replace(long key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            long oldValue = tab[index + 1];
            tab[index + 1] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Long key, Long oldValue, Long newValue) {
        return this.replace((long)key, (long)oldValue, (long)newValue);
    }

    @Override
    public boolean replace(long key, long oldValue, long newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] tab = this.table;
            if (tab[index + 1] == oldValue) {
                tab[index + 1] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super Long, ? extends Long> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            tab[i + 1] = (Long)function.apply((Object)key, (Object)tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(LongLongToLongFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key == free) continue;
            tab[i + 1] = function.applyAsLong(key, tab[i + 1]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Long remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public long remove(long key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, (Long)value);
    }

    public boolean remove(long key, long value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(LongLongPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements LongLongCursor {
        final long[] tab;
        final long free;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue);
        }

        public void forEachForward(LongLongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key, tab[i + 1]);
            }
            if (index != this.index || mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        final long[] tab;
        final long free;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue);
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(tab[i + 1]);
            }
            if (index != this.index || mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        final long[] tab;
        final long free;
        int expectedModCount;
        int nextIndex;
        long next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            long free = this.free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] == free) continue;
                this.next = tab[nextI + 1];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    long free = this.free;
                    long prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        if (tab[nextI] == free) continue;
                        this.next = tab[nextI + 1];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept((Object)tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(tab[i + 1]);
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Long>> {
        final long[] tab;
        final long free;
        int expectedModCount;
        int index;
        long curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Long> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = tab[i + 1];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Long>> {
        final long[] tab;
        final long free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            long free = this.free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    long free = this.free;
                    MutableEntry prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, tab[nextI + 1]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVLongLongMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVLongLongMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashParallelKVLongLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return UpdatableQHashParallelKVLongLongMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept((Object)tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                action.accept(tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || predicate.test(tab[i + 1])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= c.add(tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                changed |= s.removeLong(tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public LongCursor cursor() {
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                result[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                result[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == free) continue;
                sb.append(' ').append(tab[i + 1]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return UpdatableQHashParallelKVLongLongMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVLongLongMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(LongPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends LongLongEntry {
        private long key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends LongLongEntry {
        final int modCount;
        private final int index;
        final long key;
        private long value;

        MutableEntry(int modCount, int index, long key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Long setValue(Long newValue) {
            long unwrappedNewValue;
            if (this.modCount != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            long oldValue = this.value;
            this.value = unwrappedNewValue = newValue.longValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            UpdatableQHashParallelKVLongLongMapGO.this.table[this.index + 1] = newValue;
        }
    }

    abstract class LongLongEntry
    extends AbstractEntry<Long, Long> {
        LongLongEntry() {
        }

        abstract long key();

        @Override
        public final Long getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Long getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                long v2 = (Long)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Long>>
    implements HashObjSet<Map.Entry<Long, Long>>,
    InternalObjCollectionOps<Map.Entry<Long, Long>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Long, Long>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashParallelKVLongLongMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVLongLongMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashParallelKVLongLongMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashParallelKVLongLongMapGO.this.containsEntry((Long)e.getKey(), (Long)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, tab[i + 1]);
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || predicate.test((Object)new MutableEntry(mc, i, key, tab[i + 1]))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Long, Long>> iterator() {
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Long>> cursor() {
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, tab[i + 1]));
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashParallelKVLongLongMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVLongLongMapGO.this.modCount();
            long free = UpdatableQHashParallelKVLongLongMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVLongLongMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(tab[i + 1]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVLongLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVLongLongMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                long value = (Long)e.getValue();
                return UpdatableQHashParallelKVLongLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Long>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVLongLongMapGO.this.clear();
        }
    }
}

