/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.FloatCollection;
import net.openhft.koloboke.collect.FloatCursor;
import net.openhft.koloboke.collect.FloatIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractFloatValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonIntFloatMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalFloatCollectionOps;
import net.openhft.koloboke.collect.impl.InternalIntFloatMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.ParallelKVIntFloatQHash;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashParallelKVIntFloatMapSO;
import net.openhft.koloboke.collect.map.IntFloatCursor;
import net.openhft.koloboke.collect.set.FloatSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.FloatBinaryOperator;
import net.openhft.koloboke.function.FloatConsumer;
import net.openhft.koloboke.function.FloatPredicate;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.IntFloatConsumer;
import net.openhft.koloboke.function.IntFloatPredicate;
import net.openhft.koloboke.function.IntFloatToFloatFunction;
import net.openhft.koloboke.function.IntToFloatFunction;
import net.openhft.koloboke.function.Predicate;

public class UpdatableQHashParallelKVIntFloatMapGO
extends UpdatableQHashParallelKVIntFloatMapSO {
    final void copy(ParallelKVIntFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVIntFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    @Override
    public boolean containsEntry(int key, float value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32) == Float.floatToIntBits(value);
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return (int)(entry >>> 32) == Float.floatToIntBits(value);
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return (int)(entry >>> 32) == Float.floatToIntBits(value);
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    @Override
    public boolean containsEntry(int key, int value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return (int)(entry >>> 32) == value;
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return (int)(entry >>> 32) == value;
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == free) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur == free) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur == free) {
                    return null;
                }
                step += 2;
            }
        }
        return null;
    }

    public float get(int key) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == free) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        return this.defaultValue();
    }

    @Override
    public Float getOrDefault(Object key, Float defaultValue) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public float getOrDefault(int key, float defaultValue) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            action.accept((Object)key, (Object)Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            action.accept(key, Float.intBitsToFloat((int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free || predicate.test(key, Float.intBitsToFloat((int)(entry >>> 32)))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public IntFloatCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntFloatMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalIntFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalIntFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Integer, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacity = newTab.length;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3)) != free) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)bIndex << 3)) == free) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)fIndex << 3)) == free) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Float put(Integer key, Float value) {
        int free;
        int k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                    this.postInsertHook();
                    return null;
                }
                if (cur == k) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                    this.postInsertHook();
                    return null;
                }
                if (cur == k) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        float prevValue = Float.intBitsToFloat((int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value.floatValue()));
        return Float.valueOf(prevValue);
    }

    @Override
    public float put(int key, float value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                    this.postInsertHook();
                    return this.defaultValue();
                }
                if (cur == key) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                    this.postInsertHook();
                    return this.defaultValue();
                }
                if (cur == key) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        float prevValue = Float.intBitsToFloat((int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value));
        return prevValue;
    }

    @Override
    public Float putIfAbsent(Integer key, Float value) {
        int free;
        int k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == free) {
                this.incrementModCount();
                tab[bIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postInsertHook();
                return null;
            }
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == free) {
                this.incrementModCount();
                tab[fIndex] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postInsertHook();
                return null;
            }
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            step += 2;
        }
    }

    @Override
    public float putIfAbsent(int key, float value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return Float.intBitsToFloat((int)(entry >>> 32));
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (int)(entry = tab[bIndex])) == free) {
                this.incrementModCount();
                tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            int t = (fIndex += step) - capacity;
            if (t >= 0) {
                fIndex = t;
            }
            if ((cur = (int)(entry = tab[fIndex])) == free) {
                this.incrementModCount();
                tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return Float.intBitsToFloat((int)(entry >>> 32));
            }
            step += 2;
        }
    }

    @Override
    public void justPut(int key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value));
    }

    @Override
    public void justPut(int key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), value);
    }

    @Override
    public Float compute(Integer key, BiFunction<? super Integer, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        long entry;
        int index;
        long[] tab;
        int k;
        block13: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                Float newValue2;
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                if ((newValue2 = (Float)remappingFunction.apply((Object)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue2.floatValue()) << 32;
                    this.postInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = (Float)remappingFunction.apply((Object)k, (Object)Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) != null) {
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue.floatValue()));
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    public float compute(int key, IntFloatToFloatFunction remappingFunction) {
        long entry;
        int index;
        long[] tab;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                float newValue = remappingFunction.applyAsFloat(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(newValue) << 32;
                this.postInsertHook();
                return newValue;
            }
        }
        float newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat((int)(entry >>> 32)));
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    @Override
    public Float computeIfAbsent(Integer key, Function<? super Integer, ? extends Float> mappingFunction) {
        Float value;
        int k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
        }
        if (cur != free) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur == free) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == k) {
                    return Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
                }
                if (cur == free) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        if ((value = (Float)mappingFunction.apply((Object)k)) != null) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public float computeIfAbsent(int key, IntToFloatFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return Float.intBitsToFloat((int)(entry >>> 32));
        }
        if (cur != free) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur == free) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == key) {
                    return Float.intBitsToFloat((int)(entry >>> 32));
                }
                if (cur == free) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        float value = mappingFunction.applyAsFloat(key);
        this.incrementModCount();
        tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
        this.postInsertHook();
        return value;
    }

    @Override
    public Float computeIfPresent(Integer key, BiFunction<? super Integer, ? super Float, ? extends Float> remappingFunction) {
        int k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (k != free) {
            Float newValue;
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            if ((newValue = (Float)remappingFunction.apply((Object)k, (Object)Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))) != null) {
                U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue.floatValue()));
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public float computeIfPresent(int key, IntFloatToFloatFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            float newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat((int)(entry >>> 32)));
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Float merge(Integer key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        long entry;
        int index;
        long[] tab;
        block13: {
            int k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == k) {
                            index = bIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == k) {
                            index = fIndex;
                            break block13;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)Float.floatToIntBits(value.floatValue()) << 32;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = (Float)remappingFunction.apply((Object)Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))), (Object)value)) != null) {
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue.floatValue()));
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    public float merge(int key, float value, FloatBinaryOperator remappingFunction) {
        long entry;
        int index;
        long[] tab;
        block11: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            int free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = (int)(entry = tab[bIndex])) == key) {
                            index = bIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if ((cur = (int)(entry = tab[fIndex])) == key) {
                            index = fIndex;
                            break block11;
                        }
                        if (cur == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                this.postInsertHook();
                return value;
            }
        }
        float newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat((int)(entry >>> 32)), value);
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    public float addValue(int key, float value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        float newValue = Float.intBitsToFloat((int)(entry >>> 32)) + value;
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    public float addValue(int key, float addition, float defaultValue) {
        float value = defaultValue + addition;
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
            this.postInsertHook();
            return value;
        }
        if (cur != key) {
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (int)(entry = tab[bIndex])) == free) {
                    this.incrementModCount();
                    tab[bIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = bIndex;
                    break;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (int)(entry = tab[fIndex])) == free) {
                    this.incrementModCount();
                    tab[fIndex] = (long)key & 0xFFFFFFFFL | (long)Float.floatToIntBits(value) << 32;
                    this.postInsertHook();
                    return value;
                }
                if (cur == key) {
                    index = fIndex;
                    break;
                }
                step += 2;
            }
        }
        float newValue = Float.intBitsToFloat((int)(entry >>> 32)) + addition;
        U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Integer, ? extends Float> m) {
        CommonIntFloatMapOps.putAll(this, m);
    }

    @Override
    public Float replace(Integer key, Float value) {
        int free;
        int k = key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(k) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            float oldValue = Float.intBitsToFloat((int)(entry >>> 32));
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value.floatValue()));
            return Float.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public float replace(int key, float value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            float oldValue = Float.intBitsToFloat((int)(entry >>> 32));
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(value));
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Integer key, Float oldValue, Float newValue) {
        return this.replace((int)key, oldValue.floatValue(), newValue.floatValue());
    }

    @Override
    public boolean replace(int key, float oldValue, float newValue) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVIntKeyMixing.mix(key) % capacity;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (int)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (int)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((int)(entry >>> 32) == Float.floatToIntBits(oldValue)) {
                U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)index << 3), Float.floatToIntBits(newValue));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super Float, ? extends Float> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)i << 3), Float.floatToIntBits(((Float)function.apply((Object)key, (Object)Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))))).floatValue()));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(IntFloatToFloatFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            U.putInt(tab, LONG_BASE + FLOAT_VALUE_OFFSET + ((long)i << 3), Float.floatToIntBits(function.applyAsFloat(key, Float.intBitsToFloat((int)(entry >>> 32)))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Float remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public float remove(int key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, ((Float)value).floatValue());
    }

    public boolean remove(int key, float value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(IntFloatPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements IntFloatCursor {
        final long[] tab;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue);
        }

        public void forEachForward(IntFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key, Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_VALUE_OFFSET + ((long)this.index << 3), Float.floatToIntBits(value));
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final long[] tab;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue);
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public float elem() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final long[] tab;
        final int free;
        int expectedModCount;
        int nextIndex;
        float next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            int free = this.free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry == free) continue;
                this.next = Float.intBitsToFloat((int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    int free = this.free;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        if ((int)entry == free) continue;
                        this.next = Float.intBitsToFloat((int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((Object)Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Float>> {
        final long[] tab;
        final int free;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (index != this.index || mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Float> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Float>> {
        final long[] tab;
        final int free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            int free = this.free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                    long[] tab = this.tab;
                    int free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVIntFloatMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVIntFloatMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return UpdatableQHashParallelKVIntFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return UpdatableQHashParallelKVIntFloatMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(int bits) {
            return UpdatableQHashParallelKVIntFloatMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((Object)Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32))));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || predicate.test(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || c.contains(Float.intBitsToFloat((int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= c.add(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= s.removeFloat(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= s.removeFloat((int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public FloatCursor cursor() {
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat((int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                result[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                a[resultIndex++] = Float.intBitsToFloat((int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                sb.append(' ').append(Float.intBitsToFloat((int)(entry >>> 32))).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return UpdatableQHashParallelKVIntFloatMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeFloat(int bits) {
            return UpdatableQHashParallelKVIntFloatMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVIntFloatMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(FloatPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends IntFloatEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends IntFloatEntry {
        final int modCount;
        private final int index;
        final int key;
        private int value;

        MutableEntry(int modCount, int index, int key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public Float setValue(Float newValue) {
            int unwrappedNewValue;
            if (this.modCount != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            float oldValue = Float.intBitsToFloat(this.value);
            this.value = unwrappedNewValue = Float.floatToIntBits(newValue.floatValue());
            this.updateValueInTable(unwrappedNewValue);
            return Float.valueOf(oldValue);
        }

        void updateValueInTable(int newValue) {
            UnsafeConstants.U.putFloat(UpdatableQHashParallelKVIntFloatMapGO.this.table, UnsafeConstants.LONG_BASE + UnsafeConstants.FLOAT_VALUE_OFFSET + ((long)this.index << 3), newValue);
        }
    }

    abstract class IntFloatEntry
    extends AbstractEntry<Integer, Float> {
        IntFloatEntry() {
        }

        abstract int key();

        @Override
        public final Integer getKey() {
            return this.key();
        }

        abstract int value();

        @Override
        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Float>>
    implements HashObjSet<Map.Entry<Integer, Float>>,
    InternalObjCollectionOps<Map.Entry<Integer, Float>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Integer, Float>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableQHashParallelKVIntFloatMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return UpdatableQHashParallelKVIntFloatMapGO.this.size();
        }

        public double currentLoad() {
            return UpdatableQHashParallelKVIntFloatMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableQHashParallelKVIntFloatMapGO.this.containsEntry((int)((Integer)e.getKey()), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || predicate.test((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Integer, Float>> iterator() {
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Float>> cursor() {
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return UpdatableQHashParallelKVIntFloatMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableQHashParallelKVIntFloatMapGO.this.modCount();
            int free = UpdatableQHashParallelKVIntFloatMapGO.this.freeValue;
            long[] tab = UpdatableQHashParallelKVIntFloatMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Float.intBitsToFloat((int)(entry >>> 32)));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableQHashParallelKVIntFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableQHashParallelKVIntFloatMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                float value = ((Float)e.getValue()).floatValue();
                return UpdatableQHashParallelKVIntFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Float>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            UpdatableQHashParallelKVIntFloatMapGO.this.clear();
        }
    }
}

