/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.DoubleCollection;
import net.openhft.koloboke.collect.DoubleCursor;
import net.openhft.koloboke.collect.DoubleIterator;
import net.openhft.koloboke.collect.impl.InternalDoubleCollectionOps;
import net.openhft.koloboke.collect.impl.hash.UpdatableParallelKVDoubleLHashSO;
import net.openhft.koloboke.collect.set.DoubleSet;
import net.openhft.koloboke.collect.set.hash.HashDoubleSet;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.DoubleConsumer;
import net.openhft.koloboke.function.DoublePredicate;
import net.openhft.koloboke.function.Predicate;

public abstract class UpdatableParallelKVDoubleLHashGO
extends UpdatableParallelKVDoubleLHashSO {
    @Override
    @Nonnull
    public long[] table() {
        return this.table;
    }

    @Override
    boolean doubleSizedArrays() {
        return true;
    }

    @Override
    public int capacity() {
        return this.table.length >> 1;
    }

    public void forEach(Consumer<? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Object)Double.longBitsToDouble(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(DoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(DoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(DoubleCollection c) {
        if (c instanceof InternalDoubleCollectionOps) {
            return this.allContainingIn((InternalDoubleCollectionOps)c);
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(Double.longBitsToDouble(key))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    boolean allContainingIn(InternalDoubleCollectionOps c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(DoubleCollection c) {
        if (c instanceof InternalDoubleCollectionOps) {
            return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            changed |= c.add(Double.longBitsToDouble(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(DoubleSet s) {
        if (s instanceof InternalDoubleCollectionOps) {
            return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
        }
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            changed |= s.removeDouble(Double.longBitsToDouble(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            changed |= s.removeDouble(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public DoubleIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedIterator(mc);
    }

    public DoubleCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            result[resultIndex++] = Double.longBitsToDouble(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            a[resultIndex++] = Double.longBitsToDouble(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public double[] toDoubleArray() {
        int size = this.size();
        double[] result = new double[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            result[resultIndex++] = Double.longBitsToDouble(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public double[] toArray(double[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new double[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0.0;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            a[resultIndex++] = Double.longBitsToDouble(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0.0;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            hashCode += (int)(key ^ key >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            long key = tab[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ').append(Double.longBitsToDouble(key)).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(long var1);

    public boolean removeIf(Predicate<? super Double> filter) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(DoublePredicate filter) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull DoubleCollection c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull InternalDoubleCollectionOps c) {
        throw new UnsupportedOperationException();
    }

    boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof DoubleCollection) {
            return this.retainAll(thisC, (DoubleCollection)c);
        }
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull DoubleCollection c) {
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull InternalDoubleCollectionOps c) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedCursor
    implements DoubleCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        long curKey;

        NoRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableParallelKVDoubleLHashGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key));
            }
            if (index != this.index || mc != UpdatableParallelKVDoubleLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableParallelKVDoubleLHashGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedIterator
    implements DoubleIterator {
        final long[] tab;
        int expectedModCount;
        int nextIndex;
        double next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableParallelKVDoubleLHashGO.this.table;
            long[] tab = UpdatableParallelKVDoubleLHashGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = Double.longBitsToDouble(key);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == UpdatableParallelKVDoubleLHashGO.this.modCount()) {
                    long[] tab = this.tab;
                    double prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = Double.longBitsToDouble(key);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)Double.longBitsToDouble(key));
            }
            if (nextI != this.nextIndex || mc != UpdatableParallelKVDoubleLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key));
            }
            if (nextI != this.nextIndex || mc != UpdatableParallelKVDoubleLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

