/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.FloatCollection;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.hash.FloatQHashFactory;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashFloatSet;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashFloatSetGO;
import net.openhft.koloboke.collect.impl.hash.MutableQHashFloatSet;
import net.openhft.koloboke.collect.impl.hash.MutableQHashFloatSetGO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVFloatQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashFloatSet;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashFloatSetGO;
import net.openhft.koloboke.collect.set.hash.HashFloatSetFactory;

public abstract class QHashFloatSetFactorySO
extends FloatQHashFactory
implements HashFloatSetFactory {
    QHashFloatSetFactorySO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    MutableQHashFloatSetGO uninitializedMutableSet() {
        return new MutableQHashFloatSet();
    }

    UpdatableQHashFloatSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashFloatSet();
    }

    ImmutableQHashFloatSetGO uninitializedImmutableSet() {
        return new ImmutableQHashFloatSet();
    }

    @Nonnull
    public MutableQHashFloatSetGO newMutableSet(int expectedSize) {
        MutableQHashFloatSet set = new MutableQHashFloatSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    @Nonnull
    public UpdatableQHashFloatSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashFloatSet set = new UpdatableQHashFloatSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    @Nonnull
    public UpdatableQHashFloatSetGO newUpdatableSet(Iterable<Float> elements, int expectedSize) {
        if (elements instanceof FloatCollection) {
            SeparateKVFloatQHash hash;
            if (elements instanceof SeparateKVFloatQHash && (hash = (SeparateKVFloatQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashFloatSet set = new UpdatableQHashFloatSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashFloatSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashFloatSetGO set = this.newUpdatableSet(size);
        for (float e : elements) {
            set.add(e);
        }
        return set;
    }
}

