/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.hash.HashContainerFactory;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashDoubleSetGO;
import net.openhft.koloboke.collect.impl.hash.LHashCapacities;
import net.openhft.koloboke.collect.impl.hash.MutableQHashDoubleSetGO;
import net.openhft.koloboke.collect.impl.hash.QHashDoubleSetFactorySO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVDoubleQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashDoubleSetGO;
import net.openhft.koloboke.collect.set.hash.HashDoubleSet;
import net.openhft.koloboke.collect.set.hash.HashDoubleSetFactory;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.DoubleConsumer;
import net.openhft.koloboke.function.Predicate;

public abstract class QHashDoubleSetFactoryGO
extends QHashDoubleSetFactorySO {
    public QHashDoubleSetFactoryGO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    abstract HashDoubleSetFactory thisWith(HashConfig var1, int var2);

    abstract HashDoubleSetFactory lHashLikeThisWith(HashConfig var1, int var2);

    abstract HashDoubleSetFactory qHashLikeThisWith(HashConfig var1, int var2);

    public final HashDoubleSetFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash(hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize());
    }

    public final HashDoubleSetFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize);
    }

    public String toString() {
        return "HashDoubleSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashDoubleSetFactory) {
            HashDoubleSetFactory factory = (HashDoubleSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals(factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private UpdatableQHashDoubleSetGO shrunk(UpdatableQHashDoubleSetGO set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test((Object)set)) {
            set.shrink();
        }
        return set;
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    @Nonnull
    public MutableQHashDoubleSetGO newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elements) {
        return this.newUpdatableSet((Iterable)elements, QHashDoubleSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2) {
        long expectedSize = QHashDoubleSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt(expectedSize += (long)QHashDoubleSetFactoryGO.sizeOr(elems2, 0)));
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3) {
        long expectedSize = QHashDoubleSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashDoubleSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt(expectedSize += (long)QHashDoubleSetFactoryGO.sizeOr(elems3, 0)));
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4) {
        long expectedSize = QHashDoubleSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashDoubleSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashDoubleSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt(expectedSize += (long)QHashDoubleSetFactoryGO.sizeOr(elems4, 0)));
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5) {
        long expectedSize = QHashDoubleSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashDoubleSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashDoubleSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)QHashDoubleSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt(expectedSize += (long)QHashDoubleSetFactoryGO.sizeOr(elems5, 0)));
    }

    @Override
    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elements, int expectedSize) {
        return this.shrunk((UpdatableQHashDoubleSetGO)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static void addAll(UpdatableQHashDoubleSetGO set, Iterable<? extends Double> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            Iterator<? extends Double> iterator = elems.iterator();
            while (iterator.hasNext()) {
                double e = iterator.next();
                set.add(e);
            }
        }
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, int expectedSize) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        QHashDoubleSetFactoryGO.addAll(set, elems1);
        QHashDoubleSetFactoryGO.addAll(set, elems2);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        QHashDoubleSetFactoryGO.addAll(set, elems1);
        QHashDoubleSetFactoryGO.addAll(set, elems2);
        QHashDoubleSetFactoryGO.addAll(set, elems3);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, int expectedSize) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        QHashDoubleSetFactoryGO.addAll(set, elems1);
        QHashDoubleSetFactoryGO.addAll(set, elems2);
        QHashDoubleSetFactoryGO.addAll(set, elems3);
        QHashDoubleSetFactoryGO.addAll(set, elems4);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        QHashDoubleSetFactoryGO.addAll(set, elems1);
        QHashDoubleSetFactoryGO.addAll(set, elems2);
        QHashDoubleSetFactoryGO.addAll(set, elems3);
        QHashDoubleSetFactoryGO.addAll(set, elems4);
        QHashDoubleSetFactoryGO.addAll(set, elems5);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterator<Double> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Iterator<Double> elements, int expectedSize) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Consumer<DoubleConsumer> elementsSupplier) {
        return this.newUpdatableSet((Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Consumer<DoubleConsumer> elementsSupplier, int expectedSize) {
        final UpdatableQHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept((Object)new DoubleConsumer(){

            public void accept(double e) {
                set.add(e);
            }
        });
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(double[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(double[] elements, int expectedSize) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        for (double e : elements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Double[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSet(Double[] elements, int expectedSize) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(expectedSize);
        Double[] doubleArray = elements;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double e = doubleArray[i];
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSetOf(double e1) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSetOf(double e1, double e2) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSetOf(double e1, double e2, double e3) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSetOf(double e1, double e2, double e3, double e4) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    @Nonnull
    public UpdatableQHashDoubleSetGO newUpdatableSetOf(double e1, double e2, double e3, double e4, double e5, double ... restElements) {
        UpdatableQHashDoubleSetGO set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (double e : restElements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterable<Double> elements, int expectedSize) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, int expectedSize) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, int expectedSize) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterable<Double> elements) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterator<Double> elements) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Iterator<Double> elements, int expectedSize) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Consumer<DoubleConsumer> elementsSupplier) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Consumer<DoubleConsumer> elementsSupplier, int expectedSize) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(double[] elements) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(double[] elements, int expectedSize) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Double[] elements) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSet(Double[] elements, int expectedSize) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSetOf(double e1) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSetOf(double e1, double e2) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSetOf(double e1, double e2, double e3) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSetOf(double e1, double e2, double e3, double e4) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashDoubleSet newMutableSetOf(double e1, double e2, double e3, double e4, double e5, double ... restElements) {
        MutableQHashDoubleSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterable<Double> elements, int expectedSize) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, int expectedSize) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, int expectedSize) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, int expectedSize) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5, int expectedSize) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterable<Double> elements) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterable<Double> elems1, Iterable<Double> elems2, Iterable<Double> elems3, Iterable<Double> elems4, Iterable<Double> elems5) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterator<Double> elements) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Iterator<Double> elements, int expectedSize) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Consumer<DoubleConsumer> elementsSupplier) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Consumer<DoubleConsumer> elementsSupplier, int expectedSize) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVDoubleQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(double[] elements) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(double[] elements, int expectedSize) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Double[] elements) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSet(Double[] elements, int expectedSize) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSetOf(double e1) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSetOf(double e1, double e2) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSetOf(double e1, double e2, double e3) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSetOf(double e1, double e2, double e3, double e4) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashDoubleSet newImmutableSetOf(double e1, double e2, double e3, double e4, double e5, double ... restElements) {
        ImmutableQHashDoubleSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }
}

