/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.CharCollection;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.hash.CharacterQHashFactory;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashCharSet;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashCharSetGO;
import net.openhft.koloboke.collect.impl.hash.MutableQHashCharSet;
import net.openhft.koloboke.collect.impl.hash.MutableQHashCharSetGO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVCharQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashCharSet;
import net.openhft.koloboke.collect.impl.hash.UpdatableQHashCharSetGO;
import net.openhft.koloboke.collect.set.hash.HashCharSetFactory;

public abstract class QHashCharSetFactorySO
extends CharacterQHashFactory<MutableQHashCharSetGO>
implements HashCharSetFactory {
    QHashCharSetFactorySO(HashConfig hashConf, int defaultExpectedSize, char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    MutableQHashCharSetGO createNewMutable(int expectedSize, char free, char removed) {
        MutableQHashCharSet set = new MutableQHashCharSet();
        set.init(this.configWrapper, expectedSize, free, removed);
        return set;
    }

    MutableQHashCharSetGO uninitializedMutableSet() {
        return new MutableQHashCharSet();
    }

    UpdatableQHashCharSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashCharSet();
    }

    ImmutableQHashCharSetGO uninitializedImmutableSet() {
        return new ImmutableQHashCharSet();
    }

    @Nonnull
    public MutableQHashCharSetGO newMutableSet(int expectedSize) {
        return (MutableQHashCharSetGO)this.newMutableHash(expectedSize);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashCharSet set = new UpdatableQHashCharSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elements, int expectedSize) {
        if (elements instanceof CharCollection) {
            SeparateKVCharQHash hash;
            if (elements instanceof SeparateKVCharQHash && (hash = (SeparateKVCharQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashCharSet set = new UpdatableQHashCharSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashCharSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashCharSetGO set = this.newUpdatableSet(size);
        for (char e : elements) {
            set.add(e);
        }
        return set;
    }
}

