/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.LongCollection;
import net.openhft.koloboke.collect.LongCursor;
import net.openhft.koloboke.collect.LongIterator;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableSeparateKVLongLHashSO;
import net.openhft.koloboke.collect.set.LongSet;
import net.openhft.koloboke.collect.set.hash.HashLongSet;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.LongConsumer;
import net.openhft.koloboke.function.LongPredicate;
import net.openhft.koloboke.function.Predicate;

public abstract class MutableSeparateKVLongLHashGO
extends MutableSeparateKVLongLHashSO {
    @Override
    @Nonnull
    public long[] keys() {
        return this.set;
    }

    @Override
    public int capacity() {
        return this.set.length;
    }

    public void forEach(Consumer<? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept((Object)key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(LongCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(LongCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(LongSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            changed |= s.removeLong(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public LongIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedIterator(mc);
    }

    public LongCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public long[] toLongArray() {
        int size = this.size();
        long[] result = new long[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public long[] toArray(long[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new long[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0L;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0L;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            hashCode += (int)(key ^ key >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(long var1);

    public boolean removeIf(Predicate<? super Long> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key == free || !filter.test((Object)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(LongPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.retainAll(thisC, (LongCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                long key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                long key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    void closeDelayedRemoved(int firstDelayedRemoved, long delayedRemoved) {
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            long keyToShift;
            int indexToRemove;
            if (keys[i] != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if (keyToShift != delayedRemoved && (LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements LongCursor {
        long[] keys;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;

        NoRemovedCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.keys = MutableSeparateKVLongLHashGO.this.set;
            long[] keys = MutableSeparateKVLongLHashGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.curKey = free = (this.free = MutableSeparateKVLongLHashGO.this.freeValue);
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableSeparateKVLongLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableSeparateKVLongLHashGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableSeparateKVLongLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] keys = this.keys;
            if (keys == MutableSeparateKVLongLHashGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableSeparateKVLongLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableSeparateKVLongLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableSeparateKVLongLHashGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedIterator
    implements LongIterator {
        long[] keys;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        long next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableSeparateKVLongLHashGO.this.set;
            long[] keys = MutableSeparateKVLongLHashGO.this.set;
            this.capacityMask = keys.length - 1;
            long free = this.free = MutableSeparateKVLongLHashGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableSeparateKVLongLHashGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    long prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Object)key);
            }
            if (nextI != this.nextIndex || mc != MutableSeparateKVLongLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableSeparateKVLongLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableSeparateKVLongLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] keys = this.keys;
            if (keys == MutableSeparateKVLongLHashGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableSeparateKVLongLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableSeparateKVLongLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableSeparateKVLongLHashGO.this.justRemove(keys[index]);
            }
        }
    }
}

