/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.CharCollection;
import net.openhft.koloboke.collect.CharCursor;
import net.openhft.koloboke.collect.CharIterator;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableSeparateKVCharLHashSO;
import net.openhft.koloboke.collect.set.CharSet;
import net.openhft.koloboke.collect.set.hash.HashCharSet;
import net.openhft.koloboke.function.CharConsumer;
import net.openhft.koloboke.function.CharPredicate;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.Predicate;

public abstract class MutableSeparateKVCharLHashGO
extends MutableSeparateKVCharLHashSO {
    @Override
    @Nonnull
    public char[] keys() {
        return this.set;
    }

    @Override
    public int capacity() {
        return this.set.length;
    }

    public void forEach(Consumer<? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept((Object)Character.valueOf(key));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            action.accept(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(CharCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(CharCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(CharSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            changed |= s.removeChar(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public CharIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedIterator(mc);
    }

    public CharCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            result[resultIndex++] = Character.valueOf(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            a[resultIndex++] = Character.valueOf(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public char[] toCharArray() {
        int size = this.size();
        char[] result = new char[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public char[] toArray(char[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new char[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = '\u0000';
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = '\u0000';
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            hashCode += key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            char key = keys[i];
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(char var1);

    public boolean removeIf(Predicate<? super Character> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                char key = keys[i];
                if (key == free || !filter.test((Object)Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(CharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                char key = keys[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                char key = keys[i];
                if (key == free || !c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                char key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.retainAll(thisC, (CharCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                char key = keys[i];
                if (key == free || c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char delayedRemoved = '\u0000';
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                char key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    char keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    void closeDelayedRemoved(int firstDelayedRemoved, char delayedRemoved) {
        char free = this.freeValue;
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            char keyToShift;
            int indexToRemove;
            if (keys[i] != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if (keyToShift != delayedRemoved && (LHash.SeparateKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements CharCursor {
        char[] keys;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index;
        char curKey;

        NoRemovedCursor(int mc) {
            char free;
            this.expectedModCount = mc;
            this.keys = MutableSeparateKVCharLHashGO.this.set;
            char[] keys = MutableSeparateKVCharLHashGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.curKey = free = (this.free = MutableSeparateKVCharLHashGO.this.freeValue);
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableSeparateKVCharLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableSeparateKVCharLHashGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            char curKey = this.curKey;
            char free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableSeparateKVCharLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            char[] keys = this.keys;
            if (keys == MutableSeparateKVCharLHashGO.this.set) {
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableSeparateKVCharLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableSeparateKVCharLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableSeparateKVCharLHashGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedIterator
    implements CharIterator {
        char[] keys;
        final char free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableSeparateKVCharLHashGO.this.set;
            char[] keys = MutableSeparateKVCharLHashGO.this.set;
            this.capacityMask = keys.length - 1;
            char free = this.free = MutableSeparateKVCharLHashGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                char key = keys[nextI];
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableSeparateKVCharLHashGO.this.modCount()) {
                    this.index = nextI;
                    char[] keys = this.keys;
                    char free = this.free;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        char key = keys[nextI];
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Object)Character.valueOf(key));
            }
            if (nextI != this.nextIndex || mc != MutableSeparateKVCharLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableSeparateKVCharLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableSeparateKVCharLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            char[] keys = this.keys;
            if (keys == MutableSeparateKVCharLHashGO.this.set) {
                char keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableSeparateKVCharLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableSeparateKVCharLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableSeparateKVCharLHashGO.this.justRemove(keys[index]);
            }
        }
    }
}

