/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.LongCollection;
import net.openhft.koloboke.collect.LongCursor;
import net.openhft.koloboke.collect.LongIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractLongValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.CommonObjLongMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalObjLongMapOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.MutableQHashSeparateKVObjLongMapSO;
import net.openhft.koloboke.collect.impl.hash.ObjHash;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVObjLongQHash;
import net.openhft.koloboke.collect.map.ObjLongCursor;
import net.openhft.koloboke.collect.set.LongSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.LongBinaryOperator;
import net.openhft.koloboke.function.LongConsumer;
import net.openhft.koloboke.function.LongPredicate;
import net.openhft.koloboke.function.ObjLongConsumer;
import net.openhft.koloboke.function.ObjLongPredicate;
import net.openhft.koloboke.function.ObjLongToLongFunction;
import net.openhft.koloboke.function.Predicate;
import net.openhft.koloboke.function.ToLongFunction;

public class MutableQHashSeparateKVObjLongMapGO<K>
extends MutableQHashSeparateKVObjLongMapSO<K> {
    @Override
    final void copy(SeparateKVObjLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    @Override
    public boolean containsEntry(Object key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public long getLong(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Long getOrDefault(Object key, Long defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public long getOrDefault(Object key, long defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                action.accept(key, (Object)vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                action.accept(key, (Object)vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void forEach(ObjLongConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean forEachWhile(ObjLongPredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjLongCursor<K> cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjLongMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalObjLongMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalObjLongMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<K, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                long val = vals[i];
                hashCode += this.nullableKeyHashCode(key) ^ (int)(val ^ val >>> 32);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                long val = vals[i];
                hashCode += this.nullableKeyHashCode(key) ^ (int)(val ^ val >>> 32);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Map)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Map)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newKeys = this.set;
        int capacity = newKeys.length;
        long[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                int index = QHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) % capacity;
                if (newKeys[index] != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                int index = QHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) % capacity;
                if (newKeys[index] != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Long put(K key, Long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        long[] vals = this.values;
        long prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public long put(K key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        long[] vals = this.values;
        long prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Long putIfAbsent(K key, Long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public long putIfAbsent(K key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(K key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Long compute(K key, BiFunction<? super K, ? super Long, ? extends Long> remappingFunction) {
        block31: {
            Long newValue;
            int index;
            long[] vals;
            block29: {
                Long newValue2;
                block30: {
                    Long newValue3;
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block33: {
                        block32: {
                            if (key == null) break block31;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block29;
                            if (cur == FREE) break block30;
                            if (cur == REMOVED) break block32;
                            if (this.keyEquals(key, cur)) break block29;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block33;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    if ((newValue3 = (Long)remappingFunction.apply(key, null)) != null) {
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue3;
                        this.postRemovedSlotInsertHook();
                        return newValue3;
                    }
                    return null;
                }
                if ((newValue2 = (Long)remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
            if ((newValue = (Long)remappingFunction.apply(key, (Object)vals[index])) != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return this.computeNullKey(remappingFunction);
    }

    Long computeNullKey(BiFunction<? super K, ? super Long, ? extends Long> remappingFunction) {
        Long newValue;
        int index;
        long[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                Long newValue2;
                block26: {
                    if (cur != FREE) {
                        Long newValue3;
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = (Long)remappingFunction.apply(null, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = null;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = (Long)remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    keys[index] = null;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = (Long)remappingFunction.apply(null, (Object)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return null;
    }

    public long compute(K key, ObjLongToLongFunction<? super K> remappingFunction) {
        block28: {
            long newValue;
            int index;
            long[] vals;
            block26: {
                block27: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block30: {
                        block29: {
                            if (key == null) break block28;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block26;
                            if (cur == FREE) break block27;
                            if (cur == REMOVED) break block29;
                            if (this.keyEquals(key, cur)) break block26;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block30;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    long newValue2 = remappingFunction.applyAsLong(key, this.defaultValue());
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = newValue2;
                    this.postRemovedSlotInsertHook();
                    return newValue2;
                }
                long newValue3 = remappingFunction.applyAsLong(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue3;
                this.postFreeSlotInsertHook();
                return newValue3;
            }
            vals[index] = newValue = remappingFunction.applyAsLong(key, vals[index]);
            return newValue;
        }
        return this.computeNullKey(remappingFunction);
    }

    long computeNullKey(ObjLongToLongFunction<? super K> remappingFunction) {
        long newValue;
        int index;
        long[] vals;
        block22: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block23: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        long newValue2 = remappingFunction.applyAsLong(null, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                long newValue3 = remappingFunction.applyAsLong(null, this.defaultValue());
                this.incrementModCount();
                keys[index] = null;
                vals[index] = newValue3;
                this.postFreeSlotInsertHook();
                return newValue3;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsLong(null, vals[index]);
        return newValue;
    }

    @Override
    public Long computeIfAbsent(K key, Function<? super K, ? extends Long> mappingFunction) {
        if (key != null) {
            Long value;
            block34: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                Object[] keys = this.set;
                long[] vals = this.values;
                int capacity = keys.length;
                int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                Object cur = keys[index];
                if (cur == key) {
                    return vals[index];
                }
                if (cur != FREE) {
                    Long value2;
                    int firstRemoved;
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return vals[index];
                        }
                        if (this.noRemoved()) {
                            int bIndex = index;
                            int fIndex = index;
                            int step = 1;
                            while (true) {
                                if ((bIndex -= step) < 0) {
                                    bIndex += capacity;
                                }
                                if ((cur = keys[bIndex]) == key) {
                                    return vals[bIndex];
                                }
                                if (cur == FREE) {
                                    index = bIndex;
                                    break block34;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return vals[bIndex];
                                }
                                int t = (fIndex += step) - capacity;
                                if (t >= 0) {
                                    fIndex = t;
                                }
                                if ((cur = keys[fIndex]) == key) {
                                    return vals[fIndex];
                                }
                                if (cur == FREE) {
                                    index = fIndex;
                                    break block34;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return vals[fIndex];
                                }
                                step += 2;
                            }
                        }
                        firstRemoved = -1;
                    } else {
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            return vals[bIndex];
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block34;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return vals[bIndex];
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            return vals[fIndex];
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block34;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return vals[fIndex];
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    if ((value2 = (Long)mappingFunction.apply(key)) != null) {
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value2;
                        this.postRemovedSlotInsertHook();
                        return value2;
                    }
                    return null;
                }
            }
            if ((value = (Long)mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    Long computeIfAbsentNullKey(Function<? super K, ? extends Long> mappingFunction) {
        Long value;
        block24: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            long[] vals = this.values;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur == null) {
                return vals[index];
            }
            if (cur != FREE) {
                Long value2;
                int firstRemoved;
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                return vals[bIndex];
                            }
                            if (cur == FREE) {
                                index = bIndex;
                                break block24;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                return vals[fIndex];
                            }
                            if (cur == FREE) {
                                index = fIndex;
                                break block24;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == null) {
                        return vals[bIndex];
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == null) {
                        return vals[fIndex];
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = (Long)mappingFunction.apply(null)) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = null;
                    vals[firstRemoved] = value2;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = (Long)mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            keys[index] = null;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public long computeIfAbsent(K key, ToLongFunction<? super K> mappingFunction) {
        if (key != null) {
            block32: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                Object[] keys = this.set;
                long[] vals = this.values;
                int capacity = keys.length;
                int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                Object cur = keys[index];
                if (cur == key) {
                    return vals[index];
                }
                if (cur != FREE) {
                    int firstRemoved;
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return vals[index];
                        }
                        if (this.noRemoved()) {
                            int bIndex = index;
                            int fIndex = index;
                            int step = 1;
                            while (true) {
                                if ((bIndex -= step) < 0) {
                                    bIndex += capacity;
                                }
                                if ((cur = keys[bIndex]) == key) {
                                    return vals[bIndex];
                                }
                                if (cur == FREE) {
                                    index = bIndex;
                                    break block32;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return vals[bIndex];
                                }
                                int t = (fIndex += step) - capacity;
                                if (t >= 0) {
                                    fIndex = t;
                                }
                                if ((cur = keys[fIndex]) == key) {
                                    return vals[fIndex];
                                }
                                if (cur == FREE) {
                                    index = fIndex;
                                    break block32;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return vals[fIndex];
                                }
                                step += 2;
                            }
                        }
                        firstRemoved = -1;
                    } else {
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            return vals[bIndex];
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block32;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return vals[bIndex];
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            return vals[fIndex];
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block32;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return vals[fIndex];
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    long value = mappingFunction.applyAsLong(key);
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = value;
                    this.postRemovedSlotInsertHook();
                    return value;
                }
            }
            long value = mappingFunction.applyAsLong(key);
            this.incrementModCount();
            keys[index] = key;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    long computeIfAbsentNullKey(ToLongFunction<? super K> mappingFunction) {
        block22: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            long[] vals = this.values;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur == null) {
                return vals[index];
            }
            if (cur != FREE) {
                int firstRemoved;
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                return vals[bIndex];
                            }
                            if (cur == FREE) {
                                index = bIndex;
                                break block22;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                return vals[fIndex];
                            }
                            if (cur == FREE) {
                                index = fIndex;
                                break block22;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == null) {
                        return vals[bIndex];
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block22;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == null) {
                        return vals[fIndex];
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block22;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                long value = mappingFunction.applyAsLong(null);
                this.incrementModCount();
                keys[firstRemoved] = null;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        long value = mappingFunction.applyAsLong(null);
        this.incrementModCount();
        keys[index] = null;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    @Override
    public Long computeIfPresent(K key, BiFunction<? super K, ? super Long, ? extends Long> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            Long newValue = (Long)remappingFunction.apply(key, (Object)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public long computeIfPresent(K key, ObjLongToLongFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long newValue;
            long[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsLong(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Long merge(K key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        block30: {
            Long newValue;
            int index;
            long[] vals;
            block28: {
                block29: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block32: {
                        block31: {
                            if (key == null) break block30;
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block28;
                            if (cur == FREE) break block29;
                            if (cur == REMOVED) break block31;
                            if (this.keyEquals(key, cur)) break block28;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block32;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block28;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block29;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block28;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block28;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block29;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block28;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = value;
                    this.postRemovedSlotInsertHook();
                    return value;
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
            if ((newValue = (Long)remappingFunction.apply((Object)vals[index], (Object)value)) != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    Long mergeNullKey(Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        Long newValue;
        int index;
        long[] vals;
        block24: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block25: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = (Long)remappingFunction.apply((Object)vals[index], (Object)value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return null;
    }

    public long merge(K key, long value, LongBinaryOperator remappingFunction) {
        block28: {
            long newValue;
            int index;
            long[] vals;
            block26: {
                block27: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block30: {
                        block29: {
                            if (key == null) break block28;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block26;
                            if (cur == FREE) break block27;
                            if (cur == REMOVED) break block29;
                            if (this.keyEquals(key, cur)) break block26;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block30;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = value;
                    this.postRemovedSlotInsertHook();
                    return value;
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
            vals[index] = newValue = remappingFunction.applyAsLong(vals[index], value);
            return newValue;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    long mergeNullKey(long value, LongBinaryOperator remappingFunction) {
        long newValue;
        int index;
        long[] vals;
        block22: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block23: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsLong(vals[index], value);
        return newValue;
    }

    public long addValue(K key, long value) {
        long newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        vals[index] = newValue = vals[index] + value;
        return newValue;
    }

    public long addValue(K key, long addition, long defaultValue) {
        long newValue;
        long value = defaultValue + addition;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        vals[index] = newValue = vals[index] + addition;
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends Long> m) {
        CommonObjLongMapOps.putAll(this, m);
    }

    @Override
    public Long replace(K key, Long value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            long oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public long replace(K key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            long oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(K key, Long oldValue, Long newValue) {
        return this.replace(key, (long)oldValue, (long)newValue);
    }

    @Override
    public boolean replace(K key, long oldValue, long newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super Long, ? extends Long> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                vals[i] = (Long)function.apply(key, (Object)vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                vals[i] = (Long)function.apply(key, (Object)vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ObjLongToLongFunction<? super K> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                vals[i] = function.applyAsLong(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                vals[i] = function.applyAsLong(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Long remove(Object key) {
        if (key == null) {
            return this.removeNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            int bIndex;
            if (cur == FREE) {
                return null;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return null;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return null;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return null;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return null;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        long val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    Long removeNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return null;
                }
                step += 2;
            }
        }
        long val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean justRemove(Object key) {
        if (key == null) {
            return this.justRemoveNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return true;
    }

    boolean justRemoveNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long removeAsLong(Object key) {
        if (key == null) {
            return this.removeAsLongNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            int bIndex;
            if (cur == FREE) {
                return this.defaultValue();
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return this.defaultValue();
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return this.defaultValue();
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return this.defaultValue();
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return this.defaultValue();
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        long val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    long removeAsLongNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        long val = this.values[index];
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, (Long)value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean remove(Object key, long value) {
        if (key == null) {
            return this.removeEntryNullKey(value);
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        if (this.values[index] == value) {
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    boolean removeEntryNullKey(long value) {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 2;
            }
        }
        if (this.values[index] == value) {
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(ObjLongPredicate<? super K> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements ObjLongCursor<K> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjLongConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements ObjLongCursor<K> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjLongConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements LongCursor {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public long elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements LongIterator {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        long next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    this.index = nextI;
                    K[] keys = this.keys;
                    long prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Object)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public long elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        long next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    this.index = nextI;
                    K[] keys = this.keys;
                    long prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == ObjHash.FREE) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Object)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Long>> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Long> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Long>> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    this.index = nextI;
                    K[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Long>> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Long> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Long>> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    this.index = nextI;
                    K[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVObjLongMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVObjLongMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashSeparateKVObjLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return MutableQHashSeparateKVObjLongMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    action.accept((Object)vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept((Object)vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    changed |= s.removeLong(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.removeLong(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public LongCursor cursor() {
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return MutableQHashSeparateKVObjLongMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVObjLongMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !filter.test((Object)vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test((Object)vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(LongPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof LongCollection) {
                return this.removeAll((LongCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(LongCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof LongCollection) {
                return this.retainAll((LongCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(LongCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ObjLongEntry {
        private K key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjLongEntry {
        final int modCount;
        private final int index;
        final K key;
        private long value;

        MutableEntry(int modCount, int index, K key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Long setValue(Long newValue) {
            long unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            long oldValue = this.value;
            this.value = unwrappedNewValue = newValue.longValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            MutableQHashSeparateKVObjLongMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ObjLongEntry
    extends AbstractEntry<K, Long> {
        ObjLongEntry() {
        }

        abstract K key();

        @Override
        public final K getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Long getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                long v2 = (Long)e2.getValue();
                return MutableQHashSeparateKVObjLongMapGO.this.nullableKeyEquals(this.key(), k2) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVObjLongMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Long>>
    implements HashObjSet<Map.Entry<K, Long>>,
    InternalObjCollectionOps<Map.Entry<K, Long>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, Long>> equivalence() {
            return Equivalence.entryEquivalence(MutableQHashSeparateKVObjLongMapGO.this.keyEquivalence(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVObjLongMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVObjLongMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashSeparateKVObjLongMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVObjLongMapGO.this.containsEntry(e.getKey(), (Long)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || predicate.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || predicate.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<K, Long>> iterator() {
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Long>> cursor() {
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVObjLongMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    sb.append(' ');
                    sb.append(key != this ? key : "(this Collection)");
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    sb.append(' ');
                    sb.append(key != this ? key : "(this Collection)");
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVObjLongMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                long value = (Long)e.getValue();
                return MutableQHashSeparateKVObjLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Long>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !filter.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjLongMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjLongMapGO.this.values;
            if (MutableQHashSeparateKVObjLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVObjLongMapGO.this.clear();
        }
    }
}

