/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.DoubleCollection;
import net.openhft.koloboke.collect.DoubleCursor;
import net.openhft.koloboke.collect.DoubleIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractDoubleValueView;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.CommonObjDoubleMapOps;
import net.openhft.koloboke.collect.impl.InternalDoubleCollectionOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalObjDoubleMapOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.MutableQHashSeparateKVObjDoubleMapSO;
import net.openhft.koloboke.collect.impl.hash.ObjHash;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVObjDoubleQHash;
import net.openhft.koloboke.collect.map.ObjDoubleCursor;
import net.openhft.koloboke.collect.set.DoubleSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.DoubleBinaryOperator;
import net.openhft.koloboke.function.DoubleConsumer;
import net.openhft.koloboke.function.DoublePredicate;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.ObjDoubleConsumer;
import net.openhft.koloboke.function.ObjDoublePredicate;
import net.openhft.koloboke.function.ObjDoubleToDoubleFunction;
import net.openhft.koloboke.function.Predicate;
import net.openhft.koloboke.function.ToDoubleFunction;

public class MutableQHashSeparateKVObjDoubleMapGO<K>
extends MutableQHashSeparateKVObjDoubleMapSO<K> {
    @Override
    final void copy(SeparateKVObjDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjDoubleQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public double defaultValue() {
        return 0.0;
    }

    @Override
    public boolean containsEntry(Object key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Double.doubleToLongBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(Object key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Double get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return null;
    }

    public double getDouble(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return this.defaultValue();
    }

    @Override
    public Double getOrDefault(Object key, Double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public double getOrDefault(Object key, double defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Double.longBitsToDouble(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                action.accept(key, (Object)Double.longBitsToDouble(vals[i]));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                action.accept(key, (Object)Double.longBitsToDouble(vals[i]));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void forEach(ObjDoubleConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean forEachWhile(ObjDoublePredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || predicate.test(key, Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || predicate.test(key, Double.longBitsToDouble(vals[i]))) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ObjDoubleCursor<K> cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjDoubleMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalObjDoubleMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalObjDoubleMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<K, Double>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public DoubleCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                long val = vals[i];
                hashCode += this.nullableKeyHashCode(key) ^ (int)(val ^ val >>> 32);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                long val = vals[i];
                hashCode += this.nullableKeyHashCode(key) ^ (int)(val ^ val >>> 32);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Map)");
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Map)");
                sb.append('=');
                sb.append(Double.longBitsToDouble(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        Object[] newKeys = this.set;
        int capacity = newKeys.length;
        long[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                int index = QHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) % capacity;
                if (newKeys[index] != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                int index = QHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(key)) % capacity;
                if (newKeys[index] != FREE) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == FREE) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == FREE) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Double put(K key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    @Override
    public double put(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        long[] vals = this.values;
        double prevValue = Double.longBitsToDouble(vals[index]);
        vals[index] = Double.doubleToLongBits(value);
        return prevValue;
    }

    @Override
    public Double putIfAbsent(K key, Double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return null;
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    @Override
    public double putIfAbsent(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Double.longBitsToDouble(this.values[index]);
    }

    @Override
    public void justPut(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Double.doubleToLongBits(value);
    }

    @Override
    public void justPut(K key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Double compute(K key, BiFunction<? super K, ? super Double, ? extends Double> remappingFunction) {
        block31: {
            Double newValue;
            int index;
            long[] vals;
            block29: {
                Double newValue2;
                block30: {
                    Double newValue3;
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block33: {
                        block32: {
                            if (key == null) break block31;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block29;
                            if (cur == FREE) break block30;
                            if (cur == REMOVED) break block32;
                            if (this.keyEquals(key, cur)) break block29;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block33;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block29;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block30;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block29;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    if ((newValue3 = (Double)remappingFunction.apply(key, null)) != null) {
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = Double.doubleToLongBits(newValue3);
                        this.postRemovedSlotInsertHook();
                        return newValue3;
                    }
                    return null;
                }
                if ((newValue2 = (Double)remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = Double.doubleToLongBits(newValue2);
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
            if ((newValue = (Double)remappingFunction.apply(key, (Object)Double.longBitsToDouble(vals[index]))) != null) {
                vals[index] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return this.computeNullKey(remappingFunction);
    }

    Double computeNullKey(BiFunction<? super K, ? super Double, ? extends Double> remappingFunction) {
        Double newValue;
        int index;
        long[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                Double newValue2;
                block26: {
                    if (cur != FREE) {
                        Double newValue3;
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = (Double)remappingFunction.apply(null, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = null;
                            vals[firstRemoved] = Double.doubleToLongBits(newValue3);
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = (Double)remappingFunction.apply(null, null)) != null) {
                    this.incrementModCount();
                    keys[index] = null;
                    vals[index] = Double.doubleToLongBits(newValue2);
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = (Double)remappingFunction.apply(null, (Object)Double.longBitsToDouble(vals[index]))) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return null;
    }

    public double compute(K key, ObjDoubleToDoubleFunction<? super K> remappingFunction) {
        block28: {
            int index;
            long[] vals;
            block26: {
                block27: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block30: {
                        block29: {
                            if (key == null) break block28;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block26;
                            if (cur == FREE) break block27;
                            if (cur == REMOVED) break block29;
                            if (this.keyEquals(key, cur)) break block26;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block30;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    double newValue = remappingFunction.applyAsDouble(key, this.defaultValue());
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = Double.doubleToLongBits(newValue);
                    this.postRemovedSlotInsertHook();
                    return newValue;
                }
                double newValue = remappingFunction.applyAsDouble(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
            double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(vals[index]));
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.computeNullKey(remappingFunction);
    }

    double computeNullKey(ObjDoubleToDoubleFunction<? super K> remappingFunction) {
        int index;
        long[] vals;
        block22: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block23: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        double newValue = remappingFunction.applyAsDouble(null, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = Double.doubleToLongBits(newValue);
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                double newValue = remappingFunction.applyAsDouble(null, this.defaultValue());
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        double newValue = remappingFunction.applyAsDouble(null, Double.longBitsToDouble(vals[index]));
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    @Override
    public Double computeIfAbsent(K key, Function<? super K, ? extends Double> mappingFunction) {
        if (key != null) {
            Double value;
            block34: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                Object[] keys = this.set;
                long[] vals = this.values;
                int capacity = keys.length;
                int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                Object cur = keys[index];
                if (cur == key) {
                    return Double.longBitsToDouble(vals[index]);
                }
                if (cur != FREE) {
                    Double value2;
                    int firstRemoved;
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return Double.longBitsToDouble(vals[index]);
                        }
                        if (this.noRemoved()) {
                            int bIndex = index;
                            int fIndex = index;
                            int step = 1;
                            while (true) {
                                if ((bIndex -= step) < 0) {
                                    bIndex += capacity;
                                }
                                if ((cur = keys[bIndex]) == key) {
                                    return Double.longBitsToDouble(vals[bIndex]);
                                }
                                if (cur == FREE) {
                                    index = bIndex;
                                    break block34;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return Double.longBitsToDouble(vals[bIndex]);
                                }
                                int t = (fIndex += step) - capacity;
                                if (t >= 0) {
                                    fIndex = t;
                                }
                                if ((cur = keys[fIndex]) == key) {
                                    return Double.longBitsToDouble(vals[fIndex]);
                                }
                                if (cur == FREE) {
                                    index = fIndex;
                                    break block34;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return Double.longBitsToDouble(vals[fIndex]);
                                }
                                step += 2;
                            }
                        }
                        firstRemoved = -1;
                    } else {
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            return Double.longBitsToDouble(vals[bIndex]);
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block34;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return Double.longBitsToDouble(vals[bIndex]);
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            return Double.longBitsToDouble(vals[fIndex]);
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block34;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return Double.longBitsToDouble(vals[fIndex]);
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    if ((value2 = (Double)mappingFunction.apply(key)) != null) {
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = Double.doubleToLongBits(value2);
                        this.postRemovedSlotInsertHook();
                        return value2;
                    }
                    return null;
                }
            }
            if ((value = (Double)mappingFunction.apply(key)) != null) {
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(value);
                this.postFreeSlotInsertHook();
                return value;
            }
            return null;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    Double computeIfAbsentNullKey(Function<? super K, ? extends Double> mappingFunction) {
        Double value;
        block24: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            long[] vals = this.values;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur == null) {
                return Double.longBitsToDouble(vals[index]);
            }
            if (cur != FREE) {
                Double value2;
                int firstRemoved;
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                return Double.longBitsToDouble(vals[bIndex]);
                            }
                            if (cur == FREE) {
                                index = bIndex;
                                break block24;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                return Double.longBitsToDouble(vals[fIndex]);
                            }
                            if (cur == FREE) {
                                index = fIndex;
                                break block24;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == null) {
                        return Double.longBitsToDouble(vals[bIndex]);
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == null) {
                        return Double.longBitsToDouble(vals[fIndex]);
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = (Double)mappingFunction.apply(null)) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = null;
                    vals[firstRemoved] = Double.doubleToLongBits(value2);
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = (Double)mappingFunction.apply(null)) != null) {
            this.incrementModCount();
            keys[index] = null;
            vals[index] = Double.doubleToLongBits(value);
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public double computeIfAbsent(K key, ToDoubleFunction<? super K> mappingFunction) {
        if (key != null) {
            block32: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                Object[] keys = this.set;
                long[] vals = this.values;
                int capacity = keys.length;
                int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                Object cur = keys[index];
                if (cur == key) {
                    return Double.longBitsToDouble(vals[index]);
                }
                if (cur != FREE) {
                    int firstRemoved;
                    if (cur != REMOVED) {
                        if (this.keyEquals(key, cur)) {
                            return Double.longBitsToDouble(vals[index]);
                        }
                        if (this.noRemoved()) {
                            int bIndex = index;
                            int fIndex = index;
                            int step = 1;
                            while (true) {
                                if ((bIndex -= step) < 0) {
                                    bIndex += capacity;
                                }
                                if ((cur = keys[bIndex]) == key) {
                                    return Double.longBitsToDouble(vals[bIndex]);
                                }
                                if (cur == FREE) {
                                    index = bIndex;
                                    break block32;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return Double.longBitsToDouble(vals[bIndex]);
                                }
                                int t = (fIndex += step) - capacity;
                                if (t >= 0) {
                                    fIndex = t;
                                }
                                if ((cur = keys[fIndex]) == key) {
                                    return Double.longBitsToDouble(vals[fIndex]);
                                }
                                if (cur == FREE) {
                                    index = fIndex;
                                    break block32;
                                }
                                if (this.keyEquals(key, cur)) {
                                    return Double.longBitsToDouble(vals[fIndex]);
                                }
                                step += 2;
                            }
                        }
                        firstRemoved = -1;
                    } else {
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            return Double.longBitsToDouble(vals[bIndex]);
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block32;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return Double.longBitsToDouble(vals[bIndex]);
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            return Double.longBitsToDouble(vals[fIndex]);
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block32;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                return Double.longBitsToDouble(vals[fIndex]);
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    double value = mappingFunction.applyAsDouble(key);
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = Double.doubleToLongBits(value);
                    this.postRemovedSlotInsertHook();
                    return value;
                }
            }
            double value = mappingFunction.applyAsDouble(key);
            this.incrementModCount();
            keys[index] = key;
            vals[index] = Double.doubleToLongBits(value);
            this.postFreeSlotInsertHook();
            return value;
        }
        return this.computeIfAbsentNullKey(mappingFunction);
    }

    double computeIfAbsentNullKey(ToDoubleFunction<? super K> mappingFunction) {
        block22: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            long[] vals = this.values;
            int capacity = keys.length;
            int index = 0;
            Object cur = keys[0];
            if (cur == null) {
                return Double.longBitsToDouble(vals[index]);
            }
            if (cur != FREE) {
                int firstRemoved;
                if (cur != REMOVED) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                return Double.longBitsToDouble(vals[bIndex]);
                            }
                            if (cur == FREE) {
                                index = bIndex;
                                break block22;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                return Double.longBitsToDouble(vals[fIndex]);
                            }
                            if (cur == FREE) {
                                index = fIndex;
                                break block22;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == null) {
                        return Double.longBitsToDouble(vals[bIndex]);
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block22;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == null) {
                        return Double.longBitsToDouble(vals[fIndex]);
                    }
                    if (cur == FREE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block22;
                    }
                    if (cur == REMOVED && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                double value = mappingFunction.applyAsDouble(null);
                this.incrementModCount();
                keys[firstRemoved] = null;
                vals[firstRemoved] = Double.doubleToLongBits(value);
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        double value = mappingFunction.applyAsDouble(null);
        this.incrementModCount();
        keys[index] = null;
        vals[index] = Double.doubleToLongBits(value);
        this.postFreeSlotInsertHook();
        return value;
    }

    @Override
    public Double computeIfPresent(K key, BiFunction<? super K, ? super Double, ? extends Double> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            Double newValue = (Double)remappingFunction.apply(key, (Object)Double.longBitsToDouble(vals[index]));
            if (newValue != null) {
                vals[index] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public double computeIfPresent(K key, ObjDoubleToDoubleFunction<? super K> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double newValue = remappingFunction.applyAsDouble(key, Double.longBitsToDouble(vals[index]));
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Double merge(K key, Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        block30: {
            Double newValue;
            int index;
            long[] vals;
            block28: {
                block29: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block32: {
                        block31: {
                            if (key == null) break block30;
                            if (value == null) {
                                throw new NullPointerException();
                            }
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block28;
                            if (cur == FREE) break block29;
                            if (cur == REMOVED) break block31;
                            if (this.keyEquals(key, cur)) break block28;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block32;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block28;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block29;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block28;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block28;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block29;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block28;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = Double.doubleToLongBits(value);
                    this.postRemovedSlotInsertHook();
                    return value;
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(value);
                this.postFreeSlotInsertHook();
                return value;
            }
            if ((newValue = (Double)remappingFunction.apply((Object)Double.longBitsToDouble(vals[index]), (Object)value)) != null) {
                vals[index] = Double.doubleToLongBits(newValue);
                return newValue;
            }
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return null;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    Double mergeNullKey(Double value, BiFunction<? super Double, ? super Double, ? extends Double> remappingFunction) {
        Double newValue;
        int index;
        long[] vals;
        block24: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block25: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = Double.doubleToLongBits(value);
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(value);
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = (Double)remappingFunction.apply((Object)Double.longBitsToDouble(vals[index]), (Object)value)) != null) {
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return null;
    }

    public double merge(K key, double value, DoubleBinaryOperator remappingFunction) {
        block28: {
            int index;
            long[] vals;
            block26: {
                block27: {
                    int firstRemoved;
                    Object cur;
                    int capacity;
                    Object[] keys;
                    block30: {
                        block29: {
                            if (key == null) break block28;
                            if (remappingFunction == null) {
                                throw new NullPointerException();
                            }
                            keys = this.set;
                            vals = this.values;
                            capacity = keys.length;
                            index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) % capacity;
                            cur = keys[index];
                            if (cur == key) break block26;
                            if (cur == FREE) break block27;
                            if (cur == REMOVED) break block29;
                            if (this.keyEquals(key, cur)) break block26;
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (this.keyEquals(key, cur)) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                            break block30;
                        }
                        firstRemoved = index;
                    }
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        int t;
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if ((cur = keys[bIndex]) == key) {
                            index = bIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = bIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = bIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = bIndex;
                        }
                        if ((t = (fIndex += step) - capacity) >= 0) {
                            fIndex = t;
                        }
                        if ((cur = keys[fIndex]) == key) {
                            index = fIndex;
                            break block26;
                        }
                        if (cur == FREE) {
                            if (firstRemoved >= 0) break;
                            index = fIndex;
                            break block27;
                        }
                        if (cur != REMOVED) {
                            if (this.keyEquals(key, cur)) {
                                index = fIndex;
                                break block26;
                            }
                        } else if (firstRemoved < 0) {
                            firstRemoved = fIndex;
                        }
                        step += 2;
                    }
                    this.incrementModCount();
                    keys[firstRemoved] = key;
                    vals[firstRemoved] = Double.doubleToLongBits(value);
                    this.postRemovedSlotInsertHook();
                    return value;
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Double.doubleToLongBits(value);
                this.postFreeSlotInsertHook();
                return value;
            }
            double newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(vals[index]), value);
            vals[index] = Double.doubleToLongBits(newValue);
            return newValue;
        }
        return this.mergeNullKey(value, remappingFunction);
    }

    double mergeNullKey(double value, DoubleBinaryOperator remappingFunction) {
        int index;
        long[] vals;
        block22: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = 0;
            Object cur = keys[0];
            if (cur != null) {
                block23: {
                    if (cur != FREE) {
                        int firstRemoved;
                        if (cur != REMOVED) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == null) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == null) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == FREE) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == null) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == null) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == FREE) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur == REMOVED && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = null;
                        vals[firstRemoved] = Double.doubleToLongBits(value);
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = null;
                vals[index] = Double.doubleToLongBits(value);
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        double newValue = remappingFunction.applyAsDouble(Double.longBitsToDouble(vals[index]), value);
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(K key, double value) {
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        double newValue = Double.longBitsToDouble(vals[index]) + value;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    public double addValue(K key, double addition, double defaultValue) {
        double value = defaultValue + addition;
        int index = this.insert(key, Double.doubleToLongBits(value));
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        double newValue = Double.longBitsToDouble(vals[index]) + addition;
        vals[index] = Double.doubleToLongBits(newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends Double> m) {
        CommonObjDoubleMapOps.putAll(this, m);
    }

    @Override
    public Double replace(K key, Double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return null;
    }

    @Override
    public double replace(K key, double value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            double oldValue = Double.longBitsToDouble(vals[index]);
            vals[index] = Double.doubleToLongBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(K key, Double oldValue, Double newValue) {
        return this.replace(key, (double)oldValue, (double)newValue);
    }

    @Override
    public boolean replace(K key, double oldValue, double newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            if (vals[index] == Double.doubleToLongBits(oldValue)) {
                vals[index] = Double.doubleToLongBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super Double, ? extends Double> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                vals[i] = Double.doubleToLongBits((Double)function.apply(key, (Object)Double.longBitsToDouble(vals[i])));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                vals[i] = Double.doubleToLongBits((Double)function.apply(key, (Object)Double.longBitsToDouble(vals[i])));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ObjDoubleToDoubleFunction<? super K> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE) continue;
                vals[i] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(vals[i])));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED) continue;
                vals[i] = Double.doubleToLongBits(function.applyAsDouble(key, Double.longBitsToDouble(vals[i])));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Double remove(Object key) {
        if (key == null) {
            return this.removeNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            int bIndex;
            if (cur == FREE) {
                return null;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return null;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return null;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return null;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return null;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        double val = Double.longBitsToDouble(this.values[index]);
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    Double removeNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return null;
                }
                step += 2;
            }
        }
        double val = Double.longBitsToDouble(this.values[index]);
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean justRemove(Object key) {
        if (key == null) {
            return this.justRemoveNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return true;
    }

    boolean justRemoveNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public double removeAsDouble(Object key) {
        if (key == null) {
            return this.removeAsDoubleNullKey();
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            int bIndex;
            if (cur == FREE) {
                return this.defaultValue();
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return this.defaultValue();
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return this.defaultValue();
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return this.defaultValue();
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return this.defaultValue();
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        double val = Double.longBitsToDouble(this.values[index]);
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    double removeAsDoubleNullKey() {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        double val = Double.longBitsToDouble(this.values[index]);
        this.incrementModCount();
        keys[index] = REMOVED;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, (Double)value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean remove(Object key, double value) {
        if (key == null) {
            return this.removeEntryNullKey(value);
        }
        Object k = key;
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) % capacity;
        Object cur = keys[index];
        if (cur != k) {
            if (cur == FREE) {
                return false;
            }
            if (cur != REMOVED) {
                if (!this.keyEquals(k, cur)) {
                    if (!this.noRemoved()) {
                    } else {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = bIndex;
                                break;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break;
                            }
                            if (cur == FREE) {
                                return false;
                            }
                            if (this.keyEquals(k, cur)) {
                                index = fIndex;
                                break;
                            }
                            step += 2;
                        }
                    }
                }
            } else {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == FREE) {
                        return false;
                    }
                    if (cur != REMOVED && this.keyEquals(k, cur)) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
        }
        if (this.values[index] == Double.doubleToLongBits(value)) {
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    boolean removeEntryNullKey(double value) {
        Object[] keys = this.set;
        int capacity = keys.length;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == null) {
                    index = bIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == null) {
                    index = fIndex;
                    break;
                }
                if (cur == FREE) {
                    return false;
                }
                step += 2;
            }
        }
        if (this.values[index] == Double.doubleToLongBits(value)) {
            this.incrementModCount();
            keys[index] = REMOVED;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(ObjDoublePredicate<? super K> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        Object[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || !filter.test(key, Double.longBitsToDouble(vals[i]))) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == FREE || key == REMOVED || !filter.test(key, Double.longBitsToDouble(vals[i]))) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = REMOVED;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements ObjDoubleCursor<K> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjDoubleConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != ObjHash.FREE) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements ObjDoubleCursor<K> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjDoubleConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public double value() {
            if (this.curKey != ObjHash.FREE) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(double value) {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Double.doubleToLongBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements DoubleCursor {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public double elem() {
            if (this.curKey != ObjHash.FREE) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements DoubleIterator {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        double next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    this.index = nextI;
                    K[] keys = this.keys;
                    double prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = Double.longBitsToDouble(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Object)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements DoubleCursor {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public double elem() {
            if (this.curKey != ObjHash.FREE) {
                return Double.longBitsToDouble(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements DoubleIterator {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        double next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = Double.longBitsToDouble(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    this.index = nextI;
                    K[] keys = this.keys;
                    double prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == ObjHash.FREE) continue;
                        this.next = Double.longBitsToDouble(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Object)Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(Double.longBitsToDouble(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Double>> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Double> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Double>> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Double> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    this.index = nextI;
                    K[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Double>> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index;
        Object curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Double> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                K[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = ObjHash.FREE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != ObjHash.FREE) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = ObjHash.FREE;
            MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
            this.keys[this.index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Double>> {
        final K[] keys;
        final long[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            Object[] keys = this.keys;
            this.vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Double>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            K[] keys = this.keys;
            long[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Double> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    this.index = nextI;
                    K[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        Object key = keys[nextI];
                        if (key == ObjHash.FREE) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
            this.keys[index] = ObjHash.REMOVED;
            MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractDoubleValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVObjDoubleMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVObjDoubleMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashSeparateKVObjDoubleMapGO.this.containsValue(o);
        }

        public boolean contains(double v) {
            return MutableQHashSeparateKVObjDoubleMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(long bits) {
            return MutableQHashSeparateKVObjDoubleMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Double> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    action.accept((Object)Double.longBitsToDouble(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept((Object)Double.longBitsToDouble(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    action.accept(Double.longBitsToDouble(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept(Double.longBitsToDouble(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(DoublePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || predicate.test(Double.longBitsToDouble(vals[i]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.allContainingIn((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    changed |= c.add(Double.longBitsToDouble(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add(Double.longBitsToDouble(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(DoubleSet s) {
            if (s instanceof InternalDoubleCollectionOps) {
                return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.removeDouble(Double.longBitsToDouble(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    changed |= s.removeDouble(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.removeDouble(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public DoubleIterator iterator() {
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public DoubleCursor cursor() {
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    result[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    a[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public double[] toDoubleArray() {
            int size = this.size();
            double[] result = new double[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    result[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public double[] toArray(double[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new double[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    a[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = Double.longBitsToDouble(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE) continue;
                    sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    sb.append(' ').append(Double.longBitsToDouble(vals[i])).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeDouble((Double)o);
        }

        public boolean removeDouble(double v) {
            return MutableQHashSeparateKVObjDoubleMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeDouble(long bits) {
            return MutableQHashSeparateKVObjDoubleMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVObjDoubleMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Double> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !filter.test((Object)Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test((Object)Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(DoublePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !filter.test(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.removeAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.removeAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof DoubleCollection) {
                return this.retainAll((DoubleCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(DoubleCollection c) {
            if (c instanceof InternalDoubleCollectionOps) {
                return this.retainAll((InternalDoubleCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(Double.longBitsToDouble(vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalDoubleCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ObjDoubleEntry {
        private K key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ObjDoubleEntry {
        final int modCount;
        private final int index;
        final K key;
        private long value;

        MutableEntry(int modCount, int index, K key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Double setValue(Double newValue) {
            long unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            double oldValue = Double.longBitsToDouble(this.value);
            this.value = unwrappedNewValue = Double.doubleToLongBits(newValue);
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            MutableQHashSeparateKVObjDoubleMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ObjDoubleEntry
    extends AbstractEntry<K, Double> {
        ObjDoubleEntry() {
        }

        abstract K key();

        @Override
        public final K getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Double getValue() {
            return Double.longBitsToDouble(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                long v2 = Double.doubleToLongBits((Double)e2.getValue());
                return MutableQHashSeparateKVObjDoubleMapGO.this.nullableKeyEquals(this.key(), k2) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVObjDoubleMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Double>>
    implements HashObjSet<Map.Entry<K, Double>>,
    InternalObjCollectionOps<Map.Entry<K, Double>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, Double>> equivalence() {
            return Equivalence.entryEquivalence(MutableQHashSeparateKVObjDoubleMapGO.this.keyEquivalence(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVObjDoubleMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVObjDoubleMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashSeparateKVObjDoubleMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVObjDoubleMapGO.this.containsEntry(e.getKey(), (Double)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Double>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Double>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || predicate.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || predicate.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<K, Double>> iterator() {
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Double>> cursor() {
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            if (!MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Double>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVObjDoubleMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE) continue;
                    sb.append(' ');
                    sb.append(key != this ? key : "(this Collection)");
                    sb.append('=');
                    sb.append(Double.longBitsToDouble(vals[i]));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED) continue;
                    sb.append(' ');
                    sb.append(key != this ? key : "(this Collection)");
                    sb.append('=');
                    sb.append(Double.longBitsToDouble(vals[i]));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVObjDoubleMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                double value = (Double)e.getValue();
                return MutableQHashSeparateKVObjDoubleMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Double>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !filter.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !filter.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVObjDoubleMapGO.this.modCount();
            Object[] keys = MutableQHashSeparateKVObjDoubleMapGO.this.set;
            long[] vals = MutableQHashSeparateKVObjDoubleMapGO.this.values;
            if (MutableQHashSeparateKVObjDoubleMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object key = keys[i];
                    if (key == ObjHash.FREE || key == ObjHash.REMOVED || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVObjDoubleMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = ObjHash.REMOVED;
                    MutableQHashSeparateKVObjDoubleMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVObjDoubleMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVObjDoubleMapGO.this.clear();
        }
    }
}

