/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.ShortCollection;
import net.openhft.koloboke.collect.ShortCursor;
import net.openhft.koloboke.collect.ShortIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.AbstractShortValueView;
import net.openhft.koloboke.collect.impl.CommonDoubleShortMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalDoubleShortMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.MutableQHashSeparateKVDoubleShortMapSO;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVDoubleShortQHash;
import net.openhft.koloboke.collect.map.DoubleShortCursor;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.ShortSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.DoubleShortConsumer;
import net.openhft.koloboke.function.DoubleShortPredicate;
import net.openhft.koloboke.function.DoubleShortToShortFunction;
import net.openhft.koloboke.function.DoubleToShortFunction;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.Predicate;
import net.openhft.koloboke.function.ShortBinaryOperator;
import net.openhft.koloboke.function.ShortConsumer;
import net.openhft.koloboke.function.ShortPredicate;

public class MutableQHashSeparateKVDoubleShortMapGO
extends MutableQHashSeparateKVDoubleShortMapSO {
    @Override
    final void copy(SeparateKVDoubleShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVDoubleShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public boolean containsEntry(long key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public short get(double key) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Short getOrDefault(Object key, Short defaultValue) {
        long k = Double.doubleToLongBits((Double)key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public short getOrDefault(double key, short defaultValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Double, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Object)Double.longBitsToDouble(key), (Object)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(DoubleShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(DoubleShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key), vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public DoubleShortCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonDoubleShortMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalDoubleShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalDoubleShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Double, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ');
            sb.append(Double.longBitsToDouble(key));
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacity = newKeys.length;
        short[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
            if (newKeys[index] != 0x7FFFFFFFFFFFFFFEL) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] == 0x7FFFFFFFFFFFFFFEL) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] == 0x7FFFFFFFFFFFFFFEL) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Short put(Double key, Short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public short put(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Short putIfAbsent(Double key, Short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public short putIfAbsent(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public void justPut(long key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Short compute(Double key, BiFunction<? super Double, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int index;
        short[] vals;
        long k;
        block25: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                Short newValue2;
                block26: {
                    if (cur != 0x7FFFFFFFFFFFFFFEL) {
                        Short newValue3;
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = (Short)remappingFunction.apply((Object)Double.longBitsToDouble(k), null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = (Short)remappingFunction.apply((Object)Double.longBitsToDouble(k), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = (Short)remappingFunction.apply((Object)Double.longBitsToDouble(k), (Object)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return null;
    }

    public short compute(double key, DoubleShortToShortFunction remappingFunction) {
        short newValue;
        int index;
        short[] vals;
        long k;
        block22: {
            k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                block23: {
                    if (cur != 0x7FFFFFFFFFFFFFFEL) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        short newValue2 = remappingFunction.applyAsShort(Double.longBitsToDouble(k), this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsShort(Double.longBitsToDouble(k), this.defaultValue());
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(Double.longBitsToDouble(k), vals[index]);
        return newValue;
    }

    @Override
    public Short computeIfAbsent(Double key, Function<? super Double, ? extends Short> mappingFunction) {
        Short value;
        long k;
        block24: {
            k = Double.doubleToLongBits(key);
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            short[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur == k) {
                return vals[index];
            }
            if (cur != 0x7FFFFFFFFFFFFFFEL) {
                Short value2;
                int firstRemoved;
                if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                return vals[bIndex];
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                index = bIndex;
                                break block24;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                return vals[fIndex];
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                index = fIndex;
                                break block24;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        return vals[bIndex];
                    }
                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        return vals[fIndex];
                    }
                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = (Short)mappingFunction.apply((Object)Double.longBitsToDouble(k))) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = k;
                    vals[firstRemoved] = value2;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = (Short)mappingFunction.apply((Object)Double.longBitsToDouble(k))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(double key, DoubleToShortFunction mappingFunction) {
        long k;
        block22: {
            k = Double.doubleToLongBits(key);
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            short[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur == k) {
                return vals[index];
            }
            if (cur != 0x7FFFFFFFFFFFFFFEL) {
                int firstRemoved;
                if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                return vals[bIndex];
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                index = bIndex;
                                break block22;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                return vals[fIndex];
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                index = fIndex;
                                break block22;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        return vals[bIndex];
                    }
                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block22;
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        return vals[fIndex];
                    }
                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block22;
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                short value = mappingFunction.applyAsShort(Double.longBitsToDouble(k));
                this.incrementModCount();
                keys[firstRemoved] = k;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        short value = mappingFunction.applyAsShort(Double.longBitsToDouble(k));
        this.incrementModCount();
        keys[index] = k;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    @Override
    public Short computeIfPresent(Double key, BiFunction<? super Double, ? super Short, ? extends Short> remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            Short newValue = (Short)remappingFunction.apply((Object)Double.longBitsToDouble(k), (Object)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = Long.MAX_VALUE;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public short computeIfPresent(double key, DoubleShortToShortFunction remappingFunction) {
        long k = Double.doubleToLongBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            short newValue;
            short[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsShort(Double.longBitsToDouble(k), vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Short merge(Double key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int index;
        short[] vals;
        block24: {
            long k = Double.doubleToLongBits(key);
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                block25: {
                    if (cur != 0x7FFFFFFFFFFFFFFEL) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = (Short)remappingFunction.apply((Object)vals[index], (Object)value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return null;
    }

    public short merge(double key, short value, ShortBinaryOperator remappingFunction) {
        short newValue;
        int index;
        short[] vals;
        block22: {
            long k = Double.doubleToLongBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            long[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
            long cur = keys[index];
            if (cur != k) {
                block23: {
                    if (cur != 0x7FFFFFFFFFFFFFFEL) {
                        int firstRemoved;
                        if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = bIndex;
                                        break block23;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block22;
                                    }
                                    if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                        index = fIndex;
                                        break block23;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block22;
                            }
                            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block23;
                            }
                            if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(vals[index], value);
        return newValue;
    }

    public short addValue(double key, short value) {
        short newValue;
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return value;
        }
        short[] vals = this.values;
        vals[index] = newValue = (short)(vals[index] + value);
        return newValue;
    }

    public short addValue(double key, short addition, short defaultValue) {
        short newValue;
        short value;
        long k = Double.doubleToLongBits(key);
        int index = this.insert(k, value = (short)(defaultValue + addition));
        if (index < 0) {
            return value;
        }
        short[] vals = this.values;
        vals[index] = newValue = (short)(vals[index] + addition);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Double, ? extends Short> m) {
        CommonDoubleShortMapOps.putAll(this, m);
    }

    @Override
    public Short replace(Double key, Short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public short replace(double key, short value) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Double key, Short oldValue, Short newValue) {
        return this.replace((double)key, (short)oldValue, (short)newValue);
    }

    @Override
    public boolean replace(double key, short oldValue, short newValue) {
        long k = Double.doubleToLongBits(key);
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Double, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            vals[i] = (Short)function.apply((Object)Double.longBitsToDouble(key), (Object)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(DoubleShortToShortFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            vals[i] = function.applyAsShort(Double.longBitsToDouble(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    @Override
    public Short remove(Object key) {
        long k = Double.doubleToLongBits((Double)key);
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return null;
                }
                step += 2;
            }
        }
        short val = this.values[index];
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean justRemove(double key) {
        long k = Double.doubleToLongBits(key);
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return true;
    }

    @Override
    public boolean justRemove(long key) {
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
        long cur = keys[index];
        if (cur != key) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return true;
    }

    public short remove(double key) {
        long k = Double.doubleToLongBits(key);
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        short val = this.values[index];
        this.incrementModCount();
        keys[index] = Long.MAX_VALUE;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Double)key, (Short)value);
    }

    public boolean remove(double key, short value) {
        long k = Double.doubleToLongBits(key);
        long[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVDoubleKeyMixing.mix(k) % capacity;
        long cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFFFFFFFFFEL) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == k) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == k) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFFFFFFFFFEL) {
                    return false;
                }
                step += 2;
            }
        }
        if (this.values[index] == value) {
            this.incrementModCount();
            keys[index] = Long.MAX_VALUE;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeIf(DoubleShortPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long[] keys = this.set;
        short[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test(Double.longBitsToDouble(key), vals[i])) continue;
            this.incrementModCount();
            ++mc;
            keys[i] = Long.MAX_VALUE;
            this.postRemoveHook();
            changed = true;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements DoubleShortCursor {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements DoubleShortCursor {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key), vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double key() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ShortCursor {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public short elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ShortIterator {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
            this.keys[index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public short elem() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
            this.keys[index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Short>> {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Short> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Short>> {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
            this.keys[index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Double, Short>> {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index;
        long curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(Consumer<? super Map.Entry<Double, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public Map.Entry<Double, Short> elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                long[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFFFFFFFFFEL;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            if (this.curKey != 0x7FFFFFFFFFFFFFFEL) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
            this.keys[this.index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Double, Short>> {
        final long[] keys;
        final short[] vals;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Double, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            short[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Double, Short> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
            this.keys[index] = Long.MAX_VALUE;
            MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVDoubleShortMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVDoubleShortMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashSeparateKVDoubleShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return MutableQHashSeparateKVDoubleShortMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.removeShort(vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVDoubleShortMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVDoubleShortMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return MutableQHashSeparateKVDoubleShortMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVDoubleShortMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Short> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !filter.test((Object)vals[i])) continue;
                MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(ShortPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !filter.test(vals[i])) continue;
                MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.removeAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !c.contains(vals[i])) continue;
                MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || !c.contains(vals[i])) continue;
                MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.retainAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || c.contains(vals[i])) continue;
                MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends DoubleShortEntry {
        private long key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends DoubleShortEntry {
        final int modCount;
        private final int index;
        final long key;
        private short value;

        MutableEntry(int modCount, int index, long key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        @Override
        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            MutableQHashSeparateKVDoubleShortMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class DoubleShortEntry
    extends AbstractEntry<Double, Short> {
        DoubleShortEntry() {
        }

        abstract long key();

        @Override
        public final Double getKey() {
            return Double.longBitsToDouble(this.key());
        }

        abstract short value();

        @Override
        public final Short getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = Double.doubleToLongBits((Double)e2.getKey());
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Double, Short>>
    implements HashObjSet<Map.Entry<Double, Short>>,
    InternalObjCollectionOps<Map.Entry<Double, Short>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Double, Short>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVDoubleShortMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVDoubleShortMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashSeparateKVDoubleShortMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVDoubleShortMapGO.this.containsEntry((Double)e.getKey(), (short)((Short)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Double, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Double, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Double, Short>> iterator() {
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVDoubleShortMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Double, Short>> cursor() {
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVDoubleShortMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Double, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVDoubleShortMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                sb.append(' ');
                sb.append(Double.longBitsToDouble(key));
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVDoubleShortMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                double key = (Double)e.getKey();
                short value = (Short)e.getValue();
                return MutableQHashSeparateKVDoubleShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Double, Short>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !filter.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || !c.contains(e.with(key, vals[i]))) continue;
                MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVDoubleShortMapGO.this.modCount();
            long[] keys = MutableQHashSeparateKVDoubleShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVDoubleShortMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(e.with(key, vals[i]))) continue;
                MutableQHashSeparateKVDoubleShortMapGO.this.incrementModCount();
                ++mc;
                keys[i] = Long.MAX_VALUE;
                MutableQHashSeparateKVDoubleShortMapGO.this.postRemoveHook();
                changed = true;
            }
            if (mc != MutableQHashSeparateKVDoubleShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVDoubleShortMapGO.this.clear();
        }
    }
}

