/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.LongCollection;
import net.openhft.koloboke.collect.LongCursor;
import net.openhft.koloboke.collect.LongIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractLongValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonByteLongMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalByteLongMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.MutableQHashSeparateKVByteLongMapSO;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVByteLongQHash;
import net.openhft.koloboke.collect.map.ByteLongCursor;
import net.openhft.koloboke.collect.set.LongSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.ByteLongConsumer;
import net.openhft.koloboke.function.ByteLongPredicate;
import net.openhft.koloboke.function.ByteLongToLongFunction;
import net.openhft.koloboke.function.ByteToLongFunction;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.LongBinaryOperator;
import net.openhft.koloboke.function.LongConsumer;
import net.openhft.koloboke.function.LongPredicate;
import net.openhft.koloboke.function.Predicate;

public class MutableQHashSeparateKVByteLongMapGO
extends MutableQHashSeparateKVByteLongMapSO {
    @Override
    final void copy(SeparateKVByteLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVByteLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    @Override
    public boolean containsEntry(byte key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public long get(byte key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Long getOrDefault(Object key, Long defaultValue) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public long getOrDefault(byte key, long defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Byte, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Object)key, (Object)vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Object)key, (Object)vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ByteLongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ByteLongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ByteLongCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteLongMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalByteLongMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalByteLongMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Byte, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                long val = vals[i];
                hashCode += key ^ (int)(val ^ val >>> 32);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                long val = vals[i];
                hashCode += key ^ (int)(val ^ val >>> 32);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        byte[] newKeys = this.set;
        int capacity = newKeys.length;
        long[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Long put(Byte key, Long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        long[] vals = this.values;
        long prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public long put(byte key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        long[] vals = this.values;
        long prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Long putIfAbsent(Byte key, Long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    @Override
    public long putIfAbsent(byte key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(byte key, long value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public Long compute(Byte key, BiFunction<? super Byte, ? super Long, ? extends Long> remappingFunction) {
        Long newValue;
        int index;
        long[] vals;
        byte removed;
        byte k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix(k) % capacity;
            byte cur = keys[index];
            if (cur != k) {
                Long newValue2;
                block29: {
                    if (cur != free) {
                        Long newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = (Long)remappingFunction.apply((Object)k, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = (Long)remappingFunction.apply((Object)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = (Long)remappingFunction.apply((Object)k, (Object)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public long compute(byte key, ByteLongToLongFunction remappingFunction) {
        long newValue;
        int index;
        long[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        long newValue2 = remappingFunction.applyAsLong(key, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                long newValue3 = remappingFunction.applyAsLong(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue3;
                this.postFreeSlotInsertHook();
                return newValue3;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsLong(key, vals[index]);
        return newValue;
    }

    @Override
    public Long computeIfAbsent(Byte key, Function<? super Byte, ? extends Long> mappingFunction) {
        Long value;
        byte k;
        block27: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            long[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(k) % capacity;
            byte cur = keys[index];
            if (cur == k) {
                return vals[index];
            }
            if (cur != free) {
                Long value2;
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                return vals[bIndex];
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block27;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                return vals[fIndex];
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block27;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        return vals[bIndex];
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        return vals[fIndex];
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = (Long)mappingFunction.apply((Object)k)) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = k;
                    vals[firstRemoved] = value2;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = (Long)mappingFunction.apply((Object)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public long computeIfAbsent(byte key, ByteToLongFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            long[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur == key) {
                return vals[index];
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                return vals[bIndex];
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block25;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                return vals[fIndex];
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block25;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        return vals[bIndex];
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        return vals[fIndex];
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                long value = mappingFunction.applyAsLong(key);
                this.incrementModCount();
                keys[firstRemoved] = key;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        long value = mappingFunction.applyAsLong(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    @Override
    public Long computeIfPresent(Byte key, BiFunction<? super Byte, ? super Long, ? extends Long> remappingFunction) {
        byte k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            long[] vals = this.values;
            Long newValue = (Long)remappingFunction.apply((Object)k, (Object)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = this.removedValue;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public long computeIfPresent(byte key, ByteLongToLongFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            long newValue;
            long[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsLong(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    @Override
    public Long merge(Byte key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        Long newValue;
        int index;
        long[] vals;
        byte removed;
        block27: {
            byte k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix(k) % capacity;
            byte cur = keys[index];
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = (Long)remappingFunction.apply((Object)vals[index], (Object)value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public long merge(byte key, long value, LongBinaryOperator remappingFunction) {
        long newValue;
        int index;
        long[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsLong(vals[index], value);
        return newValue;
    }

    public long addValue(byte key, long value) {
        long newValue;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        vals[index] = newValue = vals[index] + value;
        return newValue;
    }

    public long addValue(byte key, long addition, long defaultValue) {
        long newValue;
        long value = defaultValue + addition;
        int index = this.insert(key, value);
        if (index < 0) {
            return value;
        }
        long[] vals = this.values;
        vals[index] = newValue = vals[index] + addition;
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Byte, ? extends Long> m) {
        CommonByteLongMapOps.putAll(this, m);
    }

    @Override
    public Long replace(Byte key, Long value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            long oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public long replace(byte key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            long oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Byte key, Long oldValue, Long newValue) {
        return this.replace((byte)key, (long)oldValue, (long)newValue);
    }

    @Override
    public boolean replace(byte key, long oldValue, long newValue) {
        int index = this.index(key);
        if (index >= 0) {
            long[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Byte, ? super Long, ? extends Long> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                vals[i] = (Long)function.apply((Object)key, (Object)vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = (Long)function.apply((Object)key, (Object)vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ByteLongToLongFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                vals[i] = function.applyAsLong(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.applyAsLong(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    @Override
    public Long remove(Object key) {
        byte removed;
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(k) % capacity;
            byte cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            long val = this.values[index];
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(byte key) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public long remove(byte key) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            long val = this.values[index];
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, (Long)value);
    }

    public boolean remove(byte key, long value) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if (this.values[index] == value) {
                this.incrementModCount();
                keys[index] = removed;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(ByteLongPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        long[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements ByteLongCursor {
        final byte[] keys;
        final long[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        long curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteLongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements ByteLongCursor {
        final byte[] keys;
        final long[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        long curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteLongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements LongCursor {
        final byte[] keys;
        final long[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        long curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements LongIterator {
        final byte[] keys;
        final long[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        long next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = this.removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    byte removed = this.removed;
                    long prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Object)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        final byte[] keys;
        final long[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        long curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        final byte[] keys;
        final long[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        long next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    long prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Object)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Long>> {
        final byte[] keys;
        final long[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        long curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Long> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Long>> {
        final byte[] keys;
        final long[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = this.removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    byte removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Long>> {
        final byte[] keys;
        final long[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        long curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Long> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Long>> {
        final byte[] keys;
        final long[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            long[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVByteLongMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVByteLongMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashSeparateKVByteLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return MutableQHashSeparateKVByteLongMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept((Object)vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Object)vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.removeLong(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeLong(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public LongCursor cursor() {
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return MutableQHashSeparateKVByteLongMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVByteLongMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test((Object)vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !filter.test((Object)vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(LongPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof LongCollection) {
                return this.removeAll((LongCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(LongCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof LongCollection) {
                return this.retainAll((LongCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(LongCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ByteLongEntry {
        private byte key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ByteLongEntry {
        final int modCount;
        private final int index;
        final byte key;
        private long value;

        MutableEntry(int modCount, int index, byte key, long value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public Long setValue(Long newValue) {
            long unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            long oldValue = this.value;
            this.value = unwrappedNewValue = newValue.longValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(long newValue) {
            MutableQHashSeparateKVByteLongMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ByteLongEntry
    extends AbstractEntry<Byte, Long> {
        ByteLongEntry() {
        }

        abstract byte key();

        @Override
        public final Byte getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Long getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                long v2 = (Long)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Long>>
    implements HashObjSet<Map.Entry<Byte, Long>>,
    InternalObjCollectionOps<Map.Entry<Byte, Long>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Long>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVByteLongMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVByteLongMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashSeparateKVByteLongMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVByteLongMapGO.this.containsEntry((Byte)e.getKey(), (Long)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || predicate.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || predicate.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Byte, Long>> iterator() {
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Long>> cursor() {
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVByteLongMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVByteLongMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                long value = (Long)e.getValue();
                return MutableQHashSeparateKVByteLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Long>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || !filter.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !filter.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteLongMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteLongMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteLongMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteLongMapGO.this.set;
            long[] vals = MutableQHashSeparateKVByteLongMapGO.this.values;
            if (MutableQHashSeparateKVByteLongMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteLongMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteLongMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteLongMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVByteLongMapGO.this.clear();
        }
    }
}

