/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.FloatCollection;
import net.openhft.koloboke.collect.FloatCursor;
import net.openhft.koloboke.collect.impl.CommonFloatCollectionOps;
import net.openhft.koloboke.collect.impl.CommonSetOps;
import net.openhft.koloboke.collect.impl.InternalFloatCollectionOps;
import net.openhft.koloboke.collect.impl.hash.MutableFloatQHashSetSO;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVFloatQHash;
import net.openhft.koloboke.collect.set.FloatSet;
import net.openhft.koloboke.collect.set.hash.HashFloatSet;

public class MutableQHashFloatSetGO
extends MutableFloatQHashSetSO
implements HashFloatSet,
InternalFloatCollectionOps {
    @Override
    final void copy(SeparateKVFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonFloatCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public FloatCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Float e) {
        return this.add(e.floatValue());
    }

    @Override
    public boolean add(int key) {
        block21: {
            int[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVFloatKeyMixing.mix(key) % capacity;
            int cur = keys[index];
            if (cur != 0x7FFFFFFE) {
                int firstRemoved;
                if (cur == key) {
                    return false;
                }
                if (cur <= 0x7FFFFFFE) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == 0x7FFFFFFE) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == key) {
                                return false;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == 0x7FFFFFFE) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == key) {
                                return false;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block21;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == 0x7FFFFFFE) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block21;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur > 0x7FFFFFFE && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.postRemovedSlotInsertHook();
                return true;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postFreeSlotInsertHook();
        return true;
    }

    public boolean add(float key) {
        return this.add(Float.floatToIntBits(key));
    }

    public boolean addAll(@Nonnull Collection<? extends Float> c) {
        return CommonFloatCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeFloat(((Float)key).floatValue());
    }

    @Override
    boolean justRemove(int key) {
        return this.removeFloat(key);
    }

    @Override
    public boolean removeFloat(int key) {
        int[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix(key) % capacity;
        int cur = keys[index];
        if (cur != key) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == key) {
                    index = bIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == key) {
                    index = fIndex;
                    break;
                }
                if (cur == 0x7FFFFFFE) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = Integer.MAX_VALUE;
        this.postRemoveHook();
        return true;
    }

    public boolean removeFloat(float key) {
        return this.removeFloat(Float.floatToIntBits(key));
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof FloatCollection) {
            InternalFloatCollectionOps c2;
            if (c instanceof InternalFloatCollectionOps && (c2 = (InternalFloatCollectionOps)((Object)c)).size() < this.size()) {
                return c2.reverseRemoveAllFrom((FloatSet)this);
            }
            return this.removeAll((HashFloatSet)this, (FloatCollection)c);
        }
        return this.removeAll((HashFloatSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

