/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.hash.HashOverflowException;
import net.openhft.koloboke.collect.impl.AbstractContainer;
import net.openhft.koloboke.collect.impl.hash.HashConfigWrapper;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.QHashCapacities;

public abstract class MutableQHash
extends AbstractContainer
implements QHash {
    private HashConfigWrapper configWrapper;
    private int size;
    private int maxSize;
    private int freeSlots;
    private int minFreeSlots;
    private int removedSlots;
    private int modCount = 0;

    private static int minFreeSlots(int capacity, int size, double maxLoad, int maxSize) {
        double load = (double)size / (double)capacity;
        double rehashLoad = 0.55 + 0.721 * load - 0.274 * load * load;
        int minFreeSlots = rehashLoad > maxLoad ? (int)((double)capacity * (1.0 - rehashLoad)) : capacity - maxSize;
        return minFreeSlots > 0 ? minFreeSlots : 1;
    }

    @Nonnull
    public final HashConfig hashConfig() {
        return this.configWrapper.config();
    }

    @Override
    public final HashConfigWrapper configWrapper() {
        return this.configWrapper;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public abstract int capacity();

    @Override
    public final boolean noRemoved() {
        return this.removedSlots == 0;
    }

    @Override
    public final int freeSlots() {
        return this.freeSlots;
    }

    @Override
    public final int removedSlots() {
        return this.removedSlots;
    }

    @Override
    public final int modCount() {
        return this.modCount;
    }

    final void incrementModCount() {
        ++this.modCount;
    }

    public final int maxSize() {
        return this.maxSize;
    }

    public final double currentLoad() {
        return (double)(this.size + this.removedSlots) / (double)this.capacity();
    }

    final void copy(QHash hash) {
        int minFreeSlots;
        this.configWrapper = hash.configWrapper();
        int size = this.size = hash.size();
        int capacity = hash.capacity();
        this.maxSize = this.maxSize(capacity);
        this.freeSlots = hash.freeSlots();
        int freeSlots = this.freeSlots;
        if (freeSlots < (minFreeSlots = (this.minFreeSlots = MutableQHash.minFreeSlots(capacity, size, this.hashConfig().getMaxLoad(), this.maxSize)))) {
            this.minFreeSlots = (freeSlots + 1) / 2;
        }
        this.removedSlots = hash.removedSlots();
    }

    final void init(HashConfigWrapper configWrapper, int size) {
        this.configWrapper = configWrapper;
        this.size = 0;
        this.internalInit(this.targetCapacity(size));
    }

    private void internalInit(int capacity) {
        this.initSlotCounts(capacity);
        this.allocateArrays(capacity);
    }

    abstract void allocateArrays(int var1);

    private void initSlotCounts(int capacity) {
        this.maxSize = this.maxSize(capacity);
        this.minFreeSlots = MutableQHash.minFreeSlots(capacity, this.size, this.hashConfig().getMaxLoad(), this.maxSize);
        this.freeSlots = capacity - this.size;
        int freeSlots = this.freeSlots;
        if (freeSlots < this.minFreeSlots) {
            this.minFreeSlots = (freeSlots + 1) / 2;
        }
        this.removedSlots = 0;
    }

    private int maxSize(int capacity) {
        return !this.isMaxCapacity(capacity) ? this.configWrapper.maxSize(capacity) : capacity - 1;
    }

    abstract void rehash(int var1);

    final void initForRehash(int newCapacity) {
        ++this.modCount;
        this.internalInit(newCapacity);
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.freeSlots = this.capacity();
        this.removedSlots = 0;
    }

    abstract void removeAt(int var1);

    public boolean shrink() {
        int newCapacity = this.targetCapacity(this.size);
        if (this.removedSlots > 0 || newCapacity < this.capacity()) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    private boolean tryRehashForExpansion(int newCapacity) {
        if (newCapacity > this.capacity() || this.removedSlots > 0) {
            this.rehash(newCapacity);
            return true;
        }
        if (this.freeSlots < this.minFreeSlots) {
            this.minFreeSlots = (this.freeSlots + 1) / 2;
        }
        return false;
    }

    public final boolean ensureCapacity(long minSize) {
        int intMinSize = (int)Math.min(minSize, Integer.MAX_VALUE);
        if (minSize < 0L) {
            throw new IllegalArgumentException("Min size should be positive, " + minSize + " given.");
        }
        int additionalSize = intMinSize - this.size;
        if (additionalSize <= 0) {
            return false;
        }
        if (intMinSize > this.maxSize || this.freeSlots - additionalSize < this.minFreeSlots) {
            return this.tryRehashForExpansion(this.targetCapacity(intMinSize));
        }
        return false;
    }

    final void postRemoveHook() {
        --this.size;
        ++this.removedSlots;
    }

    final void postFreeSlotInsertHook() {
        if (++this.size > this.maxSize && this.tryRehashForExpansion(this.grownCapacity())) {
            return;
        }
        if (--this.freeSlots < this.minFreeSlots && !this.tryRehashIfTooFewFreeSlots() && this.freeSlots == 0) {
            throw new HashOverflowException();
        }
    }

    final void postRemovedSlotInsertHook() {
        if (++this.size > this.maxSize && this.tryRehashForExpansion(this.grownCapacity())) {
            return;
        }
        --this.removedSlots;
    }

    private boolean tryRehashIfTooFewFreeSlots() {
        if (this.removedSlots > 0) {
            this.rehash(this.targetCapacity(this.size));
            return true;
        }
        return this.tryRehashForExpansion(this.grownCapacity());
    }

    boolean doubleSizedArrays() {
        return false;
    }

    private int targetCapacity(int size) {
        return QHashCapacities.capacity(this.configWrapper, size, this.doubleSizedArrays());
    }

    private boolean isMaxCapacity(int capacity) {
        return QHashCapacities.isMaxCapacity(capacity, this.doubleSizedArrays());
    }

    private int grownCapacity() {
        return QHashCapacities.nearestGreaterCapacity(this.configWrapper.grow(this.capacity()), this.size, this.doubleSizedArrays());
    }
}

