/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.LongCollection;
import net.openhft.koloboke.collect.LongCursor;
import net.openhft.koloboke.collect.LongIterator;
import net.openhft.koloboke.collect.impl.hash.MutableParallelKVLongQHashSO;
import net.openhft.koloboke.collect.set.LongSet;
import net.openhft.koloboke.collect.set.hash.HashLongSet;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.LongConsumer;
import net.openhft.koloboke.function.LongPredicate;
import net.openhft.koloboke.function.Predicate;

public abstract class MutableParallelKVLongQHashGO
extends MutableParallelKVLongQHashSO {
    @Override
    @Nonnull
    public long[] table() {
        return this.table;
    }

    @Override
    boolean doubleSizedArrays() {
        return true;
    }

    @Override
    public int capacity() {
        return this.table.length >> 1;
    }

    public void forEach(Consumer<? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Object)key);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept((Object)key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(LongCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(LongCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                changed |= c.add(key);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                changed |= c.add(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(LongSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                changed |= s.removeLong(key);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                changed |= s.removeLong(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public LongIterator iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedIterator(mc);
        }
        return new NoRemovedIterator(mc);
    }

    public LongCursor setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedCursor(mc);
        }
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                result[resultIndex++] = key;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                result[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                a[resultIndex++] = key;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                a[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public long[] toLongArray() {
        int size = this.size();
        long[] result = new long[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                result[resultIndex++] = key;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                result[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public long[] toArray(long[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new long[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0L;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                a[resultIndex++] = key;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                a[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0L;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                hashCode += (int)(key ^ key >>> 32);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                hashCode += (int)(key ^ key >>> 32);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                sb.append(' ').append(key).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                sb.append(' ').append(key).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(long var1);

    public boolean removeIf(Predicate<? super Long> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || !filter.test((Object)key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || !filter.test((Object)key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(LongPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.retainAll(thisC, (LongCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long removed = this.removedValue;
        long[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                tab[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedCursor
    implements LongCursor {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;

        SomeRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVLongQHashGO.this.table;
            this.index = this.tab.length;
            long free = this.free = MutableParallelKVLongQHashGO.this.freeValue;
            this.removed = MutableParallelKVLongQHashGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            long removed = this.removed;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVLongQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVLongQHashGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                long removed = this.removed;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableParallelKVLongQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableParallelKVLongQHashGO.this.incrementModCount();
            this.tab[this.index] = this.removed;
            MutableParallelKVLongQHashGO.this.postRemoveHook();
        }
    }

    class SomeRemovedIterator
    implements LongIterator {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        long next;

        SomeRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVLongQHashGO.this.table;
            long[] tab = MutableParallelKVLongQHashGO.this.table;
            long free = this.free = MutableParallelKVLongQHashGO.this.freeValue;
            long removed = this.removed = MutableParallelKVLongQHashGO.this.removedValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key == free || key == removed) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVLongQHashGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    long removed = this.removed;
                    long prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key == free || key == removed) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept((Object)key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVLongQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            long removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free || key == removed) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVLongQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVLongQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVLongQHashGO.this.incrementModCount();
            this.tab[index] = this.removed;
            MutableParallelKVLongQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements LongCursor {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index;
        long curKey;

        NoRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVLongQHashGO.this.table;
            this.index = this.tab.length;
            long free = this.free = MutableParallelKVLongQHashGO.this.freeValue;
            this.removed = MutableParallelKVLongQHashGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVLongQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVLongQHashGO.this.modCount()) {
                long[] tab = this.tab;
                long free = this.free;
                for (int i = this.index - 2; i >= 0; i -= 2) {
                    long key = tab[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            long free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableParallelKVLongQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableParallelKVLongQHashGO.this.incrementModCount();
            this.tab[this.index] = this.removed;
            MutableParallelKVLongQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedIterator
    implements LongIterator {
        final long[] tab;
        final long free;
        final long removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        long next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVLongQHashGO.this.table;
            long[] tab = MutableParallelKVLongQHashGO.this.table;
            long free = this.free = MutableParallelKVLongQHashGO.this.freeValue;
            this.removed = MutableParallelKVLongQHashGO.this.removedValue;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                long key = tab[nextI];
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVLongQHashGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    long free = this.free;
                    long prev = this.next;
                    while ((nextI -= 2) >= 0) {
                        long key = tab[nextI];
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept((Object)key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVLongQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                long key = tab[i];
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVLongQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVLongQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVLongQHashGO.this.incrementModCount();
            this.tab[index] = this.removed;
            MutableParallelKVLongQHashGO.this.postRemoveHook();
        }
    }
}

