/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.IntCollection;
import net.openhft.koloboke.collect.IntCursor;
import net.openhft.koloboke.collect.IntIterator;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.MutableParallelKVIntQHashSO;
import net.openhft.koloboke.collect.set.IntSet;
import net.openhft.koloboke.collect.set.hash.HashIntSet;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.IntConsumer;
import net.openhft.koloboke.function.IntPredicate;
import net.openhft.koloboke.function.Predicate;

public abstract class MutableParallelKVIntQHashGO
extends MutableParallelKVIntQHashSO {
    @Override
    @Nonnull
    public long[] table() {
        return this.table;
    }

    @Override
    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free) continue;
                action.accept((Object)key);
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed) continue;
                action.accept((Object)key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free) continue;
                action.accept(key);
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed) continue;
                action.accept(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(IntCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(IntCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free) continue;
                changed |= c.add(key);
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed) continue;
                changed |= c.add(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(IntSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free) continue;
                changed |= s.removeInt(key);
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed) continue;
                changed |= s.removeInt(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public IntIterator iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedIterator(mc);
        }
        return new NoRemovedIterator(mc);
    }

    public IntCursor setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedCursor(mc);
        }
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free) continue;
                result[resultIndex++] = key;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed) continue;
                result[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free) continue;
                a[resultIndex++] = key;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed) continue;
                a[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public int[] toIntArray() {
        int size = this.size();
        int[] result = new int[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free) continue;
                result[resultIndex++] = key;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed) continue;
                result[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public int[] toArray(int[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new int[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free) continue;
                a[resultIndex++] = key;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed) continue;
                a[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free) continue;
                hashCode += key;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed) continue;
                hashCode += key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free) continue;
                sb.append(' ').append(key).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed) continue;
                sb.append(' ').append(key).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(int var1);

    public boolean removeIf(Predicate<? super Integer> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || !filter.test((Object)key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed || !filter.test((Object)key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(IntPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashIntSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashIntSet thisC, @Nonnull IntCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashIntSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof IntCollection) {
            return this.retainAll(thisC, (IntCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashIntSet thisC, @Nonnull IntCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        int removed = this.removedValue;
        long[] tab = this.table;
        long base = LONG_BASE + INT_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 3;
            while ((off -= 8L) >= 0L) {
                int key = U.getInt(tab, base + off);
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putInt(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedCursor
    implements IntCursor {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;

        SomeRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVIntQHashGO.this.table;
            this.index = this.tab.length;
            int free = this.free = MutableParallelKVIntQHashGO.this.freeValue;
            this.removed = MutableParallelKVIntQHashGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVIntQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVIntQHashGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                int removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableParallelKVIntQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableParallelKVIntQHashGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)this.index << 3), this.removed);
            MutableParallelKVIntQHashGO.this.postRemoveHook();
        }
    }

    class SomeRemovedIterator
    implements IntIterator {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        int next;

        SomeRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVIntQHashGO.this.table;
            long[] tab = MutableParallelKVIntQHashGO.this.table;
            int free = this.free = MutableParallelKVIntQHashGO.this.freeValue;
            int removed = this.removed = MutableParallelKVIntQHashGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVIntQHashGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    int free = this.free;
                    int removed = this.removed;
                    int prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key == free || key == removed) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept((Object)key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVIntQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || key == removed) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVIntQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVIntQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVIntQHashGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)index << 3), this.removed);
            MutableParallelKVIntQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements IntCursor {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index;
        int curKey;

        NoRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVIntQHashGO.this.table;
            this.index = this.tab.length;
            int free = this.free = MutableParallelKVIntQHashGO.this.freeValue;
            this.removed = MutableParallelKVIntQHashGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVIntQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVIntQHashGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableParallelKVIntQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableParallelKVIntQHashGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)this.index << 3), this.removed);
            MutableParallelKVIntQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedIterator
    implements IntIterator {
        final long[] tab;
        final int free;
        final int removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        int next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVIntQHashGO.this.table;
            long[] tab = MutableParallelKVIntQHashGO.this.table;
            int free = this.free = MutableParallelKVIntQHashGO.this.freeValue;
            this.removed = MutableParallelKVIntQHashGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVIntQHashGO.this.modCount()) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    int free = this.free;
                    int prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Object)key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVIntQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVIntQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVIntQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVIntQHashGO.this.incrementModCount();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)index << 3), this.removed);
            MutableParallelKVIntQHashGO.this.postRemoveHook();
        }
    }
}

