/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.impl.InternalObjByteMapOps;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableLHashSeparateKVObjKeyMap;
import net.openhft.koloboke.collect.impl.hash.SeparateKVObjByteLHash;
import net.openhft.koloboke.collect.map.hash.HashObjByteMap;

public abstract class MutableLHashSeparateKVObjByteMapSO<K>
extends MutableLHashSeparateKVObjKeyMap<K>
implements HashObjByteMap<K>,
InternalObjByteMapOps<K>,
SeparateKVObjByteLHash {
    byte[] values;

    void copy(SeparateKVObjByteLHash hash) {
        super.copy(hash);
        this.values = (byte[])hash.valueArray().clone();
    }

    void move(SeparateKVObjByteLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public byte[] valueArray() {
        return this.values;
    }

    int valueIndex(byte value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        Object[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] == FREE || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(byte value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(byte value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Byte)value);
    }

    int insert(K key, byte value) {
        if (key != null) {
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) & capacityMask;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return index;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                    if (cur != key && !this.keyEquals(key, cur)) continue;
                    return index;
                }
            }
            this.incrementModCount();
            keys[index] = key;
            this.values[index] = value;
            this.postInsertHook();
            return -1;
        }
        return this.insertNullKey(value);
    }

    int insertNullKey(byte value) {
        Object[] keys = this.set;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return index;
            }
            int capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                if (cur != null) continue;
                return index;
            }
        }
        this.incrementModCount();
        keys[index] = null;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new byte[capacity];
    }
}

