/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.FloatCollection;
import net.openhft.koloboke.collect.FloatCursor;
import net.openhft.koloboke.collect.FloatIterator;
import net.openhft.koloboke.collect.LongCollection;
import net.openhft.koloboke.collect.LongCursor;
import net.openhft.koloboke.collect.LongIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractFloatValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonLongFloatMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalFloatCollectionOps;
import net.openhft.koloboke.collect.impl.InternalLongFloatMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableLHashSeparateKVLongFloatMapSO;
import net.openhft.koloboke.collect.impl.hash.MutableSeparateKVLongLHashGO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVLongFloatLHash;
import net.openhft.koloboke.collect.map.LongFloatCursor;
import net.openhft.koloboke.collect.set.FloatSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashLongSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.BiConsumer;
import net.openhft.koloboke.function.BiFunction;
import net.openhft.koloboke.function.Consumer;
import net.openhft.koloboke.function.FloatBinaryOperator;
import net.openhft.koloboke.function.FloatConsumer;
import net.openhft.koloboke.function.FloatPredicate;
import net.openhft.koloboke.function.Function;
import net.openhft.koloboke.function.LongFloatConsumer;
import net.openhft.koloboke.function.LongFloatPredicate;
import net.openhft.koloboke.function.LongFloatToFloatFunction;
import net.openhft.koloboke.function.LongPredicate;
import net.openhft.koloboke.function.LongToFloatFunction;
import net.openhft.koloboke.function.Predicate;

public class MutableLHashSeparateKVLongFloatMapGO
extends MutableLHashSeparateKVLongFloatMapSO {
    @Override
    final void copy(SeparateKVLongFloatLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVLongFloatLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    @Override
    public boolean containsEntry(long key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Float.floatToIntBits(value);
        }
        return false;
    }

    @Override
    public boolean containsEntry(long key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return null;
    }

    public float get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return this.defaultValue();
    }

    @Override
    public Float getOrDefault(Object key, Float defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return defaultValue;
    }

    public float getOrDefault(long key, float defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept((Object)key, (Object)Float.valueOf(Float.intBitsToFloat(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept(key, Float.intBitsToFloat(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || predicate.test(key, Float.intBitsToFloat(vals[i]))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public LongFloatCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongFloatMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalLongFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalLongFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Long, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(Float.intBitsToFloat(vals[i]));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        int[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            int index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
            if (newKeys[index] != free) {
                while (newKeys[index = index - 1 & capacityMask] != free) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Float put(Long key, Float value) {
        int index = this.insert(key, Float.floatToIntBits(value.floatValue()));
        if (index < 0) {
            return null;
        }
        int[] vals = this.values;
        float prevValue = Float.intBitsToFloat(vals[index]);
        vals[index] = Float.floatToIntBits(value.floatValue());
        return Float.valueOf(prevValue);
    }

    @Override
    public float put(long key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        int[] vals = this.values;
        float prevValue = Float.intBitsToFloat(vals[index]);
        vals[index] = Float.floatToIntBits(value);
        return prevValue;
    }

    @Override
    public Float putIfAbsent(Long key, Float value) {
        int index = this.insert(key, Float.floatToIntBits(value.floatValue()));
        if (index < 0) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(this.values[index]));
    }

    @Override
    public float putIfAbsent(long key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Float.intBitsToFloat(this.values[index]);
    }

    @Override
    public void justPut(long key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Float.floatToIntBits(value);
    }

    @Override
    public void justPut(long key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Float compute(Long key, BiFunction<? super Long, ? super Float, ? extends Float> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = (Float)remappingFunction.apply((Object)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = Float.floatToIntBits(newValue.floatValue());
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = (Float)remappingFunction.apply((Object)k, (Object)Float.valueOf(Float.intBitsToFloat(vals[index])))) != null) {
            vals[index] = Float.floatToIntBits(newValue.floatValue());
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public float compute(long key, LongFloatToFloatFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsFloat(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Float.floatToIntBits(newValue);
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat(vals[index]));
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    @Override
    public Float computeIfAbsent(Long key, Function<? super Long, ? extends Float> mappingFunction) {
        Float value;
        long k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        int[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVLongKeyMixing.mix(k) & capacityMask;
        long cur = keys[index];
        if (cur == k) {
            return Float.valueOf(Float.intBitsToFloat(vals[index]));
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return Float.valueOf(Float.intBitsToFloat(vals[index]));
            } while (cur != free);
        }
        if ((value = (Float)mappingFunction.apply((Object)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = Float.floatToIntBits(value.floatValue());
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public float computeIfAbsent(long key, LongToFloatFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        int[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
        long cur = keys[index];
        if (cur == key) {
            return Float.intBitsToFloat(vals[index]);
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return Float.intBitsToFloat(vals[index]);
            } while (cur != free);
        }
        float value = mappingFunction.applyAsFloat(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = Float.floatToIntBits(value);
        this.postInsertHook();
        return value;
    }

    @Override
    public Float computeIfPresent(Long key, BiFunction<? super Long, ? super Float, ? extends Float> remappingFunction) {
        long k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            int[] vals = this.values;
            Float newValue = (Float)remappingFunction.apply((Object)k, (Object)Float.valueOf(Float.intBitsToFloat(vals[index])));
            if (newValue != null) {
                vals[index] = Float.floatToIntBits(newValue.floatValue());
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public float computeIfPresent(long key, LongFloatToFloatFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat(vals[index]));
            vals[index] = Float.floatToIntBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Float merge(Long key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = Float.floatToIntBits(value.floatValue());
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = (Float)remappingFunction.apply((Object)Float.valueOf(Float.intBitsToFloat(vals[index])), (Object)value)) != null) {
            vals[index] = Float.floatToIntBits(newValue.floatValue());
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public float merge(long key, float value, FloatBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                keys[index] = key;
                vals[index] = Float.floatToIntBits(value);
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(vals[index]), value);
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public float addValue(long key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return value;
        }
        int[] vals = this.values;
        float newValue = Float.intBitsToFloat(vals[index]) + value;
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public float addValue(long key, float addition, float defaultValue) {
        float value = defaultValue + addition;
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return value;
        }
        int[] vals = this.values;
        float newValue = Float.intBitsToFloat(vals[index]) + addition;
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Long, ? extends Float> m) {
        CommonLongFloatMapOps.putAll(this, m);
    }

    @Override
    public Float replace(Long key, Float value) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float oldValue = Float.intBitsToFloat(vals[index]);
            vals[index] = Float.floatToIntBits(value.floatValue());
            return Float.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public float replace(long key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float oldValue = Float.intBitsToFloat(vals[index]);
            vals[index] = Float.floatToIntBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Long key, Float oldValue, Float newValue) {
        return this.replace((long)key, oldValue.floatValue(), newValue.floatValue());
    }

    @Override
    public boolean replace(long key, float oldValue, float newValue) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            if (vals[index] == Float.floatToIntBits(oldValue)) {
                vals[index] = Float.floatToIntBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super Float, ? extends Float> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            vals[i] = Float.floatToIntBits(((Float)function.apply((Object)key, (Object)Float.valueOf(Float.intBitsToFloat(vals[i])))).floatValue());
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(LongFloatToFloatFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            vals[i] = Float.floatToIntBits(function.applyAsFloat(key, Float.intBitsToFloat(vals[i])));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        long keyToShift;
        int indexToRemove;
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        int capacityMask = keys.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = free;
        this.postRemoveHook();
    }

    @Override
    public Float remove(Object key) {
        long free;
        long k = (Long)key;
        if (k != (free = this.freeValue)) {
            long keyToShift;
            int indexToRemove;
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVLongKeyMixing.mix(k) & capacityMask;
            long cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            int[] vals = this.values;
            float val = Float.intBitsToFloat(vals[index]);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return Float.valueOf(val);
        }
        return null;
    }

    @Override
    public boolean justRemove(long key) {
        long free = this.freeValue;
        if (key != free) {
            long keyToShift;
            int indexToRemove;
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            int[] vals = this.values;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public float remove(long key) {
        long free = this.freeValue;
        if (key != free) {
            long keyToShift;
            int indexToRemove;
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            int[] vals = this.values;
            float val = Float.intBitsToFloat(vals[index]);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, ((Float)value).floatValue());
    }

    public boolean remove(long key, float value) {
        long free = this.freeValue;
        if (key != free) {
            int[] vals;
            long[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVLongKeyMixing.mix(key) & capacityMask;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((vals = this.values)[index] == Float.floatToIntBits(value)) {
                long keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(LongFloatPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key == free || !filter.test(key, Float.intBitsToFloat(vals[i]))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Long> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key == free || !filter.test((Object)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(LongPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                long key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.retainAll(thisC, (LongCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                long key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashLongSet thisC, @Nonnull LongCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        long delayedRemoved = 0L;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                long key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    long keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                        if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                keys[indexToRemove] = key;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = free;
                    this.postRemoveHook();
                } else {
                    keys[i] = delayedRemoved;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, long delayedRemoved) {
        long free = this.freeValue;
        long[] keys = this.set;
        int[] vals = this.values;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            long keyToShift;
            int indexToRemove;
            if (keys[i] != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if (keyToShift != delayedRemoved && (LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
        }
    }

    @Override
    public LongIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public LongCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements LongFloatCursor {
        long[] keys;
        int[] vals;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue);
        }

        public void forEachForward(LongFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(float value) {
            if (this.curKey == this.free) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.vals[this.index] = Float.floatToIntBits(value);
            if (this.vals == MutableLHashSeparateKVLongFloatMapGO.this.values) return;
            MutableLHashSeparateKVLongFloatMapGO.this.values[this.index] = Float.floatToIntBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVLongFloatMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVLongFloatMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        long[] keys;
        int[] vals;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue);
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public float elem() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVLongFloatMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVLongFloatMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        long[] keys;
        int[] vals;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        float next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            long free = this.free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = Float.intBitsToFloat(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = Float.intBitsToFloat(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Object)Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVLongFloatMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = Float.intBitsToFloat(vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVLongFloatMapGO.this.justRemove(keys[index]);
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Float>> {
        long[] keys;
        int[] vals;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index;
        long curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            this.curKey = free = (this.free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Object)new MutableEntry2(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Float> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVLongFloatMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVLongFloatMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, long key, int value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(int newValue) {
                if (NoRemovedEntryCursor.this.vals == MutableLHashSeparateKVLongFloatMapGO.this.values) {
                    NoRemovedEntryCursor.this.vals[NoRemovedEntryCursor.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVLongFloatMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Float>> {
        long[] keys;
        int[] vals;
        final long free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            long free = this.free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry2(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            int[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Object)new MutableEntry2(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Float> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                    this.index = nextI;
                    long[] keys = this.keys;
                    long free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry2(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVLongFloatMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashSeparateKVLongFloatMapGO.this.modCount(), indexToShift, keyToShift, vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVLongFloatMapGO.this.justRemove(keys[index]);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, long key, int value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(int newValue) {
                if (NoRemovedEntryIterator.this.vals == MutableLHashSeparateKVLongFloatMapGO.this.values) {
                    NoRemovedEntryIterator.this.vals[NoRemovedEntryIterator.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVLongFloatMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableLHashSeparateKVLongFloatMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVLongFloatMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableLHashSeparateKVLongFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return MutableLHashSeparateKVLongFloatMapGO.this.containsValue(v);
        }

        @Override
        public boolean contains(int bits) {
            return MutableLHashSeparateKVLongFloatMapGO.this.containsValue(bits);
        }

        @Override
        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Object)Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(Float.intBitsToFloat(vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(Float.intBitsToFloat(vals[i]));
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeFloat(Float.intBitsToFloat(vals[i]));
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeFloat(vals[i]);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public FloatCursor cursor() {
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = Float.intBitsToFloat(vals[i]);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(Float.intBitsToFloat(vals[i])).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return MutableLHashSeparateKVLongFloatMapGO.this.removeValue(v);
        }

        @Override
        public boolean removeFloat(int bits) {
            return MutableLHashSeparateKVLongFloatMapGO.this.removeValue(bits);
        }

        @Override
        public void clear() {
            MutableLHashSeparateKVLongFloatMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Float> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    long key = keys[i];
                    if (key == free || !filter.test((Object)Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(FloatPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    long key = keys[i];
                    if (key == free || !filter.test(Float.intBitsToFloat(vals[i]))) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof FloatCollection) {
                return this.removeAll((FloatCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    long key = keys[i];
                    if (key == free || !c.contains(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.removeAll((InternalFloatCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    long key = keys[i];
                    if (key == free || !c.contains(Float.intBitsToFloat(vals[i]))) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalFloatCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    long key = keys[i];
                    if (key == free || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof FloatCollection) {
                return this.retainAll((FloatCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    long key = keys[i];
                    if (key == free || c.contains(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.retainAll((InternalFloatCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    long key = keys[i];
                    if (key == free || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalFloatCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    long key = keys[i];
                    if (key == free || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends LongFloatEntry {
        private long key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends LongFloatEntry {
        final int modCount;
        private final int index;
        final long key;
        private int value;

        MutableEntry(int modCount, int index, long key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public Float setValue(Float newValue) {
            int unwrappedNewValue;
            if (this.modCount != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            float oldValue = Float.intBitsToFloat(this.value);
            this.value = unwrappedNewValue = Float.floatToIntBits(newValue.floatValue());
            this.updateValueInTable(unwrappedNewValue);
            return Float.valueOf(oldValue);
        }

        void updateValueInTable(int newValue) {
            MutableLHashSeparateKVLongFloatMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class LongFloatEntry
    extends AbstractEntry<Long, Float> {
        LongFloatEntry() {
        }

        abstract long key();

        @Override
        public final Long getKey() {
            return this.key();
        }

        abstract int value();

        @Override
        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Float>>
    implements HashObjSet<Map.Entry<Long, Float>>,
    InternalObjCollectionOps<Map.Entry<Long, Float>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Long, Float>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashSeparateKVLongFloatMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableLHashSeparateKVLongFloatMapGO.this.size();
        }

        public double currentLoad() {
            return MutableLHashSeparateKVLongFloatMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashSeparateKVLongFloatMapGO.this.containsEntry((long)((Long)e.getKey()), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || predicate.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Long, Float>> iterator() {
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Float>> cursor() {
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableLHashSeparateKVLongFloatMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Float.intBitsToFloat(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVLongFloatMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                float value = ((Float)e.getValue()).floatValue();
                return MutableLHashSeparateKVLongFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Float>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    long key = keys[i];
                    if (key == free || !filter.test((Object)new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    long key = keys[i];
                    if (key == free || !c.contains(e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVLongFloatMapGO.this.modCount();
            long free = MutableLHashSeparateKVLongFloatMapGO.this.freeValue;
            long[] keys = MutableLHashSeparateKVLongFloatMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            long delayedRemoved = 0L;
            int[] vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    long key = keys[i];
                    if (key == free || c.contains(e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        long keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                            if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    keys[indexToRemove] = key;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = free;
                        MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = delayedRemoved;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVLongFloatMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableLHashSeparateKVLongFloatMapGO.this.clear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVLongLHashGO.NoRemovedCursor {
        int[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashSeparateKVLongFloatMapGO.this, mc);
            this.vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            long curKey = this.curKey;
            long free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVLongFloatMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                    if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = free;
                MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVLongFloatMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVLongLHashGO.NoRemovedIterator {
        int[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashSeparateKVLongFloatMapGO.this, mc);
            this.vals = MutableLHashSeparateKVLongFloatMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVLongFloatMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] keys = this.keys;
            int[] vals = this.vals;
            if (keys == MutableLHashSeparateKVLongFloatMapGO.this.set) {
                long keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVLongFloatMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != this.free) {
                    if ((LHash.SeparateKVLongKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = this.free;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = this.free;
                MutableLHashSeparateKVLongFloatMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVLongFloatMapGO.this.justRemove(keys[index]);
            }
        }
    }
}

