/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.impl.InternalDoubleFloatMapOps;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableLHashSeparateKVDoubleKeyMap;
import net.openhft.koloboke.collect.impl.hash.SeparateKVDoubleFloatLHash;
import net.openhft.koloboke.collect.map.hash.HashDoubleFloatMap;

public abstract class MutableLHashSeparateKVDoubleFloatMapSO
extends MutableLHashSeparateKVDoubleKeyMap
implements HashDoubleFloatMap,
InternalDoubleFloatMapOps,
SeparateKVDoubleFloatLHash {
    int[] values;

    void copy(SeparateKVDoubleFloatLHash hash) {
        super.copy(hash);
        this.values = (int[])hash.valueArray().clone();
    }

    void move(SeparateKVDoubleFloatLHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public int[] valueArray() {
        return this.values;
    }

    int valueIndex(int value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(int value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(int value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(float value) {
        if (this.isEmpty()) {
            return -1;
        }
        int val = Float.floatToIntBits(value);
        int index = -1;
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || val != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(float value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(float value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Float)value).floatValue());
    }

    int insert(long key, int value) {
        long[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVDoubleKeyMixing.mix(key) & capacityMask;
        long cur = keys[index];
        if (cur != 0x7FFFFFFFFFFFFFFEL) {
            if (cur == key) {
                return index;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != 0x7FFFFFFFFFFFFFFEL) {
                if (cur != key) continue;
                return index;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new int[capacity];
    }
}

