/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.CommonSetOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableObjLHashSetSO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVObjLHash;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;

public class MutableLHashObjSetGO<E>
extends MutableObjLHashSetSO<E>
implements HashObjSet<E>,
InternalObjCollectionOps<E> {
    @Override
    final void copy(SeparateKVObjLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonObjCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public ObjCursor<E> cursor() {
        return this.setCursor();
    }

    public boolean add(E key) {
        if (key != null) {
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(key)) & capacityMask;
            Object cur = keys[index];
            if (cur != FREE) {
                if (cur == key || this.keyEquals(key, cur)) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                    if (cur != key && !this.keyEquals(key, cur)) continue;
                    return false;
                }
            }
            this.incrementModCount();
            keys[index] = key;
            this.postInsertHook();
            return true;
        }
        return this.addNullKey();
    }

    private boolean addNullKey() {
        Object[] keys = this.set;
        int index = 0;
        Object cur = keys[0];
        if (cur != FREE) {
            if (cur == null) {
                return false;
            }
            int capacityMask = keys.length - 1;
            while ((cur = keys[index = index - 1 & capacityMask]) != FREE) {
                if (cur != null) continue;
                return false;
            }
        }
        this.incrementModCount();
        keys[index] = null;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends E> c) {
        return CommonObjCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        if (key != null) {
            Object keyToShift;
            int indexToRemove;
            Object k = key;
            Object[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVObjKeyMixing.mix(this.keyHashCode(k)) & capacityMask;
            Object cur = keys[index];
            if (cur != k) {
                if (cur == FREE) {
                    return false;
                }
                if (!this.keyEquals(k, cur)) {
                    while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                        if (cur == FREE) {
                            return false;
                        }
                        if (!this.keyEquals(k, cur)) continue;
                    }
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
                if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
            }
            keys[indexToRemove] = FREE;
            this.postRemoveHook();
            return true;
        }
        return this.removeNullKey();
    }

    private boolean removeNullKey() {
        Object keyToShift;
        int indexToRemove;
        Object[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = 0;
        Object cur = keys[0];
        if (cur != null) {
            if (cur == FREE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != null) {
                if (cur != FREE) continue;
                return false;
            }
        }
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != FREE) {
            if ((LHash.SeparateKVObjKeyMixing.mix(this.nullableKeyHashCode(keyToShift)) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
        }
        keys[indexToRemove] = FREE;
        this.postRemoveHook();
        return true;
    }

    @Override
    boolean justRemove(E key) {
        return this.remove(key);
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        InternalObjCollectionOps c2;
        if (c instanceof InternalObjCollectionOps && (c2 = (InternalObjCollectionOps)((Object)c)).size() < this.size() && this.equivalence().equals((Object)c2.equivalence())) {
            return c2.reverseRemoveAllFrom((ObjSet<?>)this);
        }
        return this.removeAll(this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

